/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.format.LineWrappingEmitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

final class SavedTextEmitter
extends Emitter {
    private final LineWrappingEmitter printer;
    private int savedTextOffset;
    private String savedTextHeader;
    private int docDepth;

    void $init$() {
        this.printer = new LineWrappingEmitter();
        this.savedTextOffset = -1;
        this.savedTextHeader = "";
        this.docDepth = 0;
    }

    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String string = this.toString();
        textBuffer.insert(0, string.toCharArray());
        return textBuffer;
    }

    public String toString() {
        return this.printer.getBuffer().toString();
    }

    void setFormatDriver(FormatDriver formatDriver) {
        super.setFormatDriver(formatDriver);
        this.printer.setFormatDriver(formatDriver);
    }

    void init(Sym sym) {
        super.init(sym);
        this.printer.init(sym);
    }

    void fini(Sym sym) {
        this.printer.fini(sym);
        super.fini(sym);
    }

    boolean isWrapCapable() {
        return this.printer.isWrapCapable();
    }

    int getColumn() {
        return this.printer.getColumn();
    }

    int getColumnStamp() {
        return this.printer.getColumnStamp();
    }

    void markWrapBoundary(int n) {
        this.printer.markWrapBoundary(n);
    }

    void forceLineWrapping() {
        this.printer.forceLineWrapping();
    }

    void enter(Sym sym) {
        if (sym.is((byte)86)) {
            return;
        }
        if (sym.is((byte)88)) {
            ++this.docDepth;
        }
        if ((sym.symFormat & '\u0001') != 0) {
            this.dirtyOn(sym);
        } else if (sym.symKind == 64) {
            sym.saveText();
        }
        if ((sym.symFormat & 4) != 0) {
            this.savedTextOn(sym);
        }
        this.printer.enter(sym);
    }

    void leave(Sym sym) {
        if (sym.is((byte)86)) {
            return;
        }
        if (sym.is((byte)88)) {
            --this.docDepth;
        }
        this.printer.leave(sym);
        if ((sym.symFormat & '\u0001') != 0) {
            this.dirtyOff(sym);
        }
        if ((sym.symFormat & 4) != 0) {
            this.savedTextOff(sym);
        }
        sym.symFormat = '\u0000';
    }

    void emitIndent(int n) {
        this.printer.emitIndent(n);
    }

    void emit(String string) {
        this.printer.emit(string);
    }

    void emit(short s) {
        this.printer.emit(s);
    }

    void emit(char c) {
        this.printer.emit(c);
    }

    private void dirtyOn(Sym sym) {
        this.savedTextOffset = -1;
    }

    private void dirtyOff(Sym sym) {
    }

    private void savedTextOn(Sym sym) {
        int n;
        if (this.docDepth > 0 && sym.symKind != 64) {
            return;
        }
        StringBuffer stringBuffer = this.printer.getBuffer();
        this.savedTextOffset = n = stringBuffer.length();
        int n2 = LineWrappingEmitter.lastIndexOfNewline(stringBuffer) + 1;
        this.savedTextHeader = n2 < n ? stringBuffer.substring(n2) : "";
    }

    private void savedTextOff(Sym sym) {
        int n;
        int n2;
        String string;
        if (this.savedTextOffset == -1) {
            return;
        }
        StringBuffer stringBuffer = this.printer.getBuffer();
        int n3 = stringBuffer.length();
        int n4 = this.savedTextOffset;
        while (n4 < n3 && Character.isWhitespace(stringBuffer.charAt(n4))) {
            ++n4;
        }
        int n5 = n3;
        while (n4 < n5 && Character.isWhitespace(stringBuffer.charAt(n5 - 1))) {
            --n5;
        }
        String string2 = null;
        if (n5 != n4 && n5 != n3) {
            string2 = stringBuffer.substring(n5, n3);
        }
        String string3 = sym.getText();
        int n6 = n4;
        int n7 = this.savedTextHeader.length();
        if (n7 > 0 && !this.savedTextHeader.equals(string = stringBuffer.substring(n2 = this.savedTextOffset - n7, n = this.savedTextOffset))) {
            n6 = n2;
            string3 = this.savedTextHeader + string3;
        }
        stringBuffer.setLength(n6);
        stringBuffer.append(string3);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        this.printer.clearWrapBoundary();
        this.savedTextOffset = -1;
        ++this.printer.resetCounter;
    }

    SavedTextEmitter() {
        this.$init$();
    }
}

