/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.parser;

import java.util.HashSet;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.internal.parser.ParserLayer1a;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.PlaceholderSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;

abstract class ParserLayer1b
extends ParserLayer1a {
    Sym stackTop;
    Sym[] stack;
    Sym lastPop;
    Sym stackRoot;
    WhitespaceSym lastWhitespace;
    SyntaxData errorData;
    HashSet possibleTypes;
    short stackHeight;
    int lastTokenIndex;
    int errorCount;
    int lastErrorIndex;

    void initializeParserState(FileSym fileSym) {
        this.stackTop = null;
        this.stack = new Sym[4];
        this.stackHeight = 0;
        if (fileSym == null) {
            fileSym = SymFactory.createFile();
        }
        this.symFile = fileSym;
        this.symFile.symStart = 0;
        this.symFile.symData = new SyntaxData();
        this.symFile.tokens = this.tokens;
        this.symFile.j2se = this.j2se;
        this.errorData = new SyntaxData();
        this.errorData.flag_repushed = true;
        this.symFile.parseErrors.treeChildren = Sym.EMPTY_ARRAY;
        this.symFile.parseErrors.symData = this.errorData;
        if (this.textBuffer instanceof TextBuffer) {
            this.symFile.bufferChangeId = ((TextBuffer)this.textBuffer).getChangeId();
        }
        this.possibleTypes = new HashSet();
        this.errorCount = 0;
        this.lastErrorIndex = -1;
        this.lastWhitespace = null;
        this.skipToken();
        this.node((byte)74);
        this.stackRoot = this.stackTop;
        this.stackRoot.symParent = this.symFile;
    }

    final void simple_name() {
        if (this.curToken == 4) {
            this.node((byte)21);
            this.skipToken();
            NameSym nameSym = (NameSym)this.stackTop;
            nameSym.nameString = this.get_name_value();
            this.pop();
        } else if (ParserLayer1b.kw(this.curToken)) {
            this.node((byte)21);
            switch (this.curToken) {
                case 133: 
                case 136: 
                case 141: {
                    break;
                }
                default: {
                    if (ParserLayer1b.primitive(this.curToken)) break;
                    this.errorExpecting((short)4);
                }
            }
            NameSym nameSym = (NameSym)this.stackTop;
            nameSym.nameString = JavaTokens.KW_words[this.curToken - 96];
            this.skipToken();
            this.pop();
        } else {
            this.errorExpecting((short)4);
        }
    }

    final Sym expr_name() {
        Sym sym = this.lastPop;
        try {
            this.node((byte)21);
            this.skipToken();
            NameSym nameSym = (NameSym)this.stackTop;
            SyntaxData syntaxData = (SyntaxData)nameSym.symData;
            syntaxData.flag_noProcess = true;
            nameSym.nameString = this.get_name_value();
            this.pop();
            NameSym nameSym2 = nameSym;
            this.lastPop = sym;
            return nameSym2;
        }
        catch (Throwable throwable) {
            this.lastPop = sym;
            throw throwable;
        }
    }

    final void qualified_name() {
        String string;
        this.node((byte)21);
        this.nextToken((short)4);
        if (this.curToken == 43) {
            StringBuffer stringBuffer = new StringBuffer(this.get_name_value());
            while (this.optionalToken((short)43)) {
                this.nextToken((short)4);
                stringBuffer.append('.');
                stringBuffer.append(this.get_name_value());
            }
            string = stringBuffer.toString();
        } else {
            string = this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = string;
        this.pop();
    }

    final void expr_qualified_name() {
        this.node((byte)21);
        this.nextToken((short)4);
        String string = this.get_name_value();
        while (this.curToken == 43 && this.lookaheadToken() == 4) {
            this.nextToken((short)43);
            this.nextToken((short)4);
            string = string + '.' + this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = string;
        this.pop();
    }

    final void import_qualified_name() {
        String string;
        this.node((byte)21);
        this.nextToken((short)4);
        if (this.curToken == 43) {
            StringBuffer stringBuffer = new StringBuffer(this.get_name_value());
            while (this.optionalToken((short)43)) {
                if (this.curToken == 63) {
                    this.skipToken();
                    stringBuffer.append(".*");
                    continue;
                }
                this.nextToken((short)4);
                stringBuffer.append('.');
                stringBuffer.append(this.get_name_value());
            }
            string = stringBuffer.toString();
        } else {
            string = this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = string;
        this.pop();
    }

    private String get_name_value() {
        int n = this.tokens.tokenEnds[this.lastTokenIndex];
        int n2 = this.tokens.tokenStarts[this.lastTokenIndex];
        int n3 = n - n2;
        if (n3 > 0) {
            return this.textBuffer.getString(n2, n3);
        }
        return "";
    }

    private void set_whitespace_value() {
        WhitespaceSym whitespaceSym = (WhitespaceSym)this.stackTop;
        int n = whitespaceSym.symStart;
        int n2 = this.tokens.tokenEnds[n];
        int n3 = this.tokens.tokenStarts[n];
        int n4 = n2 - n3;
        if (n4 > 0) {
            whitespaceSym.tokenText = this.textBuffer.getString(n3, n4);
        }
    }

    final WhitespaceSym getPrecedingWhitespace(Sym sym) {
        SyntaxData syntaxData = (SyntaxData)sym.symData;
        if (syntaxData != null) {
            return syntaxData.precedingWhitespace;
        }
        return null;
    }

    final void setPrecedingWhitespace(Sym sym, WhitespaceSym whitespaceSym) {
        SyntaxData syntaxData = (SyntaxData)sym.symData;
        if (syntaxData != null) {
            syntaxData.precedingWhitespace = whitespaceSym;
        } else {
            this.internalError();
        }
    }

    final void attachWhitespaceChain(WhitespaceSym whitespaceSym, Sym sym) {
        if (whitespaceSym == null) {
            return;
        }
        if (whitespaceSym.symData == null) {
            return;
        }
        if (sym == null) {
            this.internalError();
        }
        this.attachWhitespaceChain(this.getPrecedingWhitespace(whitespaceSym), sym);
        whitespaceSym.symParent = sym;
        if (whitespaceSym.symStart < sym.symStart) {
            sym.symStart = whitespaceSym.symStart;
        }
        this.processNode(whitespaceSym);
    }

    final void handleWhitespace(WhitespaceSym whitespaceSym, Sym sym) {
        Sym sym2 = sym;
        while (sym2.symParent != null && sym2.symParent.symKind != 74 && whitespaceSym.symStart <= sym2.symParent.symStart) {
            sym2 = sym2.symParent;
        }
        Sym sym3 = sym2.symParent != null ? sym2.symParent : sym2;
        this.attachWhitespaceChain(whitespaceSym, sym3);
    }

    private void handleWhitespaceBeforeSkipping() {
        if (this.lastWhitespace.symParent == this.stackTop || this.stackTop.symStart < this.lastWhitespace.symStart) {
            this.attachWhitespaceChain(this.lastWhitespace, this.stackTop);
        } else {
            this.handleWhitespace(this.lastWhitespace, this.stackTop);
        }
    }

    private void handleOneWhitespaceToken() {
        boolean bl;
        boolean bl2 = bl = this.curToken != 6;
        if (bl) {
            this.node((byte)70);
        } else {
            this.node((byte)72);
        }
        SyntaxData syntaxData = (SyntaxData)this.stackTop.symData;
        syntaxData.flag_noProcess = true;
        WhitespaceSym whitespaceSym = (WhitespaceSym)this.stackTop;
        whitespaceSym.tokenValue = this.curToken;
        if (bl && this.newlineCount > 0) {
            whitespaceSym.symFlags = (byte)(whitespaceSym.symFlags | 0x40);
        }
        super.skipToken();
        if (bl && this.newlineCount > 0) {
            whitespaceSym.symFlags = (byte)(whitespaceSym.symFlags | 0xFFFFFF80);
        }
        this.set_whitespace_value();
        this.pop();
        whitespaceSym.symEnd = whitespaceSym.symStart;
        if (this.lastWhitespace != null) {
            this.setPrecedingWhitespace(whitespaceSym, this.lastWhitespace);
        }
        this.lastWhitespace = whitespaceSym;
    }

    private void saveBlanklines() {
        while (this.newlineCount > 1) {
            this.node((byte)71);
            WhitespaceSym whitespaceSym = (WhitespaceSym)this.stackTop;
            SyntaxData syntaxData = (SyntaxData)this.stackTop.symData;
            syntaxData.flag_noProcess = true;
            this.pop();
            whitespaceSym.symEnd = whitespaceSym.symStart;
            if (this.lastWhitespace != null) {
                this.setPrecedingWhitespace(whitespaceSym, this.lastWhitespace);
            }
            this.lastWhitespace = whitespaceSym;
            this.newlineCount = (byte)(this.newlineCount - 1);
        }
    }

    final void skipToken() {
        if (this.lastWhitespace != null) {
            this.handleWhitespaceBeforeSkipping();
        }
        this.lastWhitespace = null;
        this.lastTokenIndex = this.lexer.getTokenIndex();
        if (this.lastTokenIndex == -1) {
            this.lastTokenIndex = 0;
        }
        super.skipToken();
        int n = 0;
        block3: while (true) {
            switch (this.curToken) {
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    this.saveBlanklines();
                    this.handleOneWhitespaceToken();
                    ++n;
                    continue block3;
                }
            }
            break;
        }
        this.saveBlanklines();
    }

    final void node(byte by) {
        if (this.flag_frozenlexer) {
            this.internalError();
        }
        Sym sym = SymFactory.createNode(this.symFile, by);
        sym.symKind = by;
        if (this.flag_setnew) {
            sym.symFormat = (char)(sym.symFormat | 2);
        }
        this.push(sym);
    }

    final void push(Sym sym) {
        if (this.stack.length == this.stackHeight) {
            Sym[] symArray = new Sym[this.stack.length * 2];
            System.arraycopy(this.stack, 0, symArray, 0, this.stack.length);
            this.stack = symArray;
        }
        if (sym.symData != null) {
            this.internalError();
        }
        SyntaxData syntaxData = new SyntaxData();
        sym.symParent = this.stackTop;
        sym.symStart = this.lexer.getTokenIndex();
        sym.symData = syntaxData;
        syntaxData.stackDepth = this.stackHeight;
        this.lastPop = null;
        short s = this.stackHeight;
        this.stackHeight = (short)(s + 1);
        this.stack[s] = sym;
        this.stackTop = sym;
    }

    final void pop() {
        boolean bl;
        if (this.stackTop != this.stack[this.stackHeight - 1]) {
            this.internalError();
        }
        SyntaxData syntaxData = (SyntaxData)this.stackTop.symData;
        if (this.stackTop.symData == null) {
            this.internalError();
        }
        if (syntaxData.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        this.lastPop = this.stackTop;
        if (this.stackHeight == 0) {
            this.internalError();
        }
        this.stackHeight = (short)(this.stackHeight - 1);
        this.stack[this.stackHeight] = null;
        this.stackTop = this.stackHeight == 0 ? null : this.stack[this.stackHeight - 1];
        boolean bl2 = bl = this.lexer.getTokenIndex() == this.lastPop.symStart && this.lastPop.symKind != 71;
        if (bl && this.lastPop.symKind != 74) {
            this.lastPop = null;
            return;
        }
        this.lastPop.symEnd = this.lastTokenIndex;
        if (!syntaxData.flag_noProcess) {
            this.processNode(this.lastPop);
        }
    }

    final void repush(Sym sym) {
        if (this.stack.length == this.stackHeight) {
            Sym[] symArray = new Sym[this.stack.length * 2];
            System.arraycopy(this.stack, 0, symArray, 0, this.stack.length);
            this.stack = symArray;
        }
        if (sym.symData != null) {
            this.internalError();
        }
        SyntaxData syntaxData = new SyntaxData();
        sym.symData = syntaxData;
        syntaxData.stackDepth = this.stackHeight;
        syntaxData.flag_repushed = true;
        this.lastPop = null;
        short s = this.stackHeight;
        this.stackHeight = (short)(s + 1);
        this.stack[s] = sym;
        this.stackTop = sym;
    }

    final void processNode(Sym sym) {
        try {
            SyntaxData syntaxData = (SyntaxData)sym.symData;
            boolean bl = false;
            if (syntaxData != null) {
                bl = syntaxData.flag_repushed;
            }
            sym.buildSelf();
            sym.symData = null;
            Sym sym2 = sym.symParent;
            if (sym2 != null && !bl && sym.symKind != 0) {
                SyntaxData syntaxData2 = (SyntaxData)sym2.symData;
                syntaxData2.addKid(sym);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            if (this.lastErrorIndex == -1) {
                this.error(23);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            this.error(23);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            this.error(25);
        }
    }

    final void swapChildren(Sym sym, Sym sym2) {
        SyntaxData syntaxData = (SyntaxData)sym.symData;
        SyntaxData syntaxData2 = (SyntaxData)sym2.symData;
        if (syntaxData == null || syntaxData2 == null) {
            this.internalError();
        }
        Sym[] symArray = syntaxData.kids;
        int n = syntaxData.kidCount;
        syntaxData.kids = syntaxData2.kids;
        syntaxData.kidCount = syntaxData2.kidCount;
        syntaxData2.kids = symArray;
        syntaxData2.kidCount = n;
        int n2 = 0;
        while (n2 < syntaxData.kidCount) {
            syntaxData.kids[n2].symParent = sym;
            ++n2;
        }
        int n3 = 0;
        while (n3 < syntaxData2.kidCount) {
            syntaxData2.kids[n3].symParent = sym2;
            ++n3;
        }
    }

    void notImplementedYet(String string) {
        String string2 = ParserLayer1b.error2message(3);
        string2 = ParserLayer1b.format(string2, string);
        this.error(3, string2);
    }

    void internalError() {
        String string = ParserLayer1b.error2message(2);
        this.error(2, string);
        ParserLayer1b.panic(string);
    }

    void error(int n) {
        String string = ParserLayer1b.error2message(n);
        switch (n) {
            case 12: 
            case 16: {
                ClassSym classSym = this.stackTop instanceof ClassSym ? (ClassSym)this.stackTop : this.stackTop.getOwningClassSym();
                if (classSym != null) {
                    int n2 = classSym.getTypeKind();
                    ErrorSym errorSym = this.error(n, string = ParserLayer1b.format(string, JavaConstants.TY_words[n2]));
                    if (errorSym == null) break;
                    errorSym.errorIntData0 = n2;
                    break;
                }
                this.error(n, string);
                break;
            }
            case 25: {
                string = ParserLayer1b.format(string, ParserLayer1b.tokenToString(this.curToken));
            }
            default: {
                this.error(n, string);
            }
        }
    }

    ErrorSym error(int n, String string) {
        if (this.flag_frozenlexer && n != 2) {
            this.internalError();
        }
        int n2 = this.lexer.getTokenIndex();
        if (this.errorCount++ < 32 && this.lastErrorIndex != n2) {
            ErrorSym errorSym = (ErrorSym)SymFactory.createNode(this.symFile, 8);
            int n3 = this.lexer.getTokenIndex();
            errorSym.symParent = this.symFile.parseErrors;
            errorSym.symFile = this.symFile;
            errorSym.symKind = (byte)8;
            errorSym.symStart = n3;
            errorSym.symEnd = n3;
            errorSym.errorCode = (short)n;
            errorSym.errorToken = this.curToken;
            if (!(this.stackTop instanceof PlaceholderSym)) {
                errorSym.errorSymbol = this.stackTop;
            }
            byte by = this.stackTop.symKind;
            String string2 = "";
            if (1 <= by && by < 73) {
                string2 = ParserLayer1b.symbolToString(this.stackTop.symKind);
            }
            if (string2.length() > 0) {
                string = string2 + ": " + string;
            }
            errorSym.errorMessage = string;
            errorSym.buildSelf();
            this.errorData.addKid(errorSym);
            this.lastErrorIndex = n3;
            return errorSym;
        }
        return null;
    }

    void errorExpecting(short s) {
        String string = ParserLayer1b.error2message(10);
        ErrorSym errorSym = this.error(10, string = ParserLayer1b.format(string, ParserLayer1b.tokenToString(s)));
        if (errorSym != null) {
            errorSym.errorIntData0 = s;
        }
    }

    void errorExpecting(short s, short s2) {
        String string = ParserLayer1b.error2message(11);
        ErrorSym errorSym = this.error(11, string = ParserLayer1b.format(string, ParserLayer1b.tokenToString(s), ParserLayer1b.tokenToString(s2)));
        if (errorSym != null) {
            if (s2 < s) {
                short s3 = s;
                s = s2;
                s2 = s3;
            }
            errorSym.errorIntData0 = s;
            errorSym.errorIntData1 = s2;
        }
    }

    private static String symbolToString(byte by) {
        String string = JavaConstants.SRC_words[by - 1];
        if (string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c)) {
            return string;
        }
        return Character.toUpperCase(c) + string.substring(1);
    }

    private static String tokenToString(short s) {
        if (32 <= s && s < 81) {
            return JavaTokens.OP_words[s - 32];
        }
        if (96 <= s && s < 146) {
            return JavaTokens.KW_words[s - 96];
        }
        switch (s) {
            case 4: {
                return "identifier";
            }
            case 0: {
                return "EOF";
            }
            case 6: {
                return "#sql clause";
            }
            case 8: {
                return "integer literal";
            }
            case 10: {
                return "floating-point literal";
            }
            case 12: {
                return "boolean literal";
            }
            case 13: {
                return "character literal";
            }
            case 14: {
                return "string literal";
            }
            case 15: {
                return "null";
            }
            case 24: {
                return "single-line comment";
            }
            case 25: {
                return "multi-line comment";
            }
            case 26: {
                return "javadoc comment";
            }
        }
        return "unknown token";
    }

    ParserLayer1b() {
    }
}

