/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymData;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;

public class SyntaxData
extends SymData
implements InternalConstants {
    public short stackDepth;
    public boolean flag_noProcess;
    public boolean flag_repushed;
    public Sym[] kids;
    public int kidCount;
    public WhitespaceSym precedingWhitespace;

    void $init$() {
        this.stackDepth = 0;
        this.flag_noProcess = false;
        this.flag_repushed = false;
        this.kids = Sym.EMPTY_ARRAY;
        this.kidCount = 0;
        this.precedingWhitespace = null;
    }

    public int getBindingType() {
        return 1;
    }

    public Sym getChild(int n) {
        int n2 = 0;
        while (n2 < this.kidCount) {
            Sym sym = this.kids[n2];
            if (sym.symKind == n) {
                return sym;
            }
            ++n2;
        }
        return null;
    }

    public void addKid(Sym sym) {
        if (sym == null) {
            return;
        }
        this.ensureCapacity(this.kidCount + 1);
        this.kids[this.kidCount++] = sym;
    }

    public void addKids(Sym[] symArray) {
        int n = symArray.length;
        if (n == 0) {
            return;
        }
        this.ensureCapacity(this.kidCount + n);
        int n2 = 0;
        while (n2 < n) {
            this.kids[this.kidCount++] = symArray[n2];
            ++n2;
        }
    }

    private void ensureCapacity(int n) {
        if (n <= this.kids.length) {
            return;
        }
        int n2 = this.kidCount;
        int n3 = n2 == 0 ? 2 : n2 * 2;
        while (n3 < n) {
            n3 *= 2;
        }
        Sym[] symArray = new Sym[n3];
        Sym[] symArray2 = this.kids;
        if (n2 != 0) {
            System.arraycopy(symArray2, 0, symArray, 0, n2);
        }
        this.kids = symArray;
    }

    public void sortKids() {
        if (this.kidCount < 2) {
            return;
        }
        ArrayList<Sym> arrayList = new ArrayList<Sym>();
        int n = 0;
        while (n < this.kidCount) {
            arrayList.add(this.kids[n]);
            ++n;
        }
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        Sym sym = null;
        while (iterator.hasNext()) {
            Sym sym2 = (Sym)iterator.next();
            if (sym != null && sym.compareTo(sym2) == 0) {
                iterator.remove();
            }
            sym = sym2;
        }
    }

    public SyntaxData() {
        this.$init$();
    }
}

