/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;
import oracle.javatools.parser.java.v2.model.SourceLexicalBlankline;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class BlanklineSym
extends WhitespaceSym
implements SourceLexicalBlankline {
    public byte blanklineFollowing;

    void $init$() {
        this.blanklineFollowing = (byte)-1;
        this.tokenValue = (short)5;
        this.tokenText = "\n";
    }

    private byte getFollowingCount() {
        if (this.blanklineFollowing == -1) {
            this.blanklineFollowing = 0;
            Sym sym = this.symParent;
            if (sym instanceof TreeSym) {
                int n = this.symStart;
                TreeSym treeSym = (TreeSym)sym;
                int n2 = treeSym.indexOf(this);
                while ((n2 = treeSym.indexOf((byte)71, n2 + 1)) != -1) {
                    Sym sym2 = treeSym.getNthChild(n2);
                    if (sym2.symStart != n) break;
                    this.blanklineFollowing = (byte)(this.blanklineFollowing + 1);
                }
            }
        }
        return this.blanklineFollowing;
    }

    public final int getLineNumber() {
        LineMap lineMap = this.symFile.getLineMap();
        if (lineMap != null) {
            return this.getLineNumber(lineMap);
        }
        return -1;
    }

    private int getLineNumber(LineMap lineMap) {
        byte by;
        int n = super.getStartOffset();
        if (n < 0) {
            return -1;
        }
        if (n == 0) {
            BlanklineSym.panic("The Sym after a blank line has a zero start offset?");
        }
        if ((by = this.getFollowingCount()) >= 0) {
            int n2 = lineMap.getLineFromOffset(n);
            return n2 - 1 - by;
        }
        return -1;
    }

    public int getStartOffset() {
        int n;
        LineMap lineMap = this.symFile.getLineMap();
        if (lineMap != null && (n = this.getLineNumber(lineMap)) != -1) {
            return lineMap.getLineStartOffset(n);
        }
        return super.getStartOffset();
    }

    public int getEndOffset() {
        int n;
        LineMap lineMap = this.symFile.getLineMap();
        if (lineMap != null && (n = this.getLineNumber(lineMap)) != -1) {
            return lineMap.getLineEndOffset(n);
        }
        return super.getEndOffset();
    }

    public void setText(String string) {
        BlanklineSym.unsupported("May not change text of a blank line.");
    }

    protected int indexSelf(Sym[] symArray, int n, TokenArray tokenArray) {
        return n;
    }

    protected Sym cloneSelfImpl(FileSym fileSym) {
        return SymFactory.createNode(fileSym, this.symKind);
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public BlanklineSym() {
        this.$init$();
    }
}

