/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public final class ClassBodySym
extends TreeSym
implements SourceClassBody {
    public QuickMethod bodyDefaultConstructor;
    public List bodyImplicitMethods;

    public List getSourceMembers() {
        return this.getChildren((byte)80);
    }

    public Collection getSourceMemberVariables() {
        return this.getSyms((byte)91);
    }

    public SourceMemberVariable getSourceMemberVariable(String string) {
        for (EnumConstantSym enumConstantSym : this.getSourceEnumConstants()) {
            if (!string.equals(enumConstantSym.getName())) continue;
            return enumConstantSym;
        }
        for (FieldDeclSym fieldDeclSym : this.getSourceFieldDeclarations()) {
            for (FieldSym fieldSym : fieldDeclSym.getVariables()) {
                if (!string.equals(fieldSym.getName())) continue;
                return fieldSym;
            }
        }
        return null;
    }

    public List getSourceEnumConstants() {
        return this.getChildren((byte)7);
    }

    public List getSourceFieldDeclarations() {
        return this.getChildren((byte)9);
    }

    public Collection getSourceFieldVariables() {
        return this.getSyms((byte)92);
    }

    public SourceFieldVariable getSourceFieldVariable(String string) {
        for (FieldDeclSym fieldDeclSym : this.getSourceFieldDeclarations()) {
            for (FieldSym fieldSym : fieldDeclSym.getVariables()) {
                if (!string.equals(fieldSym.getName())) continue;
                return fieldSym;
            }
        }
        return null;
    }

    public List getSourceMethods() {
        return this.getChildren((byte)19);
    }

    public Collection getSourceMethods(String string) {
        ArrayList<MethodSym> arrayList = new ArrayList<MethodSym>();
        for (MethodSym methodSym : this.getSourceMethods()) {
            if (!string.equals(methodSym.getName())) continue;
            arrayList.add(methodSym);
        }
        return arrayList;
    }

    public List getSourceConstructors() {
        return this.getChildren((byte)6);
    }

    public List getSourceClasses() {
        return this.getChildren((byte)3);
    }

    public List getSourceInitializers() {
        return this.getChildren((byte)5);
    }

    protected Collection getDeclaredConstructors() {
        if (this.bodyDefaultConstructor == null) {
            return this.getObjects((byte)6);
        }
        Sym sym = this.getChild((byte)6);
        if (sym == null) {
            return Arrays.asList(this.bodyDefaultConstructor);
        }
        return InternalConstants.kEmptyList;
    }

    protected Collection getDeclaredMethods() {
        List list = this.getObjects((byte)19);
        if (this.bodyImplicitMethods == null) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        arrayList.addAll(this.bodyImplicitMethods);
        return arrayList;
    }

    protected Collection getDeclaredClasses() {
        return this.getObjects((byte)3);
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }

    protected int getTargetIndex(Sym sym, byte by) {
        int n;
        if (sym.is((byte)81) && (n = this.indexOf((byte)81)) != -1) {
            int n2;
            Sym sym2;
            SourcePreferences sourcePreferences = this.symFile.getPreferences();
            Comparator comparator = sourcePreferences != null ? sourcePreferences.getMemberComparator() : SourceComparator.memberComparator();
            if (comparator.compare(sym, sym2 = this.getNthChild(n)) < 0) {
                return n;
            }
            while ((n2 = this.indexOf((byte)81, n + 1)) != -1) {
                Sym sym3 = this.getNthChild(n2);
                if (comparator.compare(sym, sym3) < 0) {
                    return n + 1;
                }
                n = n2;
            }
        }
        return super.getTargetIndex(sym, by);
    }

    protected void unlinkSelfTrigger(TreeSym treeSym, byte by) {
        this.bodyDefaultConstructor = null;
        this.bodyImplicitMethods = null;
        super.unlinkSelfTrigger(treeSym, by);
    }

    protected void linkChildTrigger(Sym sym, byte by) {
        if (this.bodyDefaultConstructor != null && sym.symKind == 6) {
            this.bodyDefaultConstructor = null;
        }
    }

    protected void unlinkChildTrigger(Sym sym, byte by) {
        if (sym.symKind == 6) {
            this.buildSelf();
        }
    }

    public void buildSelf() {
        ClassSym classSym;
        Sym sym;
        super.buildSelf();
        if (this.count((byte)6) == 0 && (sym = this.getParentSym()) != null && sym.symKind == 3 && !(classSym = (ClassSym)this.symParent).isInterface()) {
            char c = classSym.symAccess;
            c = (char)(c & 7);
            c = (char)(c | 0x1000);
            List<JavaVariable> list = null;
            JavaType javaType = ClassBodySym.getOuterClassOfNonstaticInner(classSym);
            if (javaType != null) {
                QuickLocalVariable quickLocalVariable = QuickLocalVariable.createLocalVariable(javaType, "this$0");
                list = Arrays.asList(quickLocalVariable);
            }
            this.bodyDefaultConstructor = QuickMethod.createMethod(classSym, c, null, "<init>", list, null);
        }
    }

    protected final void buildEnumMethods(ClassSym classSym) {
        this.bodyImplicitMethods = null;
        if (!classSym.isEnum()) {
            return;
        }
        int n = 4105;
        JavaType javaType = ClassBodySym.createArrayType(this.symFile.getProvider(), classSym, 1);
        QuickMethod quickMethod = QuickMethod.createMethod(classSym, '\u1009', javaType, "values", null, null);
        ArrayList<QuickLocalVariable> arrayList = new ArrayList<QuickLocalVariable>();
        QuickHasType quickHasType = QuickHasType.createHasTypeByVMName(this.symFile, "java/lang/String");
        QuickLocalVariable quickLocalVariable = QuickLocalVariable.createLocalVariable(quickHasType, "name");
        arrayList.add(quickLocalVariable);
        QuickMethod quickMethod2 = QuickMethod.createMethod(classSym, '\u1009', classSym, "valueOf", arrayList, null);
        this.bodyImplicitMethods = Arrays.asList(quickMethod, quickMethod2);
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        return compilerDriver.resolve(this);
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }
}

