/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public final class ClassSym
extends MemberSym
implements SourceClass {
    public TypeSym tySuper;

    void $init$() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    public int getTypeKind() {
        return ClassSym.access2ty(this.symAccess);
    }

    public void setTypeKind(int n) {
        char c = this.symAccess;
        c = (char)(c & 0xFFFF9DFF);
        c = (char)(c | ClassSym.ty2access((byte)n));
        this.setAccess(c);
    }

    public boolean isClass() {
        return this.isInterface() ^ true;
    }

    public boolean isInterface() {
        return (this.symAccess & 0x200) != 0;
    }

    public boolean isEnum() {
        return (this.symAccess & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.symAccess & 0x2000) != 0;
    }

    public boolean isExported() {
        Sym sym = this.getParentSym();
        if (sym != null) {
            switch (sym.symKind) {
                case 4: 
                case 11: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isMemberClass() {
        Sym sym = this.getParentSym();
        if (sym != null) {
            return sym.symKind == 4;
        }
        return false;
    }

    public boolean isInnerClass() {
        Sym sym = this.getParentSym();
        if (sym != null) {
            return sym.symKind == 4;
        }
        return false;
    }

    public final boolean flag_anonymous() {
        return this.testSymFlag((byte)-128);
    }

    public boolean isAnonymous() {
        return this.flag_anonymous();
    }

    public String getQualifiedName() {
        String string;
        String string2 = this.getName();
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null && (string = classSym.getQualifiedName()).length() > 0) {
            return string + '.' + string2;
        }
        String string3 = this.getPackageName();
        if (string3.length() == 0) {
            return string2;
        }
        return string3 + '.' + string2;
    }

    public String getVMName() {
        String string;
        int n;
        String string2 = this.getName();
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null && (n = (string = classSym.getVMName()).length()) > 0) {
            return string + '$' + string2;
        }
        String string3 = this.getPackageName();
        if (string3.length() == 0) {
            return string2;
        }
        return string3.replace('.', '/') + '/' + string2;
    }

    public String getRawName() {
        return this.getQualifiedName();
    }

    public String getSourceName() {
        return this.getQualifiedName();
    }

    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    public SourcePackage getSourcePackage() {
        return this.symFile.getSourcePackage();
    }

    public String getPackageName() {
        SourcePackage sourcePackage = this.symFile.getSourcePackage();
        if (sourcePackage != null) {
            return sourcePackage.getName();
        }
        return "";
    }

    public SourceTypeReference getSourceSuperclass() {
        SuperclassSym superclassSym = this.getSuperclassSym();
        if (superclassSym != null) {
            return superclassSym.getSourceSuperclass();
        }
        return null;
    }

    public void setSourceSuperclass(SourceTypeReference sourceTypeReference) {
        this.getSuperclassSym().setSourceSuperclass(sourceTypeReference);
    }

    public List getSourceInterfaces() {
        return this.getInterfacesSym().getSourceInterfaces();
    }

    public List getSourceMembers() {
        return this.getBodySym().getSourceMembers();
    }

    public Collection getSourceMemberVariables() {
        return this.getBodySym().getSourceMemberVariables();
    }

    public SourceMemberVariable getSourceMemberVariable(String string) {
        return this.getBodySym().getSourceMemberVariable(string);
    }

    public List getSourceEnumConstants() {
        return this.getBodySym().getSourceEnumConstants();
    }

    public List getSourceFieldDeclarations() {
        return this.getBodySym().getSourceFieldDeclarations();
    }

    public Collection getSourceFieldVariables() {
        return this.getBodySym().getSourceFieldVariables();
    }

    public SourceFieldVariable getSourceFieldVariable(String string) {
        return this.getBodySym().getSourceFieldVariable(string);
    }

    public List getSourceMethods() {
        return this.getBodySym().getSourceMethods();
    }

    public Collection getSourceMethods(String string) {
        return this.getBodySym().getSourceMethods(string);
    }

    public SourceMethod getSourceMethod(String string, JavaType[] javaTypeArray) {
        JavaMethod javaMethod = this.getDeclaredMethod(string, javaTypeArray);
        if (javaMethod != null) {
            return (SourceMethod)javaMethod.getSourceElement();
        }
        return null;
    }

    public List getSourceConstructors() {
        return this.getBodySym().getSourceConstructors();
    }

    public SourceMethod getSourceConstructor(JavaType[] javaTypeArray) {
        JavaMethod javaMethod = this.getDeclaredConstructor(javaTypeArray);
        if (javaMethod != null) {
            return (SourceMethod)javaMethod.getSourceElement();
        }
        return null;
    }

    public List getSourceClasses() {
        return this.getBodySym().getSourceClasses();
    }

    public List getSourceInitializers() {
        return this.getBodySym().getSourceInitializers();
    }

    public SourceClassBody getSourceBody() {
        return this.getBodySym();
    }

    public SourceClassBody getBody() {
        return this.getSourceBody();
    }

    public ClassBodySym getBodySym() {
        return (ClassBodySym)this.getChild((byte)4);
    }

    public SourceSuperclassClause getSuperclassClause() {
        return this.getSuperclassSym();
    }

    public SourceInterfacesClause getInterfacesClause() {
        return this.getInterfacesSym();
    }

    public SuperclassSym getSuperclassSym() {
        return (SuperclassSym)this.getChildOrCreateSkeleton((byte)23);
    }

    public InterfacesSym getInterfacesSym() {
        return (InterfacesSym)this.getChildOrCreateSkeleton((byte)15);
    }

    public SuperClauseSym getSuperSym() {
        String string = "Deprecated. Get the superclass or the interfaces clause instead!";
        throw new UnsupportedOperationException("Deprecated. Get the superclass or the interfaces clause instead!");
    }

    public int getElementKind() {
        return 3;
    }

    public URL getURL() {
        return this.symFile.getURL();
    }

    public final JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    public final JavaClass getTypeErasure() {
        return this;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public JavaType getComponentType() {
        return null;
    }

    public int getArrayDimensions() {
        return 0;
    }

    public JavaType getBaseComponentType() {
        return null;
    }

    public SourceMember getOwningMember() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.is((byte)80)) {
                return (SourceMember)((Object)sym);
            }
            sym = sym.symParent;
        }
        return null;
    }

    public JavaPackage getPackage() {
        JavaProvider javaProvider = this.symFile.getProvider();
        if (javaProvider == null) {
            return null;
        }
        String string = this.getPackageName();
        return javaProvider.getPackage(string);
    }

    public JavaType getResolvedType() {
        return this;
    }

    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    public JavaType getSuperclass() {
        ClassObj classObj = this.getClassObj();
        if (!classObj.isResolved()) {
            this.resolve();
        }
        return classObj.getSuperclass();
    }

    public Collection getInterfaces() {
        JavaType javaType;
        if (this.tySuper != null && (javaType = this.tySuper.getResolvedType()) != null && javaType.getElementKind() == 3 && javaType.isInterface()) {
            return Arrays.asList(javaType);
        }
        InterfacesSym interfacesSym = this.getInterfacesSym();
        return interfacesSym.getInterfaces();
    }

    public Set getHierarchy() {
        return this.getClassObj().getHierarchy();
    }

    public boolean isAssignableFrom(JavaType javaType) {
        return Conversions.applyAssignmentConversion(javaType, this, false, null);
    }

    public boolean isSubtypeOf(JavaType javaType) {
        return Conversions.isSubtypeOf(this, javaType);
    }

    public Collection getDeclaredFields() {
        return this.getBodySym().getSourceMemberVariables();
    }

    public JavaField getDeclaredField(String string) {
        return CommonUtilities.getDeclaredField(this, string);
    }

    public Collection getDeclaredMethods() {
        return this.getBodySym().getDeclaredMethods();
    }

    public Collection getDeclaredMethods(String string) {
        return CommonUtilities.getDeclaredMethods(this, string);
    }

    public JavaMethod getDeclaredMethod(String string, JavaType[] javaTypeArray) {
        return CommonUtilities.getDeclaredMethod(this, string, javaTypeArray);
    }

    public Collection getDeclaredConstructors() {
        return this.getBodySym().getDeclaredConstructors();
    }

    public JavaMethod getDeclaredConstructor(JavaType[] javaTypeArray) {
        return CommonUtilities.getDeclaredConstructor(this, javaTypeArray);
    }

    public JavaMethod getClinitMethod() {
        ClassObj classObj = this.getClassObj();
        if (!classObj.isResolved()) {
            this.resolve();
        }
        return classObj.getClinitMethod();
    }

    public JavaClass getDeclaredClass(String string) {
        return CommonUtilities.getDeclaredClass(this, string);
    }

    public Collection getDeclaredClasses() {
        return this.getBodySym().getDeclaredClasses();
    }

    public final JavaTypeVariable getTypeParameter(String string) {
        return CommonUtilities.getTypeParameter(this, string);
    }

    public Collection getFields() {
        return CommonUtilities.getFields(this);
    }

    public JavaField getField(String string) {
        return CommonUtilities.getField(this, string);
    }

    public Collection getMethods() {
        return CommonUtilities.getMethods(this);
    }

    public Collection getMethods(String string) {
        return CommonUtilities.getMethods(this, string);
    }

    public JavaMethod getMethod(String string, JavaType[] javaTypeArray) {
        return CommonUtilities.getMethod(this, string, javaTypeArray);
    }

    public Collection getClasses() {
        return CommonUtilities.getClasses(this);
    }

    public JavaClass getClass(String string) {
        return CommonUtilities.getClass(this, string);
    }

    public final Collection getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    public final JavaAnnotation getAnnotation(JavaType javaType) {
        return CommonUtilities.getAnnotation(this, javaType);
    }

    public CompiledTmpVariable getThisValue() {
        return this.getClassObj().getThisValue();
    }

    public JavaVariable getThisVariable() {
        return this.getClassObj().getThisVariable();
    }

    public JavaVariable getSuperVariable() {
        return this.getClassObj().getSuperVariable();
    }

    public boolean equals(Object object) {
        if (object instanceof JavaType) {
            return CommonUtilities.equals(this, (JavaType)object);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        if (this.tySuper != null) {
            this.tySuper.clearCompiledInfo();
        }
    }

    public String printCompiledInfo() {
        return super.printCompiledInfo() + this.getDescriptor();
    }

    protected void add(Sym sym, byte by) {
        ClassBodySym classBodySym;
        if (!this.isValidChild(sym, by) && (classBodySym = this.getBodySym()).isValidChild(sym, by)) {
            classBodySym.add(sym, by);
            return;
        }
        super.add(sym, by);
    }

    protected Sym createSkeleton(byte by) {
        Sym sym = super.createSkeleton(by);
        if (by == 4) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    protected void setupSkeleton() {
        Sym sym = this.getChildOrCreateSkeleton((byte)4);
        sym.buildSelf();
        this.getSuperclassClause();
        this.getInterfacesClause();
    }

    protected int getTargetIndex(Sym sym, byte by) {
        switch (sym.symKind) {
            case 21: {
                int n = this.indexOf((byte)27);
                if (n != -1) {
                    return n;
                }
            }
            case 27: {
                int n = this.indexOf((byte)23);
                if (n != -1) {
                    return n;
                }
            }
            case 23: {
                int n = this.indexOf((byte)15);
                if (n != -1) {
                    return n;
                }
            }
            case 15: {
                int n = this.indexOf((byte)4);
                if (n == -1) break;
                return n;
            }
        }
        return super.getTargetIndex(sym, by);
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 4: 
            case 15: 
            case 21: 
            case 23: 
            case 27: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }

    protected boolean isValidAccess(char c) {
        if (this.isAnonymous()) {
            return c == '\u0000';
        }
        int n = 10241;
        n = (c & 0x200) != 0 ? (int)((char)(n | 0x608)) : ((c & 0x4000) != 0 ? (int)((char)(n | 0x4010)) : (int)((char)(n | 0x418)));
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null) {
            if (!classSym.isInterface()) {
                n = (char)(n | 6);
            }
        } else {
            n = (char)(n & 0xFFFFFFF7);
        }
        return super.isValidAccess((char)(c & ~n));
    }

    protected void setAccess(char c) {
        char c2 = this.symAccess;
        if (c == c2) {
            return;
        }
        byte by = ClassSym.access2ty(c2);
        byte by2 = ClassSym.access2ty(c);
        this.setAccessImpl(c);
        if (by != by2) {
            switch (by2) {
                case 0: {
                    this.objectImplicit = '\u0000';
                    break;
                }
                case 3: {
                    this.objectImplicit = (char)9728;
                    break;
                }
                case 2: {
                    this.objectImplicit = (char)16384;
                    break;
                }
                case 1: {
                    this.objectImplicit = (char)1536;
                }
            }
        }
        this.setAccessTrigger(c2);
    }

    protected void setNameTrigger(String string) {
        super.setNameTrigger(string);
        for (SourceMethod sourceMethod : this.getSourceConstructors()) {
            if (!sourceMethod.isConstructor()) continue;
            sourceMethod.setName(string);
        }
    }

    protected void linkChildTrigger(Sym sym, byte by) {
        super.linkChildTrigger(sym, by);
        if (sym.symKind == 4) {
            sym.buildSelf();
            this.buildSelf();
        }
    }

    public void buildSelf() {
        super.buildSelf();
        NameSym nameSym = this.getNameSym();
        if (nameSym == null) {
            return;
        }
        ClassBodySym classBodySym = this.getBodySym();
        classBodySym.buildEnumMethods(this);
        if (this.isEnum()) {
            for (EnumConstantSym enumConstantSym : this.getSourceEnumConstants()) {
                enumConstantSym.finishSynthetic(nameSym);
            }
        }
    }

    public Sym cloneSelf(FileSym fileSym) {
        ClassSym classSym = (ClassSym)super.cloneSelf(fileSym);
        if (this.tySuper != null) {
            classSym.tySuper = (TypeSym)this.tySuper.cloneSelf(fileSym);
        }
        return classSym;
    }

    protected JavaElement compileImpl(CompilerDriver compilerDriver) {
        if (compilerDriver.inUsageMode()) {
            JavaElement javaElement = super.compileImpl(compilerDriver);
            compilerDriver.compile(this);
            return javaElement;
        }
        this.resolveImpl(compilerDriver);
        for (Sym sym : this.getSourceClasses()) {
            sym.resolve(compilerDriver);
        }
        JavaElement javaElement = super.compileImpl(compilerDriver);
        compilerDriver.compile(this);
        return javaElement;
    }

    public JavaElement resolveImpl(CompilerDriver compilerDriver) {
        return compilerDriver.resolve(this);
    }

    public ClassObj getClassObj() {
        if (this.hasObjData()) {
            return (ClassObj)this.symData;
        }
        ClassObj classObj = new ClassObj();
        classObj.objSym = this;
        this.symData = classObj;
        return classObj;
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public void print(PrintWriter printWriter, int n) {
        switch (n) {
            default: {
                this.print_javadoc(printWriter);
            }
            case 2: {
                this.print_annotations(printWriter);
                this.print_modifiers(printWriter);
                printWriter.print(JavaConstants.TY_words[ClassSym.access2ty(this.symAccess)]);
                printWriter.print(' ');
            }
            case 1: 
        }
        ClassSym.print(this.getNameSym(), printWriter);
        switch (n) {
            default: {
                this.print_ty_parameters(printWriter);
                ClassSym.print(this.getSuperclassSym(), printWriter);
                ClassSym.print(this.getInterfacesSym(), printWriter);
                printWriter.println();
                ClassSym.print(this.getBodySym(), printWriter);
                printWriter.println();
                break;
            }
            case 1: {
                this.print_ty_parameters(printWriter, 1);
                break;
            }
            case 2: {
                this.print_ty_parameters(printWriter);
            }
        }
    }

    public ClassSym() {
        this.$init$();
    }
}

