/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;

public final class ErrorSym
extends Sym
implements SourceError {
    public static final ErrorSym[] EMPTY_ARRAY = new ErrorSym[0];
    public short errorCode;
    public short errorToken;
    public int errorIntData0;
    public int errorIntData1;
    public Object[] errorRefData;
    public String errorMessage;
    public Sym errorSymbol;

    void $init$() {
        this.errorIntData0 = 0;
        this.errorIntData1 = 0;
        this.errorRefData = JavaConstants.EMPTY_OBJECT_ARRAY;
        this.errorSymbol = null;
    }

    public short getErrorCode() {
        return this.errorCode;
    }

    public short getErrorToken() {
        return this.errorToken;
    }

    public int getErrorSeverity() {
        return ErrorSym.error2severity(this.getErrorCode());
    }

    public int getErrorCategory() {
        return ErrorSym.error2category(this.getErrorCode());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SourceElement getErrorSymbol() {
        return this.errorSymbol;
    }

    public int getErrorData0() {
        return this.getErrorIntData0();
    }

    public int getErrorData1() {
        return this.getErrorIntData1();
    }

    public int getErrorIntData0() {
        return this.errorIntData0;
    }

    public int getErrorIntData1() {
        return this.errorIntData1;
    }

    public Object getErrorRefData0() {
        return this.getErrorRefData(0);
    }

    public Object getErrorRefData1() {
        return this.getErrorRefData(1);
    }

    public Object getErrorRefData(int n) {
        if (0 <= n && n < this.errorRefData.length) {
            return this.errorRefData[n];
        }
        return null;
    }

    public int getStartOffset() {
        int n = super.getStartOffset();
        if (n >= 0) {
            return n;
        }
        if (this.errorSymbol != null) {
            return this.errorSymbol.getStartOffset();
        }
        return -1;
    }

    public int getEndOffset() {
        int n = super.getEndOffset();
        if (n >= 0) {
            return n;
        }
        if (this.errorSymbol != null) {
            return this.errorSymbol.getEndOffset();
        }
        return this.getStartOffset();
    }

    public int compareTo(Sym sym) {
        int n = super.compareTo(sym);
        if (n != 0) {
            return n;
        }
        if (sym.symKind == 8) {
            ErrorSym errorSym = (ErrorSym)sym;
            short s = this.errorCode;
            short s2 = errorSym.errorCode;
            return s - s2;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof ErrorSym) {
            return this.equals((ErrorSym)object);
        }
        return super.equals(object);
    }

    public boolean equals(ErrorSym errorSym) {
        if (this == errorSym) {
            return true;
        }
        if (this.errorCode != errorSym.errorCode) {
            return false;
        }
        int n = this.getStartOffset();
        if (n < 0) {
            return false;
        }
        int n2 = errorSym.getStartOffset();
        if (n2 < 0) {
            return false;
        }
        if (n != n2 || this.getEndOffset() != errorSym.getEndOffset()) {
            return false;
        }
        String string = this.getErrorMessage();
        String string2 = errorSym.getErrorMessage();
        return string.equals(string2);
    }

    protected void checkCloneable() {
        ErrorSym.unsupported("May not clone errors.");
    }

    public Sym cloneSelf(FileSym fileSym) {
        ErrorSym errorSym = (ErrorSym)super.cloneSelf(fileSym);
        errorSym.symStart = this.symStart;
        errorSym.symEnd = this.symEnd;
        errorSym.errorCode = this.errorCode;
        errorSym.errorToken = this.errorToken;
        errorSym.errorIntData0 = this.errorIntData0;
        errorSym.errorIntData1 = this.errorIntData1;
        errorSym.errorRefData = (Object[])this.errorRefData.clone();
        errorSym.errorMessage = this.errorMessage;
        if (this.errorSymbol != null) {
            Sym sym = this.errorSymbol.getMapping();
            if (sym == null) {
                ErrorSym.panic("Failed to map the error Sym");
            }
            errorSym.errorSymbol = sym;
        }
        return errorSym;
    }

    protected void verboseSelf(StringBuffer stringBuffer) {
        stringBuffer.append(" \"");
        stringBuffer.append(this.errorMessage);
        stringBuffer.append("\" (");
        stringBuffer.append(this.errorCode);
        stringBuffer.append(')');
    }

    public ErrorSym() {
        this.$init$();
    }
}

