/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.FileObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymIndex;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.UsageHook;
import oracle.javatools.parser.java.v2.model.CancelledException;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourceFileListener;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public final class FileSym
extends ObjectSym
implements SourceFile {
    public URL url;
    private JavaProvider provider;
    private SourcePreferences preferences;
    private SourceFileListener[] listeners;
    private TextBuffer tmpBuffer;
    private TextBuffer pinnedBuffer;
    public int bufferChangeId;
    private CompilerDriver pinnedCompiler;
    private WeakReference compilerReference;
    private volatile Object compilerLock;
    private SymTransaction transaction;
    protected final SymFactory factory;
    public final TreeSym parseErrors;
    public final TreeSym compileErrors;
    public TokenArray tokens;
    public byte j2se;
    public SymIndex pinnedIndex;
    private SoftReference indexReference;
    public List possibleTypes;
    private volatile boolean isExpired;

    void $init$() {
        this.url = null;
        this.provider = null;
        this.listeners = SourceFileListener.EMPTY_ARRAY;
        this.tmpBuffer = null;
        this.pinnedBuffer = null;
        this.bufferChangeId = -1;
        this.pinnedCompiler = null;
        this.compilerReference = null;
        this.transaction = null;
        this.factory = new SymFactory(this);
        this.pinnedIndex = null;
        this.indexReference = null;
        this.possibleTypes = InternalConstants.kEmptyList;
        this.symFile = this;
        this.parseErrors = (TreeSym)SymFactory.createNode(this, 75);
        this.parseErrors.symParent = this;
        this.compileErrors = (TreeSym)SymFactory.createNode(this, 75);
        this.compileErrors.symParent = this;
    }

    protected void finalize() {
        try {
            if (this.transaction != null) {
                this.transaction.abort();
            }
            this.transaction = null;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public int getElementKind() {
        return 6;
    }

    public final boolean flag_noAutoSavepoint() {
        return this.testSymFlag((byte)-128);
    }

    public SourcePackage getSourcePackage() {
        return this.getRoot().getSourcePackage();
    }

    public String getPackageName() {
        SourcePackage sourcePackage = this.getSourcePackage();
        if (sourcePackage == null) {
            return "";
        }
        return sourcePackage.getName();
    }

    public void setSourcePackage(SourcePackage sourcePackage) {
        this.getRoot().setSourcePackage(sourcePackage);
    }

    public void setPackageName(String string) {
        if (string.length() > 0) {
            this.getRoot().setPackageName(string);
        } else {
            RootSym rootSym = this.getRoot();
            PackageSym packageSym = rootSym.getPackageSym();
            if (packageSym != null) {
                packageSym.removeSelf();
            }
        }
    }

    public List getSourceImports() {
        return this.getRoot().getSourceImports();
    }

    public Set getSourceImportNames() {
        return this.getRoot().getSourceImportNames();
    }

    public List getSourceClasses() {
        return this.getRoot().getSourceClasses();
    }

    public SourceClass getSourceClass(String string) {
        return this.getRoot().getSourceClass(string);
    }

    public SourceName getSqlContext() {
        return this.getRoot().getSqlContext();
    }

    public final RootSym getRoot() {
        return (RootSym)this.getChild((byte)74);
    }

    public SourceClass getSourcePrimaryClass() {
        return this.getPrimaryClassSym();
    }

    public ClassSym getPrimaryClassSym() {
        RootSym rootSym = this.getRoot();
        if (this.url != null) {
            String string = this.url.getPath();
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                String string2 = string.substring(n + 1, n2);
                for (ClassSym classSym : rootSym.getSourceClasses()) {
                    if (!string2.equals(classSym.getName())) continue;
                    return classSym;
                }
            }
        }
        return (ClassSym)rootSym.getChild((byte)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaPackage getPackage() {
        JavaProvider javaProvider;
        String string = this.getPackageName();
        FileSym fileSym = this;
        synchronized (fileSym) {
            javaProvider = this.provider;
            if (javaProvider == null) {
                JavaPackage javaPackage = null;
                return javaPackage;
            }
        }
        return javaProvider.getPackage(string);
    }

    public Collection getClasses() {
        return this.getRoot().getClasses();
    }

    public JavaClass getClass(String string) {
        return CommonUtilities.getClass(this, string);
    }

    public JavaClass getPrimaryClass() {
        return this.getPrimaryClassSym();
    }

    public List getPossibleTypes() {
        return this.possibleTypes;
    }

    public boolean hasParseErrors() {
        return this.parseErrors.treeChildren.length > 0;
    }

    public List getParseErrors() {
        return this.parseErrors.getChildren();
    }

    public boolean hasCompileErrors() {
        return this.compileErrors.treeChildren.length > 0;
    }

    public List getCompileErrors() {
        return this.compileErrors.getChildren();
    }

    public boolean hasErrors(int n, int n2) {
        if ((n2 & 2) != 0 && this.hasParseErrors()) {
            for (ErrorSym errorSym : this.getParseErrors()) {
                if (n >= errorSym.getErrorSeverity()) continue;
                return true;
            }
        }
        if ((n2 & 4) != 0) {
            if (!this.isCompiled()) {
                this.compile();
            }
            if (this.hasCompileErrors()) {
                for (ErrorSym errorSym : this.getCompileErrors()) {
                    if (n >= errorSym.getErrorSeverity()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Collection getErrors(int n, int n2) {
        if (!this.hasParseErrors() && !this.hasCompileErrors()) {
            return JavaConstants.kEmptyCollection;
        }
        ArrayList arrayList = new ArrayList();
        if (this.hasParseErrors()) {
            arrayList.addAll(this.getParseErrors());
        }
        if (this.hasCompileErrors()) {
            if (!this.isCompiled()) {
                this.compile();
            }
            arrayList.addAll(this.getCompileErrors());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ErrorSym errorSym = (ErrorSym)iterator.next();
            if (errorSym.getErrorSeverity() >= n) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public final SourceElement getElementAt(int n) {
        return this.getSymAt(n);
    }

    public Sym getSymAt(int n) {
        Sym sym;
        SymIndex symIndex = this.getIndex();
        Sym sym2 = symIndex.getSymAt(n);
        if (sym2 != null) {
            return sym2;
        }
        if (this.symStart > n || n > this.symEnd) {
            return null;
        }
        Sym sym3 = this.getRoot();
        if (sym3 == null) {
            return null;
        }
        while ((sym = ((Sym)sym3).getChildAt(n)) != null) {
            if (sym == sym3 || sym.symStart > n || n > sym.symEnd) {
                FileSym.panic();
            }
            sym3 = sym;
        }
        return sym3;
    }

    public SourceElement getElementAt(int n, int n2) {
        return this.getElementAt(n);
    }

    protected void checkCloneable() {
        FileSym.unsupported("Use cloneSelf(TextBuffer)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceFile cloneSelf(TextBuffer textBuffer) {
        FileSym fileSym;
        TextBuffer textBuffer2 = this.getTextBuffer();
        if (textBuffer2 == null) {
            FileSym.unsupported("No underlying text buffer");
        }
        FileSym fileSym2 = this;
        synchronized (fileSym2) {
            SymTransaction symTransaction = this.getTransactionSym();
            if (symTransaction != null && symTransaction.hasOutstandingChanges()) {
                FileSym.unsupported("Open transaction with outstanding changes");
            }
            if (textBuffer == null) {
                textBuffer = TextBufferFactory.createArrayTextBuffer();
            }
            char[] cArray = textBuffer2.getChars(0, textBuffer2.getLength());
            textBuffer.insert(0, cArray);
            fileSym = SymFactory.createFile();
            fileSym.pinTextBuffer(textBuffer);
            fileSym.buildSelf();
            fileSym.j2se = this.j2se;
            Sym sym = this.cloneSelf(fileSym);
            if (sym != fileSym) {
                FileSym.panic("FileSym mismatch");
            }
            fileSym.adjustSelf((Sym)this);
            fileSym.clearFormatInfo();
        }
        return fileSym;
    }

    public Sym cloneSelfImpl(FileSym fileSym) {
        return fileSym;
    }

    public Sym cloneSelf(FileSym fileSym) {
        FileSym fileSym2 = (FileSym)super.cloneSelf(fileSym);
        if (fileSym2 != fileSym) {
            FileSym.panic("FileSym mismatch");
        }
        fileSym2.url = this.url;
        fileSym2.provider = this.provider;
        fileSym2.preferences = this.preferences;
        fileSym2.possibleTypes = this.possibleTypes;
        return fileSym2;
    }

    public SourceFactory getFactory() {
        return this.factory;
    }

    public SymFactory getSymFactory() {
        return this.factory;
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaProvider getProvider() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            JavaProvider javaProvider = this.provider;
            return javaProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProvider(JavaProvider javaProvider) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.provider = javaProvider;
            this.pinnedCompiler = null;
            if (this.compilerReference != null) {
                this.compilerReference.clear();
            }
            this.compilerReference = null;
        }
    }

    public SourcePreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new SourcePreferences();
        }
        return this.preferences;
    }

    public void setPreferences(SourcePreferences sourcePreferences) {
        this.preferences = sourcePreferences;
    }

    protected void add(Sym sym, byte by) {
        this.getRoot().add(sym, by);
    }

    public List getChildren() {
        return this.getRoot().getChildren();
    }

    public List getChildren(int n) {
        return this.getRoot().getChildren(n);
    }

    public void cancelCompile() {
        if (this.pinnedCompiler == null) {
            return;
        }
        this.pinnedCompiler.cancel();
    }

    public boolean isCompiled() {
        return this.isProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            boolean bl = this.isExpired;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (!this.isExpired) {
                this.isExpired = true;
                if (this.transaction != null) {
                    throw new RuntimeException("Transaction in progress");
                }
                this.cancelCompile();
                int n = this.listeners.length;
                int n2 = n - 1;
                while (n2 >= 0) {
                    this.listeners[n2].expiredUpdate(this);
                    --n2;
                }
                this.listeners = SourceFileListener.EMPTY_ARRAY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSelf() {
        super.buildSelf();
        this.parseErrors.buildSelf();
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer = this.getTextBuffer();
            if (textBuffer != null) {
                int n = textBuffer.getChangeId();
                if (this.tokens == null || n != this.bufferChangeId) {
                    this.clearIndex();
                    JavaLexer javaLexer = new JavaLexer(this.j2se);
                    javaLexer.setTextBuffer(textBuffer);
                    this.tokens = new TokenArray(javaLexer);
                }
                this.bufferChangeId = n;
            }
            this.symEnd = this.tokens.tokenCount - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compileLock() {
        Object object = null;
        FileSym fileSym = this;
        synchronized (fileSym) {
            object = this.compilerLock;
            if (object == null) {
                this.compilerLock = new String("Compile in progress");
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileWait(Object object) {
        Object object2 = object;
        synchronized (object2) {
            int n = 2;
            boolean bl = true;
            while (this.compilerLock != null && this.compilerLock == object) {
                if (bl && this.pinnedCompiler != null) {
                    FileSym.unsupported("Re-entered compile()");
                }
                bl = false;
                try {
                    object.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (--n != 0) continue;
                FileSym.panic("Starved while waiting for the compile to finish");
            }
        }
    }

    public void clearCompiledInfo() {
        if (this.pinnedCompiler != null && !this.isExpired()) {
            FileSym.unsupported("Compile in progress");
        }
        this.compileErrors.treeChildren = Sym.EMPTY_ARRAY;
        super.clearCompiledInfo();
    }

    CompilerDriver createCompiler() {
        if (this.provider == null) {
            return null;
        }
        CompilerDriver compilerDriver = new CompilerDriver(this.provider, this.j2se);
        compilerDriver.setCompilationUnit(this);
        return compilerDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompilerDriver getCompiler() {
        CompilerDriver compilerDriver;
        if (this.pinnedCompiler != null) {
            return this.pinnedCompiler;
        }
        if (this.compilerReference != null && (compilerDriver = (CompilerDriver)this.compilerReference.get()) != null) {
            return compilerDriver;
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.provider == null) {
                CompilerDriver compilerDriver2 = null;
                return compilerDriver2;
            }
            CompilerDriver compilerDriver3 = this.createCompiler();
            this.compilerReference = new WeakReference<CompilerDriver>(compilerDriver3);
            CompilerDriver compilerDriver4 = compilerDriver3;
            return compilerDriver4;
        }
    }

    protected CompilerDriver getForgivingCompiler() {
        JavaProvider javaProvider = this.getProvider();
        if (javaProvider == null) {
            return null;
        }
        CompilerDriver compilerDriver = new CompilerDriver(javaProvider, this.j2se);
        compilerDriver.flag_forgiving = true;
        return compilerDriver;
    }

    public JavaElement processUsages(UsageHook usageHook) {
        CompilerDriver compilerDriver = this.createCompiler();
        if (compilerDriver == null) {
            return null;
        }
        compilerDriver.setUsageHook(usageHook);
        return this.compile(compilerDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaElement compileImpl(CompilerDriver compilerDriver) {
        Object object = this.compileLock();
        if (object != null) {
            this.compileWait(object);
            return this.getCompiledObject();
        }
        Object object2 = this.compilerLock;
        synchronized (object2) {
            try {
                JavaElement javaElement;
                SyntaxData syntaxData;
                this.pinnedCompiler = compilerDriver;
                compilerDriver.clearCancel();
                super.clearCompiledInfo();
                this.symData = null;
                FileObj fileObj = this.getFileObj();
                fileObj.errorData = syntaxData = new SyntaxData();
                try {
                    javaElement = super.compileImpl(compilerDriver);
                }
                catch (CancelledException cancelledException) {
                    javaElement = this.getCompiledObject();
                }
                this.compileErrors.symData = syntaxData;
                this.compileErrors.buildSelf();
                FileSym.removeDuplicateErrors(this.compileErrors);
                this.setProcessed();
                this.pinnedCompiler = null;
                JavaElement javaElement2 = javaElement;
                Object object3 = this.compilerLock;
                this.compilerLock = null;
                object3.notifyAll();
                return javaElement2;
            }
            catch (Throwable throwable) {
                Object object4 = this.compilerLock;
                this.compilerLock = null;
                object4.notifyAll();
                throw throwable;
            }
        }
    }

    private static void removeDuplicateErrors(TreeSym treeSym) {
        Sym[] symArray = treeSym.treeChildren;
        int n = symArray.length;
        if (n < 2) {
            return;
        }
        treeSym.sortSelf();
        ArrayList<Sym> arrayList = new ArrayList<Sym>();
        arrayList.add(symArray[0]);
        int n2 = 1;
        while (n2 < n) {
            Sym sym = symArray[n2];
            Sym sym2 = symArray[n2 - 1];
            if (!sym.equals(sym2)) {
                arrayList.add(sym);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        treeSym.treeChildren = arrayList.toArray(new Sym[n3]);
    }

    public FileObj getFileObj() {
        if (this.hasObjData()) {
            if (this.symData.getBindingType() == 2) {
                return (FileObj)this.symData;
            }
            new IllegalStateException("getFileObj found a SyntaxData").printStackTrace();
            this.buildSelf();
        }
        FileObj fileObj = new FileObj();
        fileObj.objSym = this;
        this.symData = fileObj;
        return fileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormatRegion reformatRegion(int n, int n2) {
        SymTransaction symTransaction;
        SymTransaction symTransaction2 = symTransaction = this.verifyTransaction();
        synchronized (symTransaction2) {
            if (symTransaction.hasOutstandingChanges()) {
                FileSym.unsupported("Cannot format region with outstanding changes");
            }
            if (symTransaction.savepointInProgress()) {
                FileSym.unsupported("Command invalid during savepoint");
            }
            FileSym fileSym = this;
            synchronized (fileSym) {
                FormatRegion formatRegion = FormatRegion.create_fromOffsets(n, n2, this.tokens);
                SymOperation symOperation = symTransaction.newOperation((byte)7);
                symOperation.opTarget = this;
                symOperation.setBinding(formatRegion);
                symOperation.buildSelf();
                symTransaction.savepoint();
                FormatRegion formatRegion2 = formatRegion;
                return formatRegion2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reformatSubtree(Sym sym, int n) {
        SymTransaction symTransaction;
        SymTransaction symTransaction2 = symTransaction = this.verifyTransaction();
        synchronized (symTransaction2) {
            if (symTransaction.savepointInProgress()) {
                FileSym.unsupported("Command invalid during savepoint");
            }
            symTransaction.savepoint();
            FileSym fileSym = this;
            synchronized (fileSym) {
                int n2 = 6;
                SymOperation symOperation = symTransaction.newOperation((byte)6);
                symOperation.opTarget = sym;
                symOperation.buildSelf();
                symTransaction.savepoint();
            }
        }
    }

    protected void adjustOffsets() {
        TextBuffer textBuffer = this.getTextBuffer();
        FileSym fileSym = (FileSym)JavaParser.parse(textBuffer, this.j2se);
        if (fileSym == null) {
            FileSym.panic();
        }
        this.adjustSelf(fileSym);
    }

    protected void adjustSelf(FileSym fileSym) {
        RootSym rootSym = this.getRoot();
        RootSym rootSym2 = fileSym.getRoot();
        rootSym.clearOffsets();
        rootSym.adjustSelf(rootSym2);
        this.tokens = fileSym.tokens;
        this.bufferChangeId = fileSym.bufferChangeId;
        this.possibleTypes = fileSym.possibleTypes;
        this.clearIndex();
        this.parseErrors.treeChildren = Sym.EMPTY_ARRAY;
        SyntaxData syntaxData = new SyntaxData();
        this.parseErrors.symData = syntaxData;
        Sym[] symArray = fileSym.parseErrors.treeChildren;
        int n = symArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sym sym = symArray[n2];
            try {
                Sym sym2 = sym.cloneSelf(this);
                if (sym2 != null) {
                    syntaxData.addKid(sym2);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
        this.buildSelf();
    }

    public void mapSelf(FileSym fileSym) {
        this.mapSelfImpl(fileSym);
        RootSym rootSym = this.getRoot();
        RootSym rootSym2 = fileSym.getRoot();
        rootSym.mapSelf(rootSym2);
    }

    protected void printSelf(FormatDriver formatDriver) {
        RootSym rootSym = this.getRoot();
        if (rootSym != null) {
            rootSym.print(formatDriver);
        }
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 74: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }

    public LineMap getLineMap() {
        TextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer != null) {
            return textBuffer.getLineMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextBuffer getTextBuffer() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer;
            if (this.isExpired) {
                throw new ExpiredTextBufferException();
            }
            if (this.tmpBuffer != null) {
                TextBuffer textBuffer2 = this.tmpBuffer;
                return textBuffer2;
            }
            SymTransaction symTransaction = this.getTransactionSym();
            if (symTransaction != null && (textBuffer = symTransaction.getTextBuffer()) != null) {
                TextBuffer textBuffer3 = textBuffer;
                return textBuffer3;
            }
            if (this.pinnedBuffer != null) {
                TextBuffer textBuffer4 = this.pinnedBuffer;
                return textBuffer4;
            }
        }
        if (this.provider == null || this.url == null) {
            return null;
        }
        TextBuffer textBuffer = this.provider.getTextBuffer(this.url);
        return textBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextBuffer(TextBuffer textBuffer) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedBuffer == null) {
                this.pinnedBuffer = textBuffer;
                this.bufferChangeId = textBuffer.getChangeId();
                BufferTracker bufferTracker = new BufferTracker(this, textBuffer, null);
            } else if (this.pinnedBuffer != textBuffer) {
                FileSym.unsupported("Different pinned buffer");
            }
        }
    }

    public void pinTextBuffer(TextBuffer textBuffer) {
        this.setTextBuffer(textBuffer);
    }

    public void unpinTextBuffer() {
    }

    private int findSourceFileListener(SourceFileListener sourceFileListener) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.listeners[n2] == sourceFileListener) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceFileListener(SourceFileListener sourceFileListener) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int n = this.findSourceFileListener(sourceFileListener);
            if (n != -1) {
                return;
            }
            int n2 = this.listeners.length;
            SourceFileListener[] sourceFileListenerArray = new SourceFileListener[n2 + 1];
            if (n2 > 0) {
                System.arraycopy(this.listeners, 0, sourceFileListenerArray, 0, n2);
            }
            sourceFileListenerArray[n2] = sourceFileListener;
            this.listeners = sourceFileListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceFileListener(SourceFileListener sourceFileListener) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int n = this.findSourceFileListener(sourceFileListener);
            if (n == -1) {
                return;
            }
            int n2 = this.listeners.length;
            if (n2 == 1) {
                this.listeners = SourceFileListener.EMPTY_ARRAY;
            } else {
                SourceFileListener[] sourceFileListenerArray = new SourceFileListener[n2 - 1];
                if (n != 0) {
                    System.arraycopy(this.listeners, 0, sourceFileListenerArray, 0, n);
                }
                if (n != n2 - 1) {
                    System.arraycopy(this.listeners, n + 1, sourceFileListenerArray, n, n2 - 1 - n);
                }
                this.listeners = sourceFileListenerArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(SymTransaction symTransaction) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int n = this.listeners.length;
            int n2 = n - 1;
            while (n2 >= 0) {
                this.listeners[n2].changeUpdate(this, symTransaction);
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceTransaction beginTransaction() {
        if (this.isExpired) {
            throw new ExpiredTextBufferException();
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer;
            if (this.transaction != null) {
                FileSym.errorOpenTransaction();
            }
            if ((textBuffer = this.getTextBuffer()) == null) {
                FileSym.errorNoTextBuffer();
            }
            SymTransaction symTransaction = new SymTransaction(this, textBuffer);
            symTransaction.begin();
            this.transaction = symTransaction;
            SymTransaction symTransaction2 = symTransaction;
            return symTransaction2;
        }
    }

    public SourceTransaction getTransaction() {
        return this.getTransactionSym();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymTransaction getTransactionSym() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            SymTransaction symTransaction = this.transaction;
            return symTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SymTransaction closeTransaction() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.transaction == null) {
                FileSym.errorNoTransaction();
            }
            SymTransaction symTransaction = this.transaction;
            this.transaction = null;
            SymTransaction symTransaction2 = symTransaction;
            return symTransaction2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymIndex getIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedIndex != null) {
                SymIndex symIndex = this.pinnedIndex;
                return symIndex;
            }
            SymIndex symIndex = null;
            if (this.indexReference != null) {
                symIndex = (SymIndex)this.indexReference.get();
            }
            if (symIndex == null) {
                symIndex = this.buildIndex();
            }
            this.indexReference = new SoftReference<SymIndex>(symIndex);
            SymIndex symIndex2 = symIndex;
            return symIndex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymIndex pinIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedIndex != null) {
                SymIndex symIndex = this.pinnedIndex;
                return symIndex;
            }
            SymIndex symIndex = null;
            if (this.indexReference != null) {
                symIndex = (SymIndex)this.indexReference.get();
            }
            if (symIndex == null) {
                symIndex = this.buildIndex();
            }
            this.pinnedIndex = symIndex;
            SymIndex symIndex2 = symIndex;
            return symIndex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpinIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedIndex != null) {
                this.indexReference = new SoftReference<SymIndex>(this.pinnedIndex);
                this.pinnedIndex = null;
            }
        }
    }

    private SymIndex buildIndex() {
        return new SymIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.indexReference = null;
            this.pinnedIndex = null;
        }
    }

    protected int indexSelf(Sym[] symArray, int n, TokenArray tokenArray) {
        RootSym rootSym = this.getRoot();
        n = rootSym.indexSelf(symArray, n, tokenArray);
        int n2 = tokenArray.tokenCount;
        while (n < n2) {
            symArray[n++] = this;
        }
        return n;
    }

    private static boolean isComment(short s) {
        switch (s) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    protected void verboseSelf(StringBuffer stringBuffer) {
        stringBuffer.append(" url ");
        stringBuffer.append(this.getURL());
        stringBuffer.append(" id ");
        stringBuffer.append(System.identityHashCode(this));
    }

    public FileSym() {
        this.$init$();
    }

    private static class BufferTracker
    implements TextBufferListener {
        private WeakReference _sourceFileRef;
        private WeakReference _textBufferRef;

        private BufferTracker(SourceFile sourceFile, TextBuffer textBuffer) {
            this._sourceFileRef = new WeakReference<SourceFile>(sourceFile);
            this._textBufferRef = new WeakReference<TextBuffer>(textBuffer);
            textBuffer.addTextBufferListener(this);
        }

        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            this.bufferChanged();
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            this.bufferChanged();
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
        }

        private void bufferChanged() {
            if (this._sourceFileRef != null) {
                boolean bl = false;
                SourceFile sourceFile = (SourceFile)this._sourceFileRef.get();
                if (sourceFile == null) {
                    bl = true;
                } else if (sourceFile.getTransaction() == null) {
                    bl = true;
                    sourceFile.expire();
                }
                if (bl) {
                    TextBuffer textBuffer = (TextBuffer)this._textBufferRef.get();
                    if (textBuffer != null) {
                        textBuffer.removeTextBufferListener(this);
                    }
                    this._textBufferRef = null;
                    this._sourceFileRef = null;
                }
            }
        }

        BufferTracker(SourceFile sourceFile, TextBuffer textBuffer, 1 var3_3) {
            this(sourceFile, textBuffer);
        }

        public final class 1 {
        }
    }
}

