/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.MethodObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.util.Conversions;

public class MethodSym
extends MemberSym
implements SourceMethod {
    public short methodXDimension;

    void $init$() {
        this.methodXDimension = 0;
    }

    public int getElementKind() {
        return 8;
    }

    public boolean isConstructor() {
        return this.symKind == 6;
    }

    public List getSourceParameters() {
        FormalsSym formalsSym = this.getFormalsSym();
        if (formalsSym != null) {
            return formalsSym.getSourceParameters();
        }
        return InternalConstants.kEmptyList;
    }

    public List getSourceExceptions() {
        ThrowsClauseSym throwsClauseSym = this.getThrowsSym();
        if (throwsClauseSym != null) {
            return throwsClauseSym.getSourceExceptions();
        }
        return InternalConstants.kEmptyList;
    }

    public SourceTypeReference getSourceReturnType() {
        return this.getTypeSym();
    }

    public void setSourceReturnType(SourceTypeReference sourceTypeReference) {
        if (this.isConstructor()) {
            MethodSym.unsupported("Constructor has no return type");
        }
        this.setTypeSym((TypeSym)sourceTypeReference);
    }

    public String getName() {
        if (this.isConstructor()) {
            return "<init>";
        }
        return super.getName();
    }

    public SourceFormalParameterList getFormalParameterList() {
        return this.getFormalsSym();
    }

    public SourceThrowsClause getThrowsClause() {
        return this.getThrowsSym();
    }

    public FormalsSym getFormalsSym() {
        return (FormalsSym)this.getChildOrCreateSkeleton((byte)12);
    }

    public ThrowsClauseSym getThrowsSym() {
        return (ThrowsClauseSym)this.getChildOrCreateSkeleton((byte)25);
    }

    public Expr getDefaultValueSym() {
        return (Expr)this.getChild((byte)84);
    }

    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    public final JavaTypeVariable getTypeParameter(String string) {
        return CommonUtilities.getTypeParameter(this, string);
    }

    public JavaMethod getMethodErasure() {
        return this;
    }

    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    public Collection getParameters() {
        ClassSym classSym;
        JavaType javaType;
        FormalsSym formalsSym = this.getFormalsSym();
        if (formalsSym == null) {
            return InternalConstants.kEmptyList;
        }
        List list = formalsSym.getParameters();
        if (this.isConstructor() && (javaType = MethodSym.getOuterClassOfNonstaticInner(classSym = this.getOwningClassSym())) != null) {
            ArrayList<QuickLocalVariable> arrayList = new ArrayList<QuickLocalVariable>();
            QuickLocalVariable quickLocalVariable = QuickLocalVariable.createLocalVariable(javaType, "this$0");
            quickLocalVariable.setOwner(this);
            arrayList.add(quickLocalVariable);
            arrayList.addAll(list);
            return arrayList;
        }
        return list;
    }

    public JavaType[] getParameterTypes() {
        return CommonUtilities.getParameterTypes(this);
    }

    public Collection getExceptions() {
        ThrowsClauseSym throwsClauseSym = this.getThrowsSym();
        if (throwsClauseSym != null) {
            return throwsClauseSym.getExceptions();
        }
        return InternalConstants.kEmptyList;
    }

    public boolean hasSubsignatureOf(JavaMethod javaMethod) {
        return Conversions.hasSubsignatureOf(this, javaMethod);
    }

    public Collection getOverriddenMethods() {
        return this.getMethodObj().getOverriddenMethods();
    }

    public Object getDefaultValue() {
        Expr expr = this.getDefaultValueSym();
        if (expr != null) {
            return expr.getConstantValue();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof JavaMethod) {
            return CommonUtilities.equals(this, (JavaMethod)object);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 28: {
                return this.isConstructor() ^ true;
            }
            case 2: 
            case 12: 
            case 21: 
            case 25: 
            case 27: {
                return true;
            }
        }
        if (sym.is((byte)84)) {
            return true;
        }
        return super.isValidChild(sym, by);
    }

    protected boolean isValidAccess(char c) {
        ClassSym classSym;
        int n = this.isConstructor() ? 135 : ((classSym = this.getOwningClassSym()) != null && classSym.isInterface() ? 1153 : 3583);
        return super.isValidAccess((char)(c & ~n));
    }

    protected void linkSelfTrigger(TreeSym treeSym, byte by) {
        super.linkSelfTrigger(treeSym, by);
        if (!this.isConstructor()) {
            return;
        }
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null) {
            String string = classSym.getName();
            String string2 = this.getName();
            if (!string2.equals(string)) {
                this.setName(string);
            }
        }
    }

    protected int getTargetIndex(Sym sym, byte by) {
        switch (sym.symKind) {
            case 27: {
                int n = this.indexOf((byte)28);
                if (n != -1) {
                    return n;
                }
            }
            case 28: {
                int n = this.indexOf((byte)21);
                if (n != -1) {
                    return n;
                }
            }
            case 21: {
                int n = this.indexOf((byte)12);
                if (n != -1) {
                    return n;
                }
            }
            case 12: {
                int n = this.indexOf((byte)25);
                if (n != -1) {
                    return n;
                }
            }
            case 25: {
                int n = this.indexOf((byte)2);
                if (n == -1) break;
                return n;
            }
        }
        return super.getTargetIndex(sym, by);
    }

    public void buildSelf() {
        super.buildSelf();
        if (this.isVarargs()) {
            VariableSym variableSym = (VariableSym)this.getFormalsSym().getLastChild((byte)13);
            variableSym.symAccess = (char)(variableSym.symAccess | 0x80);
            TypeSym typeSym = variableSym.getTypeSym();
            typeSym.symAccess = (char)(typeSym.symAccess | 0x80);
        }
        if (this.methodXDimension > 0) {
            TypeSym typeSym = this.getTypeSym();
            typeSym.typeXtraDimension = this.methodXDimension;
        }
    }

    public Sym cloneSelf(FileSym fileSym) {
        MethodSym methodSym = (MethodSym)super.cloneSelf(fileSym);
        methodSym.methodXDimension = this.methodXDimension;
        return methodSym;
    }

    protected void add(Sym sym, byte by) {
        FormalsSym formalsSym;
        if (!this.isValidChild(sym, by) && (formalsSym = this.getFormalsSym()).isValidChild(sym, by)) {
            formalsSym.add(sym, by);
            return;
        }
        super.add(sym, by);
    }

    protected Sym createSkeleton(byte by) {
        Sym sym = super.createSkeleton(by);
        if (by == 12) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    protected void setupSkeleton() {
        this.getFormalsSym();
        this.getThrowsSym();
    }

    public MethodObj getMethodObj() {
        if (this.hasObjData()) {
            return (MethodObj)this.symData;
        }
        MethodObj methodObj = new MethodObj();
        methodObj.objSym = this;
        this.symData = methodObj;
        return methodObj;
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        compilerDriver.resolve(this);
        return this;
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public void print(PrintWriter printWriter, int n) {
        switch (n) {
            default: {
                this.print_javadoc(printWriter);
                this.print_annotations(printWriter);
                this.print_modifiers(printWriter);
                this.print_ty_parameters(printWriter);
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), printWriter, n);
                    printWriter.print(' ');
                }
                MethodSym.print(this.getNameSym(), printWriter, n);
                this.getFormalsSym().print_signature(printWriter, true);
                MethodSym.print(this.getThrowsSym(), printWriter);
                SourceBlock sourceBlock = this.getBlock();
                if (sourceBlock != null) {
                    sourceBlock.print(printWriter, n);
                    break;
                }
                printWriter.println(';');
                break;
            }
            case 1: {
                MethodSym.print(this.getNameSym(), printWriter, n);
                this.getFormalsSym().print_signature(printWriter, false);
                break;
            }
            case 2: {
                this.print_modifiers(printWriter);
                this.print_ty_parameters(printWriter);
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), printWriter, n);
                    printWriter.print(' ');
                }
                MethodSym.print(this.getNameSym(), printWriter, n);
                this.getFormalsSym().print_signature(printWriter, true);
                MethodSym.print(this.getThrowsSym(), printWriter);
            }
        }
    }

    public MethodSym() {
        this.$init$();
    }
}

