/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceName;

public final class NameSym
extends Sym
implements SourceName {
    public String nameString;

    void $init$() {
        this.nameString = "";
    }

    public int getTokenValue() {
        return 4;
    }

    public String getName() {
        return this.getValue();
    }

    public String getText() {
        return this.nameString;
    }

    public void setText(String string) {
        this.nameString = string;
        this.setTextImpl(string);
    }

    public String getValue() {
        return this.nameString;
    }

    public void setValue(String string) {
        if (string.equals(this.nameString)) {
            return;
        }
        if (!this.isValidName(string)) {
            throw new IllegalArgumentException("Invalid name");
        }
        this.setText(string);
        Sym sym = this.getParentSym();
        if (sym != null) {
            ((TreeSym)sym).setNameTrigger(string);
        }
    }

    public Sym cloneSelf(FileSym fileSym) {
        NameSym nameSym = (NameSym)super.cloneSelf(fileSym);
        nameSym.nameString = this.nameString;
        return nameSym;
    }

    private boolean isValidName(String string) {
        Sym sym = this.getParentSym();
        if (sym == null) {
            return NameSym.isValidImportName(string);
        }
        switch (sym.symKind) {
            case 14: {
                return NameSym.isValidImportName(string);
            }
            case 22: 
            case 28: {
                return NameSym.isValidQualifiedName(string);
            }
        }
        return NameSym.isValidSimpleName(string);
    }

    protected void linkSelfTrigger(TreeSym treeSym, byte by) {
        super.linkSelfTrigger(treeSym, by);
        treeSym.setNameTrigger(this.nameString);
    }

    protected void verboseSelf(StringBuffer stringBuffer) {
        stringBuffer.append(' ');
        stringBuffer.append('\"');
        stringBuffer.append(this.nameString);
        stringBuffer.append('\"');
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public void print(PrintWriter printWriter, int n) {
        printWriter.print(this.nameString);
    }

    public NameSym() {
        this.$init$();
    }
}

