/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.util.ArraySortedSet;

public final class RootSym
extends TreeSym {
    void $init$() {
        this.symFlags = (byte)(this.symFlags | 1);
        this.symFlags = (byte)(this.symFlags | 2);
    }

    public SourcePackage getSourcePackage() {
        return this.getPackageSym();
    }

    public PackageSym getPackageSym() {
        return (PackageSym)this.getChild((byte)22);
    }

    public void setSourcePackage(SourcePackage sourcePackage) {
        this.setPackageSym((PackageSym)sourcePackage);
    }

    public void setPackageSym(PackageSym packageSym) {
        this.setSym((byte)22, packageSym);
    }

    public void setPackageName(String string) {
        PackageSym packageSym = this.getPackageSym();
        if (packageSym != null) {
            packageSym.setName(string);
        } else {
            PackageSym packageSym2 = (PackageSym)this.symFile.factory.createPackageDeclaration(string);
            this.linkChild(0, packageSym2);
        }
    }

    public List getSourceImports() {
        return this.getChildren((byte)14);
    }

    public Set getSourceImportNames() {
        return new ImportSet(null);
    }

    public List getSourceClasses() {
        return this.getChildren((byte)3);
    }

    public SourceClass getSourceClass(String string) {
        for (ClassSym classSym : this.getSourceClasses()) {
            if (!string.equals(classSym.getName())) continue;
            return classSym;
        }
        return null;
    }

    public SourceName getSqlContext() {
        return null;
    }

    public Collection getClasses() {
        return this.getObjects((byte)3);
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 3: 
            case 14: 
            case 22: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }

    protected int getTargetIndex(Sym sym, byte by) {
        switch (sym.symKind) {
            case 22: {
                return 0;
            }
            case 14: {
                int n;
                int n2 = this.lastIndexOf((byte)14);
                if (n2 == -1) {
                    int n3 = this.lastIndexOf((byte)22);
                    if (n3 != -1) {
                        return n3 + 1;
                    }
                    return 0;
                }
                Comparator comparator = SourceComparator.hasNameComparator();
                int n4 = n = this.indexOf((byte)14);
                while (n4 <= n2) {
                    if (comparator.compare(sym, this.treeChildren[n4]) < 0) break;
                    ++n4;
                }
                return n4;
            }
        }
        return super.getTargetIndex(sym, by);
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        return null;
    }

    protected JavaElement compileImpl(CompilerDriver compilerDriver) {
        if (!compilerDriver.preloadClasses()) {
            return this.getCompiledObject();
        }
        compilerDriver.resolve(this);
        JavaElement javaElement = super.compileImpl(compilerDriver);
        compilerDriver.compile(this);
        return javaElement;
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public RootSym() {
        this.$init$();
    }

    private class ImportSet
    extends AbstractSet {
        public Iterator iterator() {
            return new ImportSetIterator();
        }

        public boolean isEmpty() {
            return RootSym.this.getChild((byte)14) != null;
        }

        public int size() {
            Set set = this.toStrings();
            return set.size();
        }

        private Set toStrings() {
            ImportSetIterator importSetIterator = new ImportSetIterator();
            while (importSetIterator.hasNext()) {
                importSetIterator.next();
            }
            return ImportSetIterator.ra$processed(importSetIterator);
        }

        public boolean add(String string) {
            if (this.contains(string)) {
                return false;
            }
            SourceFactory sourceFactory = RootSym.this.symFile.getFactory();
            ImportSym importSym = (ImportSym)sourceFactory.createImportDeclaration(string);
            importSym.addSelf(RootSym.this);
            return true;
        }

        public boolean contains(String string) {
            for (ImportSym importSym : RootSym.this.getSourceImports()) {
                if (!string.equals(importSym.getName())) continue;
                return true;
            }
            return false;
        }

        public boolean remove(String string) {
            boolean bl = false;
            Iterator iterator = RootSym.this.getSourceImports().iterator();
            while (iterator.hasNext()) {
                ImportSym importSym = (ImportSym)iterator.next();
                if (!string.equals(importSym.getName())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        public boolean add(Object object) {
            return this.add((String)object);
        }

        public boolean contains(Object object) {
            return this.contains((String)object);
        }

        public boolean remove(Object object) {
            return this.remove((String)object);
        }

        public boolean containsAll(Collection collection) {
            Set set = this.toStrings();
            return set.containsAll(collection);
        }

        public void clear() {
            RootSym.this.getSourceImports().clear();
        }

        private ImportSet() {
        }

        ImportSet(1 var2_2) {
            this();
        }

        private class ImportSetIterator
        implements Iterator {
            private final ArraySortedSet processed;
            private String next;
            private int iteratorNext;

            void $init$() {
                this.processed = new ArraySortedSet();
                this.next = null;
                this.iteratorNext = -1;
            }

            ImportSetIterator() {
                this.$init$();
                this.advance();
            }

            public boolean hasNext() {
                return this.iteratorNext < RootSym.this.treeChildren.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.advance();
                return this.next;
            }

            public void remove() {
                --this.iteratorNext;
                ImportSet.this.remove(this.next);
                this.advance();
            }

            private void advance() {
                int n = RootSym.this.treeChildren.length;
                if (n <= this.iteratorNext) {
                    return;
                }
                ++this.iteratorNext;
                while (this.iteratorNext < RootSym.this.treeChildren.length) {
                    Sym sym = RootSym.this.treeChildren[this.iteratorNext];
                    if (sym.symKind == 14) {
                        ImportSym importSym = (ImportSym)sym;
                        this.next = importSym.getName();
                        if (!this.processed.contains(this.next)) break;
                    }
                    ++this.iteratorNext;
                }
                if (this.next != null) {
                    this.processed.add(this.next);
                }
            }

            static ArraySortedSet ra$processed(ImportSetIterator importSetIterator) {
                return importSetIterator.processed;
            }
        }

        public final class 1 {
        }
    }
}

