/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextCookie;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.SymData;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymText;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.SymUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.UsageHook;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.util.SimplifyTypeHelper;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public abstract class Sym
extends SymUtilities
implements Comparable,
NodeBinding,
JavaElement,
SourceElement {
    protected static final byte ___code_conventions = 0;
    public static final Sym[] EMPTY_ARRAY = new Sym[0];
    private static final boolean[] isTyRef = new boolean[80];
    private static final boolean[] isMemberD = new boolean[80];
    private static final boolean[] isBlockElem = new boolean[80];
    public FileSym symFile;
    public Sym symParent;
    public int symSiblingIndex;
    public byte symKind;
    public byte symFlags;
    public char symAccess;
    public int symStart;
    public int symEnd;
    public transient char symFormat;
    public transient byte symIndent;
    public transient SymData symData;
    public NodeBinding[] symBindings;

    static {
        Sym.isTyRef[28] = true;
        Sym.isMemberD[3] = true;
        Sym.isMemberD[6] = true;
        Sym.isMemberD[7] = true;
        Sym.isMemberD[9] = true;
        Sym.isMemberD[5] = true;
        Sym.isMemberD[19] = true;
        Sym.isBlockElem[3] = true;
        Sym.isBlockElem[18] = true;
        Sym.isBlockElem[24] = true;
        int n = 29;
        while (n < 47) {
            Sym.isBlockElem[n] = true;
            ++n;
        }
    }

    void $init$() {
        this.symParent = null;
        this.symSiblingIndex = -1;
        this.symKind = 0;
        this.symFlags = 0;
        this.symAccess = '\u0000';
        this.symStart = -1;
        this.symEnd = -1;
        this.symFormat = '\u0000';
        this.symIndent = 0;
        this.symData = null;
        this.symBindings = NodeBinding.EMPTY_ARRAY;
    }

    public int getStartOffset() {
        int n = this.getStartIndex();
        if (n == -1) {
            return -1;
        }
        this.ensureSavepoint();
        if (this.symFile.tokens.tokenCount <= n) {
            Sym.panic();
        }
        return this.symFile.tokens.tokenStarts[n];
    }

    public int getEndOffset() {
        int n = this.getEndIndex();
        if (n == -1) {
            if (this.getStartIndex() != -1) {
                return this.getStartOffset();
            }
            return -1;
        }
        this.ensureSavepoint();
        if (this.symFile.tokens.tokenCount <= n) {
            Sym.panic();
        }
        return this.symFile.tokens.tokenEnds[n];
    }

    public final int getStartIndex() {
        return this.symStart;
    }

    public final int getEndIndex() {
        return this.symEnd;
    }

    public String getText() {
        NodeBinding nodeBinding = this.getBinding(4);
        if (nodeBinding != null) {
            return nodeBinding.toString();
        }
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return "";
        }
        this.ensureSavepoint();
        int n = this.getStartOffset();
        if (n == -1) {
            return "";
        }
        int n2 = this.getEndOffset();
        if (n2 <= n) {
            return "";
        }
        String string = textBuffer.getString(n, n2 - n);
        return string;
    }

    protected void setText(String string) {
        Sym.unsupported("Base Sym implementation may not set text");
    }

    protected final void setTextImpl(String string) {
        SymTransaction symTransaction = this.verifyTransaction();
        SymOperation symOperation = symTransaction.newOperation((byte)5);
        symOperation.opTarget = this;
        symOperation.opText = this.getText();
        symOperation.buildSelf();
    }

    public final int getSymbolKind() {
        return this.symKind;
    }

    public int getElementKind() {
        return 0;
    }

    public void simplifyType() {
        SimplifyTypeHelper.simplifyType(this);
    }

    public final void addSelf(SourceElement sourceElement) {
        Sym sym = (Sym)sourceElement;
        sym.add(this);
    }

    public final void replaceSelf(SourceElement sourceElement) {
        Sym sym = (Sym)sourceElement;
        if (this.symParent == null) {
            Sym.errorNoParent();
        }
        this.symParent.replace(this, sym);
    }

    public final void addSelf(SourceElement sourceElement, boolean bl) {
        ListIterator listIterator = sourceElement.getSiblings(458752);
        if (!bl) {
            listIterator.next();
        }
        listIterator.add(this);
    }

    public final void addSelfBefore(SourceElement sourceElement) {
        this.addSelf(sourceElement, true);
    }

    public final void addSelfAfter(SourceElement sourceElement) {
        this.addSelf(sourceElement, false);
    }

    public void removeSelf() {
        if (this.symParent != null) {
            this.symParent.remove(this);
        }
    }

    protected void add(Sym sym) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void replace(Sym sym, Sym sym2) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void remove(Sym sym) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void remove(Sym sym, byte by) {
        Sym.unsupported("Sym may not be parent");
    }

    protected int indexOf(Sym sym) {
        return -1;
    }

    protected int lastIndexOf(Sym sym) {
        return -1;
    }

    public final NodeBinding getBinding(int n) {
        if (this.symData != null && this.symData.getBindingType() == n) {
            return this.symData;
        }
        int n2 = this.symBindings.length;
        int n3 = 0;
        while (n3 < n2) {
            NodeBinding nodeBinding = this.symBindings[n3];
            if (nodeBinding.getBindingType() == n) {
                return nodeBinding;
            }
            ++n3;
        }
        return null;
    }

    public final void setBinding(NodeBinding nodeBinding) {
        switch (nodeBinding.getBindingType()) {
            case 1: 
            case 2: {
                this.symData = (SymData)nodeBinding;
                return;
            }
        }
        int n = nodeBinding.getBindingType();
        int n2 = this.symBindings.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.symBindings[n3].getBindingType() == n) {
                this.symBindings[n3] = nodeBinding;
                return;
            }
            ++n3;
        }
        NodeBinding[] nodeBindingArray = new NodeBinding[n2 + 1];
        if (n2 > 0) {
            System.arraycopy(this.symBindings, 0, nodeBindingArray, 0, n2);
        }
        nodeBindingArray[n2] = nodeBinding;
        this.symBindings = nodeBindingArray;
    }

    public final void clearBinding(int n) {
        if (this.symData != null && this.symData.getBindingType() == n) {
            this.symData = null;
            return;
        }
        int n2 = this.symBindings.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.symBindings[n3].getBindingType() == n) {
                if (n2 == 1) {
                    this.symBindings = NodeBinding.EMPTY_ARRAY;
                    break;
                }
                NodeBinding[] nodeBindingArray = new NodeBinding[n2 - 1];
                if (n3 != 0) {
                    System.arraycopy(this.symBindings, 0, nodeBindingArray, 0, n3);
                }
                if (n3 != n2 - 1) {
                    System.arraycopy(this.symBindings, n3 + 1, nodeBindingArray, n3, n2 - 1 - n3);
                }
                this.symBindings = nodeBindingArray;
                break;
            }
            ++n3;
        }
    }

    public void clearAllBindings(int n) {
        this.clearBinding(n);
    }

    public CallerContext getContext() {
        return this.getContextImpl();
    }

    public void setContext(CallerContext callerContext) {
        this.setContextImpl((CallerContextImpl)callerContext);
    }

    public CallerContextImpl getContextImpl() {
        NodeBinding nodeBinding = this.getBinding(3);
        if (nodeBinding == null) {
            return null;
        }
        CallerContextCookie callerContextCookie = (CallerContextCookie)nodeBinding;
        return callerContextCookie.context;
    }

    public void setContextImpl(CallerContextImpl callerContextImpl) {
        CallerContextImpl callerContextImpl2 = this.getContextImpl();
        if (callerContextImpl2 == null && this.symParent != null) {
            Sym.panic("Cannot have both parent and context");
        }
        if (callerContextImpl == null) {
            this.clearBinding(3);
            this.symParent = null;
        } else {
            CallerContextCookie callerContextCookie = new CallerContextCookie(callerContextImpl);
            this.setBinding(callerContextCookie);
            this.symParent = callerContextImpl.scopeCookie;
        }
    }

    private final void setMapping(Sym sym) {
        this.setBinding(sym);
    }

    public final Sym getMapping() {
        NodeBinding nodeBinding = this.getBinding(5);
        if (nodeBinding != null) {
            return (Sym)nodeBinding;
        }
        return null;
    }

    public int getModifiers() {
        return this.symAccess;
    }

    public final void addModifiers(int n) {
        int n2 = this.symAccess | n;
        int n3 = 7;
        int n4 = n & 7;
        if (n4 != 0) {
            switch (n4) {
                case 1: 
                case 2: 
                case 4: {
                    int n5 = 7 & ~n4;
                    n2 &= ~n5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.setModifiers(n2);
    }

    public final void removeModifiers(int n) {
        this.setModifiers(this.symAccess & ~n);
    }

    public final void setModifiers(int n) {
        char c = (char)n;
        c = (char)(c & 0xFFFF9DFF);
        char c2 = (char)(this.symAccess & 0x6200);
        c = (char)(c | c2);
        this.setModifiersImpl(c);
    }

    protected void setModifiersImpl(char c) {
        this.setAccess(c);
    }

    public List getModifierTokens() {
        return InternalConstants.kEmptyList;
    }

    public List getSourceAnnotations() {
        return InternalConstants.kEmptyList;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.getModifiers() & 7) == 0;
    }

    public final boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public final boolean isSynthetic() {
        return (this.symAccess & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.symAccess & 0x80) != 0;
    }

    public final SourceFile getOwningFile() {
        return this.getOwningSourceFile();
    }

    public final SourceFile getOwningSourceFile() {
        return this.symFile;
    }

    public final SourceElement getParent() {
        return this.getParentSym();
    }

    public final Sym getParentSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if ((sym.symFlags & 2) == 0) {
                return sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public List getChildren() {
        return InternalConstants.kEmptyList;
    }

    public List getChildren(int n) {
        return InternalConstants.kEmptyList;
    }

    public Collection getSyms(byte by) {
        return JavaConstants.kEmptyCollection;
    }

    public final Collection getChildrenRecursive(byte by) {
        ArrayList arrayList = new ArrayList();
        this.getChildrenRecursive(by, arrayList);
        return arrayList;
    }

    protected void getChildrenRecursive(byte by, ArrayList arrayList) {
    }

    public ListIterator getSiblings() {
        Sym sym = this.getParentSym();
        if (sym == null) {
            return InternalConstants.kEmptyList.listIterator();
        }
        TreeSym treeSym = (TreeSym)sym;
        return treeSym.getSiblingsFor(this);
    }

    public ListIterator getSiblings(int n) {
        Sym sym = this.getParentSym();
        if (sym == null) {
            return InternalConstants.kEmptyList.listIterator();
        }
        TreeSym treeSym = (TreeSym)sym;
        return treeSym.getSiblingsFor(this, n);
    }

    public final SourceElement getSiblingBefore() {
        return this.getSiblingSymBefore();
    }

    public final SourceElement getSiblingAfter() {
        return this.getSiblingSymAfter();
    }

    public final Sym getSiblingSymBefore() {
        ListIterator listIterator = this.getSiblings();
        if (listIterator.hasPrevious()) {
            return (Sym)listIterator.previous();
        }
        return null;
    }

    public final Sym getSiblingSymAfter() {
        ListIterator listIterator = this.getSiblings();
        listIterator.next();
        if (listIterator.hasNext()) {
            return (Sym)listIterator.next();
        }
        return null;
    }

    public final boolean isSourceElement() {
        return true;
    }

    public final SourceElement getSourceSymbol() {
        return this;
    }

    public final SourceElement getSourceElement() {
        return this.getSourceSymbol();
    }

    public JavaElement getOwner() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym instanceof ObjectSym) {
                return sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean hasDeprecatedTag() {
        return false;
    }

    public boolean hasHiddenTag() {
        return false;
    }

    public JavaElement getCompiledObject() {
        return null;
    }

    public boolean isProcessed() {
        return false;
    }

    public final void resolve() {
        if (this.isProcessed()) {
            return;
        }
        CallerContextImpl callerContextImpl = this.getContextImpl();
        CompilerDriver compilerDriver = callerContextImpl != null ? callerContextImpl.compiler : this.symFile.getCompiler();
        if (compilerDriver == null) {
            return;
        }
        this.resolve(compilerDriver);
    }

    public final void compile() {
        CompilerDriver compilerDriver = this.symKind == 11 ? this.symFile.createCompiler() : this.symFile.getCompiler();
        if (compilerDriver == null) {
            return;
        }
        this.compile(compilerDriver);
    }

    public void clearOffsets() {
        this.symStart = -1;
        this.symEnd = -1;
    }

    public void clearCompiledInfo() {
        this.symData = null;
    }

    protected void clearFormatInfo() {
        this.symFormat = '\u0000';
        this.clearBinding(4);
        this.clearBinding(5);
    }

    public String printCompiledInfo() {
        return "";
    }

    public final String toString() {
        return this.verbose();
    }

    public int compareTo(Sym sym) {
        if (this == sym) {
            return 0;
        }
        int n = this.symStart;
        int n2 = sym.symStart;
        if (n != n2) {
            return n - n2;
        }
        int n3 = this.symEnd;
        int n4 = sym.symEnd;
        if (n3 != n4) {
            return n4 - n3;
        }
        int n5 = this.getDepth();
        int n6 = sym.getDepth();
        return n5 - n6;
    }

    public int compareTo(Object object) {
        return this.compareTo((Sym)object);
    }

    public int getBindingType() {
        return 5;
    }

    public void buildSelf() {
        this.symData = null;
    }

    public void sortSelf() {
    }

    protected int indexSelf(Sym[] symArray, int n, TokenArray tokenArray) {
        if (!this.isSynthetic() && (this.symFlags & 2) == 0) {
            while (n <= this.symEnd) {
                symArray[n++] = this;
            }
        }
        return n;
    }

    protected void removeSelf(TextBuffer textBuffer) {
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        textBuffer.remove(n, n2 - n);
    }

    public final void visitSelf(SourceVisitor sourceVisitor) {
        this.traverseSelf(sourceVisitor);
    }

    protected final void adjustSelf(Sym sym) {
        this.mapSelf(sym);
        this.traverseSelf(SymAdjustTraversal.singleton);
    }

    protected void adjustSelfImpl(Sym sym) {
        this.symStart = sym.symStart;
        this.symEnd = sym.symEnd;
    }

    protected final void mapSelf(Sym sym) {
        this.traverseDual(sym, SymMappingDualTraversal.singleton);
    }

    protected final void mapSelfImpl(Sym sym) {
        this.setMapping(sym);
        sym.setMapping(this);
    }

    public boolean traverseSelf(SymTraversal symTraversal) {
        try {
            symTraversal.enter(this);
            boolean bl = symTraversal.leave(this);
            return bl;
        }
        catch (TraversalCancelledException traversalCancelledException) {
            boolean bl = false;
            return bl;
        }
    }

    protected boolean traverseDual(Sym sym, SymDualTraversal symDualTraversal) {
        try {
            symDualTraversal.enter(this, sym);
            boolean bl = symDualTraversal.leave(this, sym);
            return bl;
        }
        catch (TraversalCancelledException traversalCancelledException) {
            boolean bl = false;
            return bl;
        }
    }

    public final boolean testSymFlag(byte by) {
        return (this.symFlags & by) != 0;
    }

    public final boolean isScope() {
        return this.testSymFlag((byte)1);
    }

    public final boolean isInvisible() {
        return this.testSymFlag((byte)2);
    }

    public final boolean isSkeleton() {
        return this.testSymFlag((byte)4);
    }

    public final boolean is(byte by) {
        if (1 <= by && by < 80) {
            return this.symKind == by;
        }
        switch (by) {
            case 80: {
                return isMemberD[this.symKind];
            }
            case 81: {
                return isMemberD[this.symKind] && this.symKind != 5;
            }
            case 82: {
                return isBlockElem[this.symKind];
            }
            case 83: {
                return Sym.srcIsStmt(this.symKind);
            }
            case 84: {
                return Sym.srcIsExpr(this.symKind);
            }
            case 85: {
                return this.isScope();
            }
            case 86: {
                return this.isSkeleton();
            }
            case 87: {
                return this.symKind == 63 || this.symKind == 66;
            }
            case 88: {
                return 63 <= this.symKind && this.symKind < 70;
            }
            case 89: {
                return 70 <= this.symKind && this.symKind < 73;
            }
            case 90: {
                return this.symKind == 58 && this.is((byte)86);
            }
            case 91: {
                return this.symKind == 10 || this.symKind == 7;
            }
            case 92: {
                return this.is((byte)10);
            }
            case 93: {
                return this.is((byte)17);
            }
        }
        return true;
    }

    protected final String verbose() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SymFactory.describe(this.symKind));
        stringBuffer.append(" (");
        stringBuffer.append(this.symKind);
        stringBuffer.append(") [");
        stringBuffer.append(this.getStartOffset());
        stringBuffer.append('-');
        stringBuffer.append(this.getEndOffset() - 1);
        stringBuffer.append(']');
        stringBuffer.append(" [");
        stringBuffer.append(this.symStart);
        stringBuffer.append('-');
        stringBuffer.append(this.symEnd);
        stringBuffer.append(']');
        this.verboseSelf(stringBuffer);
        return stringBuffer.toString();
    }

    protected void verboseSelf(StringBuffer stringBuffer) {
    }

    public void describeSelf(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.err.print("..");
            ++n2;
        }
        System.err.print("+-");
        System.err.println(this.verbose());
    }

    public final int getDepth() {
        int n = 0;
        Sym sym = this.symParent;
        while (sym != null) {
            ++n;
            sym = sym.symParent;
        }
        return n;
    }

    public Sym getScope() {
        Sym sym = this.symParent;
        if (sym == null) {
            return null;
        }
        if (sym.is((byte)85)) {
            return sym;
        }
        return sym.getScope();
    }

    public final ClassSym getOwningClassSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.symKind == 3) {
                return (ClassSym)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public final MemberSym getOwningMemberSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.is((byte)80)) {
                return (MemberSym)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    protected final boolean isAttached() {
        Sym sym = this;
        while (sym.symParent != null) {
            sym = sym.symParent;
        }
        return sym == this.symFile;
    }

    public Sym getChildAt(int n) {
        return null;
    }

    protected final boolean hasSyntaxData() {
        return this.symData != null && this.symData.getBindingType() == 1;
    }

    protected final boolean hasObjData() {
        return this.symData != null && this.symData.getBindingType() == 2;
    }

    public final JavaElement resolve(CompilerDriver compilerDriver) {
        return this.resolveImpl(compilerDriver);
    }

    public final JavaElement compile(CompilerDriver compilerDriver) {
        UsageHook usageHook = compilerDriver.getUsageHook();
        if (usageHook != null && !usageHook.shouldTraverse(this)) {
            return null;
        }
        return this.compileImpl(compilerDriver);
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        return this.getCompiledObject();
    }

    protected JavaElement compileImpl(CompilerDriver compilerDriver) {
        return this.resolveImpl(compilerDriver);
    }

    protected void setAccess(char c) {
        char c2 = this.symAccess;
        if (c == c2) {
            return;
        }
        this.setAccessImpl(c);
        this.setAccessTrigger(c2);
    }

    protected final void setAccessImpl(char c) {
        if (!this.isValidAccess(c)) {
            Sym.unsupported("Illegal access mask");
        }
        SymTransaction symTransaction = this.verifyTransaction();
        SymOperation symOperation = symTransaction.newOperation((byte)4);
        symOperation.opTarget = this;
        symOperation.symAccess = this.symAccess;
        this.symAccess = c;
        this.symFormat = (char)(this.symFormat | 8);
        symOperation.buildSelf();
    }

    protected void linkSelfTrigger(TreeSym treeSym, byte by) {
        Sym sym = treeSym;
        while (sym != null) {
            if (sym == this) {
                Sym.errorCycle(this);
            }
            sym = sym.symParent;
        }
    }

    protected void unlinkSelfTrigger(TreeSym treeSym, byte by) {
        this.saveText(treeSym);
        this.symSiblingIndex = -1;
    }

    protected void setAccessTrigger(char c) {
    }

    public final void saveText() {
        this.saveText((TreeSym)null);
    }

    private void saveText(TreeSym treeSym) {
        if (!this.isSynthetic() && this.symStart != -1 && this.getBinding(4) == null) {
            String string = this.getText();
            this.saveText(string, treeSym);
        }
    }

    public final void saveText(ReadTextBuffer readTextBuffer) {
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        if (n >= 0 && n <= n2) {
            String string = readTextBuffer.getString(n, n2 - n);
            this.saveText(string, null);
            return;
        }
        try {
            Sym.panic("Invalid offsets");
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    public final void saveText(SymText symText) {
        this.symFormat = (char)(this.symFormat | 4);
        this.setBinding(symText);
    }

    public final SymText unsaveText() {
        this.symFormat = (char)(this.symFormat & 0xFFFFFFFB);
        SymText symText = (SymText)this.getBinding(4);
        if (symText != null) {
            this.clearBinding(4);
        }
        return symText;
    }

    private final void saveText(String string, TreeSym treeSym) {
        Sym sym;
        if (treeSym == null && (sym = this.getParentSym()) instanceof TreeSym) {
            treeSym = (TreeSym)sym;
        }
        SymText symText = new SymText(string, treeSym);
        this.setBinding(symText);
        this.symFormat = (char)(this.symFormat | 4);
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 72: {
                return true;
            }
            case 70: 
            case 71: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidAccess(char c) {
        return c == '\u0000' || c == '\u1000';
    }

    public boolean checkSourceSanity() {
        return true;
    }

    public final SymTransaction verifyTransaction() {
        SymTransaction symTransaction = this.symFile.getTransactionSym();
        if (symTransaction == null) {
            Sym.unsupported("Must be in a transaction");
        }
        return symTransaction;
    }

    protected final void ensureSavepoint() {
        if ((this.symFormat & 2) == 0) {
            return;
        }
        if (this.symFile.flag_noAutoSavepoint()) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        SymTransaction symTransaction = this.symFile.getTransactionSym();
        if (symTransaction == null) {
            return;
        }
        symTransaction.checkSavepoint();
    }

    protected void checkCloneable() {
    }

    public final SourceElement cloneSelf(SourceFile sourceFile) {
        this.checkCloneable();
        FileSym fileSym = (FileSym)sourceFile;
        Sym sym = this.cloneSelf(fileSym);
        this.clearFormatInfo();
        sym.symFile = this.symFile;
        sym.symStart = this.symStart;
        sym.symEnd = this.symEnd;
        sym.saveText();
        sym.symFile = fileSym;
        sym.symStart = -1;
        sym.symEnd = -1;
        return sym;
    }

    protected Sym cloneSelfImpl(FileSym fileSym) {
        return SymFactory.createNode(fileSym, this.symKind);
    }

    public Sym cloneSelf(FileSym fileSym) {
        Sym sym = this.cloneSelfImpl(fileSym);
        sym.symStart = -1;
        sym.symEnd = -1;
        sym.symFlags = this.symFlags;
        sym.symAccess = this.symAccess;
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.setMapping(this);
        return sym;
    }

    public void qualifySelf() {
    }

    public final void reformatSelf(int n) {
        if (this == this.symFile) {
            this.symFile.reformatSubtree(this.symFile.getRoot(), n);
        } else {
            this.symFile.reformatSubtree(this, n);
        }
    }

    public boolean checkSafeToInsert() {
        return false;
    }

    public boolean checkSafeToDelete(TreeSym treeSym) {
        return false;
    }

    public int getFormatInsertOffset() {
        TreeSym treeSym = (TreeSym)this.symParent;
        Sym[] symArray = treeSym.treeChildren;
        int n = symArray.length;
        if (n < 2) {
            return -1;
        }
        int n2 = treeSym.indexOf(this);
        if (n2 == -1) {
            Sym.errorInvalidParent();
        }
        if (treeSym.symKind == 74) {
            int n3 = n2 + 1;
            while (n3 < n) {
                Sym sym = symArray[n3];
                if (sym.symKind != this.symKind) break;
                if (sym.symStart != -1) {
                    return sym.getFormatStartOffsetImpl();
                }
                ++n3;
            }
            int n4 = n2 - 1;
            while (0 <= n4) {
                Sym sym = symArray[n4];
                if (sym.symKind != this.symKind) break;
                if (sym.symStart != -1) {
                    return sym.getFormatEndOffsetImpl();
                }
                --n4;
            }
            if (n3 < n) {
                return symArray[n3].getFormatStartOffsetImpl();
            }
            if (0 <= n4) {
                return symArray[n4].getFormatEndOffsetImpl();
            }
            if (n2 == n - 1) {
                return treeSym.getEndOffset();
            }
            return treeSym.getStartOffset();
        }
        if (n2 + 1 == symArray.length) {
            return symArray[n2 - 1].getFormatEndOffsetImpl();
        }
        return symArray[n2 + 1].getFormatStartOffsetImpl();
    }

    public final int getFormatStartOffset() {
        boolean bl;
        boolean bl2 = bl = this.getEndOffset() != this.getFormatEndOffsetImpl();
        if (bl) {
            return this.getFormatStartOffsetImpl();
        }
        return this.getStartOffset();
    }

    public final int getFormatEndOffset() {
        return this.getFormatEndOffsetImpl();
    }

    protected final int getFormatStartOffsetImpl() {
        SymText symText;
        int n = this.getStartOffset();
        if (n == -1) {
            return -1;
        }
        Sym sym = this.symParent;
        if (this.symParent == null && (symText = (SymText)this.getBinding(4)) != null) {
            sym = symText.parent;
        }
        if (sym != null && this.getStartIndex() == sym.getStartIndex()) {
            return n;
        }
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return n;
        }
        int n2 = n;
        while (n2 > 0) {
            char c = textBuffer.getChar(n2 - 1);
            switch (c) {
                case '\n': {
                    return n2;
                }
            }
            if (!Character.isWhitespace(c)) {
                return n;
            }
            --n2;
        }
        return 0;
    }

    protected final int getFormatEndOffsetImpl() {
        SymText symText;
        int n = this.getEndIndex();
        if (n == -1) {
            return this.getEndOffset();
        }
        Sym sym = this.symParent;
        if (this.symParent == null && (symText = (SymText)this.getBinding(4)) != null) {
            sym = symText.parent;
        }
        if (sym != null && this.getEndIndex() == sym.getEndIndex()) {
            return this.getEndOffset();
        }
        TokenArray tokenArray = this.symFile.tokens;
        if (tokenArray.tokenCount <= n + 1) {
            return tokenArray.tokenEnds[tokenArray.tokenCount - 1];
        }
        int n2 = this.getEndOffset();
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return n2;
        }
        int n3 = tokenArray.tokenStarts[n + 1];
        int n4 = this.getStartOffset();
        boolean bl = n4 == 0 || n4 != this.getFormatStartOffsetImpl() || textBuffer.getChar(n4 - 1) == '\n';
        int n5 = n2;
        while (n5 < n3) {
            char c = textBuffer.getChar(n5);
            switch (c) {
                case '\n': {
                    if (bl) {
                        return n5 + 1;
                    }
                    return n5;
                }
            }
            ++n5;
        }
        return n3;
    }

    protected static void print(Sym sym, PrintWriter printWriter, int n) {
        if (sym == null) {
            return;
        }
        sym.print(printWriter, n);
    }

    protected static void print(Sym sym, PrintWriter printWriter) {
        if (sym == null) {
            return;
        }
        sym.print(printWriter);
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public final void print(FormatDriver formatDriver) {
        formatDriver.enter(this);
        try {
            try {
                this.printSelf(formatDriver);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        finally {
            formatDriver.leave(this);
        }
    }

    public final void print(PrintWriter printWriter) {
        Emitter emitter = Emitter.createRegularEmitter();
        FormatDriver formatDriver = new FormatDriver(this.symFile, emitter);
        formatDriver.init(this);
        try {
            this.print(formatDriver);
        }
        finally {
            formatDriver.fini(this);
        }
        printWriter.print(emitter.toString());
    }

    public void print(PrintWriter printWriter, int n) {
        this.print(printWriter);
    }

    protected final void print_modifiers(PrintWriter printWriter) {
        if ((this.symAccess & '\u0001') != 0) {
            printWriter.print(Sym.kw2text((short)128) + ' ');
        }
        if ((this.symAccess & 2) != 0) {
            printWriter.print(Sym.kw2text((short)126) + ' ');
        }
        if ((this.symAccess & 4) != 0) {
            printWriter.print(Sym.kw2text((short)127) + ' ');
        }
        if ((this.symAccess & 8) != 0) {
            printWriter.print(Sym.kw2text((short)131) + ' ');
        }
        if ((this.symAccess & 0x10) != 0) {
            printWriter.print(Sym.kw2text((short)111) + ' ');
        }
        if (this.symKind != 3 && (this.symAccess & 0x20) != 0) {
            printWriter.print(Sym.kw2text((short)135) + ' ');
        }
        if (this.symKind == 9) {
            if ((this.symAccess & 0x40) != 0) {
                printWriter.print(Sym.kw2text((short)142) + ' ');
            }
            if ((this.symAccess & 0x80) != 0) {
                printWriter.print(Sym.kw2text((short)139) + ' ');
            }
        }
        if ((this.symAccess & 0x100) != 0) {
            printWriter.print(Sym.kw2text((short)123) + ' ');
        }
        if ((this.symAccess & 0x400) != 0) {
            printWriter.print(Sym.kw2text((short)96) + ' ');
        }
        if ((this.symAccess & 0x800) != 0) {
            printWriter.print(Sym.kw2text((short)132) + ' ');
        }
    }

    public SourceElement[] getContainedElements() {
        List list = this.getChildren();
        int n = list.size();
        return list.toArray(new SourceElement[n]);
    }

    public Sym() {
        this.$init$();
    }

    private static class SymAdjustTraversal
    extends SymTraversal {
        protected static final SymAdjustTraversal singleton = new SymAdjustTraversal();

        protected boolean leave(Sym sym) {
            Sym sym2 = sym.getMapping();
            if (sym2 != null) {
                sym.adjustSelfImpl(sym2);
            }
            return true;
        }

        private SymAdjustTraversal() {
        }
    }

    private static class SymMappingDualTraversal
    extends SymDualTraversal {
        protected static final SymMappingDualTraversal singleton = new SymMappingDualTraversal();

        protected boolean enter(Sym sym, Sym sym2) {
            sym.mapSelfImpl(sym2);
            return true;
        }

        private SymMappingDualTraversal() {
        }
    }

    public static abstract class SymTraversal
    extends SymUtilities {
        protected boolean enter(Sym sym) {
            return true;
        }

        protected boolean leave(Sym sym) {
            return true;
        }
    }

    public static class TraversalCancelledException
    extends RuntimeException {
    }

    public static abstract class SymDualTraversal
    extends SymUtilities {
        protected boolean enter(Sym sym, Sym sym2) {
            return true;
        }

        protected boolean leave(Sym sym, Sym sym2) {
            return true;
        }
    }
}

