/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class SymIndex
extends TreeSym {
    public Sym getSymAt(int n) {
        int n2 = this.getIndexFor(n);
        if (n2 < 0) {
            return null;
        }
        Sym sym = this.treeChildren[n2];
        switch (sym.symKind) {
            case 70: 
            case 71: {
                sym = sym.symParent;
            }
        }
        if (sym.symKind == 64) {
            sym = this.getChildSymAt(sym, n);
        }
        while (sym.testSymFlag((byte)2)) {
            sym = sym.symParent;
        }
        return sym;
    }

    SymIndex(FileSym fileSym) {
        this.symKind = (byte)76;
        this.symFile = fileSym;
        this.buildSelf();
        if (this.treeChildren.length == 0) {
            SymIndex.panic("Empty index");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSelf() {
        FileSym fileSym = this.symFile;
        synchronized (fileSym) {
            TokenArray tokenArray = this.symFile.tokens;
            if (tokenArray == null) {
                SymIndex.panic("No token array");
            }
            int n = tokenArray.tokenCount;
            Sym[] symArray = new Sym[n];
            int n2 = this.symFile.indexSelf(symArray, 0, tokenArray);
            while (n2 < n) {
                symArray[n2++] = this;
            }
            this.treeChildren = symArray;
        }
    }

    private int getIndexFor(int n) {
        if (n < 0) {
            return -1;
        }
        TokenArray tokenArray = this.symFile.tokens;
        int n2 = tokenArray.search(n);
        if (n2 < 0) {
            return -(n2 + 1);
        }
        if (n2 == 0) {
            return 0;
        }
        if (n == tokenArray.tokenStarts[n2]) {
            if (n != tokenArray.tokenEnds[n2 - 1]) {
                return n2;
            }
            Sym sym = this.treeChildren[n2];
            Sym sym2 = this.treeChildren[n2 - 1];
            if (sym == sym2) {
                return n2;
            }
            if (sym.symStart < n2) {
                return n2 - 1;
            }
            if (n2 <= sym2.symEnd) {
                return n2;
            }
            return n2;
        }
        if (this.treeChildren[n2].symStart <= n) {
            return n2;
        }
        if (n <= this.treeChildren[n2 - 1].symEnd) {
            return n2 - 1;
        }
        return -1;
    }

    private Sym getChildSymAt(Sym sym, int n) {
        if (sym instanceof TreeSym) {
            TreeSym treeSym = (TreeSym)sym;
            int n2 = treeSym.treeChildren.length;
            int n3 = 0;
            while (n3 < n2) {
                Sym sym2 = treeSym.treeChildren[n3];
                int n4 = sym2.getStartOffset();
                if (n < n4) break;
                int n5 = sym2.getEndOffset();
                if (n < n5) {
                    return this.getChildSymAt(sym2, n);
                }
                if (n == n5) {
                    Sym sym3;
                    int n6;
                    if (n3 + 1 < n2 && (n6 = (sym3 = treeSym.treeChildren[n3 + 1]).getStartOffset()) == n) {
                        return this.getChildSymAt(sym3, n);
                    }
                    return this.getChildSymAt(sym2, n);
                }
                ++n3;
            }
        }
        return sym;
    }
}

