/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.format.DamageCalculation;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.ImportHelper;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;

public final class SymSavepoint
extends TreeSym
implements SourceSavepoint {
    protected UndoableEdit undoableEdit;
    protected SymTransaction.TextEdit lastIncludedEdit;

    void $init$() {
        this.symKind = (byte)78;
    }

    protected SymSavepoint(SymTransaction symTransaction) {
        this.$init$();
        this.symParent = symTransaction;
        this.symFile = symTransaction.symFile;
    }

    public void undoSelf() {
        int n = this.treeChildren.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            SymOperation symOperation = (SymOperation)this.treeChildren[n2];
            symOperation.undoSelf();
            --n2;
        }
        if (this.undoableEdit != null) {
            this.undoableEdit.undo();
        }
        this.symFile.adjustOffsets();
    }

    public void buildSelf() {
        SyntaxData syntaxData = (SyntaxData)this.symData;
        super.buildSelf();
        syntaxData.kidCount = 0;
    }

    public void preprocessSelf() {
        ImportHelper importHelper = new ImportHelper(this.symFile);
        importHelper.process();
    }

    public void processSelf() {
        if (this.treeChildren.length == 0) {
            SymSavepoint.panic();
        }
        int n = this.treeChildren.length;
        SymOperation[] symOperationArray = new SymOperation[n];
        System.arraycopy(this.treeChildren, 0, symOperationArray, 0, n);
        DamageCalculation.preprocess(symOperationArray);
        Emitter emitter = Emitter.createSavedTextEmitter();
        FileSym fileSym = SymSavepoint.getFormattedFile(this.symFile, emitter);
        this.symFile.mapSelf(fileSym);
        TokenMap tokenMap = new TokenMap(this.symFile, fileSym);
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        textBuffer.beginEdit();
        try {
            FormatRegion[] formatRegionArray = DamageCalculation.process(symOperationArray, tokenMap);
            int n2 = formatRegionArray.length;
            int n3 = n2 - 1;
            while (n3 >= 0) {
                FormatRegion formatRegion = formatRegionArray[n3];
                SymSavepoint.performRegionReplace(formatRegion, this.symFile, fileSym);
                --n3;
            }
        }
        finally {
            this.undoableEdit = textBuffer.endEdit();
        }
        this.symFile.adjustOffsets();
        this.symFile.clearFormatInfo();
    }

    private static FileSym getFormattedFile(FileSym fileSym, Emitter emitter) {
        FormatDriver formatDriver = new FormatDriver(fileSym, emitter);
        formatDriver.init(fileSym);
        try {
            fileSym.print(formatDriver);
        }
        finally {
            formatDriver.fini(fileSym);
        }
        TextBuffer textBuffer = emitter.getOutputBuffer();
        FileSym fileSym2 = (FileSym)JavaParser.parse(textBuffer, fileSym.j2se);
        fileSym2.setTextBuffer(textBuffer);
        return fileSym2;
    }

    private static void performRegionReplace(FormatRegion formatRegion, FileSym fileSym, FileSym fileSym2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = formatRegion.fromIndices.getStartOffset();
        int n7 = formatRegion.toIndices.getStartOffset();
        if (n6 == 0 && n7 == 0) {
            n5 = 0;
            n4 = 0;
        } else {
            n5 = fileSym.tokens.tokenStarts[n6];
            n4 = fileSym2.tokens.tokenStarts[n7];
        }
        TextBuffer textBuffer = fileSym2.getTextBuffer();
        TextBuffer textBuffer2 = fileSym.getTextBuffer();
        int n8 = formatRegion.fromIndices.getEndOffset();
        int n9 = formatRegion.toIndices.getEndOffset();
        if (n8 >= fileSym.tokens.tokenCount - 2 && n9 >= fileSym2.tokens.tokenCount - 2) {
            n3 = textBuffer2.getLength();
            n2 = textBuffer.getLength();
        } else {
            n3 = fileSym.tokens.tokenEnds[n8];
            n2 = fileSym2.tokens.tokenEnds[n9];
        }
        int n10 = n3 - n5;
        if (n10 < 0) {
            SymSavepoint.panic();
        }
        if ((n = n2 - n4) < 0) {
            SymSavepoint.panic();
        }
        char[] cArray = textBuffer.getChars(n4, n);
        CompareUtils.replaceText(textBuffer2, n5, n10, cArray);
    }
}

