/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Collection;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymSavepoint;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.java.v2.write.SourceTransactionListener;

final class SymTransaction
extends TreeSym
implements TextBufferListener,
SourceTransaction {
    protected TextBuffer realTextBuffer;
    protected TextBuffer copyTextBuffer;
    protected TextBuffer transTextBuffer;
    public SyntaxData transData;
    private final TextEdit transEditFront;
    private TextEdit transEditBack;
    private SourceTransactionListener[] listeners;

    void $init$() {
        this.transEditBack = this.transEditFront = new TextEdit(0, 0, null);
        this.listeners = SourceTransactionListener.EMPTY_ARRAY;
        this.symKind = (byte)79;
    }

    SymTransaction(FileSym fileSym, TextBuffer textBuffer) {
        this.$init$();
        if (fileSym == null) {
            throw new IllegalArgumentException();
        }
        this.symParent = fileSym;
        this.symFile = fileSym;
        this.transData = new SyntaxData();
        if (textBuffer == null) {
            throw new IllegalArgumentException("File has no text buffer");
        }
        this.realTextBuffer = textBuffer;
    }

    public final boolean flag_saving() {
        return this.testSymFlag((byte)-128);
    }

    public boolean hasOutstandingChanges() {
        return this.transData.kidCount > 0;
    }

    public boolean savepointInProgress() {
        return this.flag_saving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSavepoint() {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            if (this.savepointInProgress()) {
                return;
            }
            this.savepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceSavepoint savepoint() {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            if ((this.symFlags & 0xFFFFFF80) != 0) {
                SymTransaction.panic("Savepoint already in progress");
            }
            this.symFlags = (byte)(this.symFlags | 0xFFFFFF80);
            this.symFile.symFlags = (byte)(this.symFile.symFlags | 0xFFFFFF80);
            try {
                try {
                    if (this.transData.kidCount == 0) {
                        SymSavepoint symSavepoint = (SymSavepoint)this.getLastChild((byte)78);
                        this.symFile.symFlags = (byte)(this.symFile.symFlags & 0x7F);
                        this.symFlags = (byte)(this.symFlags & 0x7F);
                        return symSavepoint;
                    }
                    int n = this.lastIndexOf((byte)78);
                    SymSavepoint symSavepoint = new SymSavepoint(this);
                    this.symFile.clearCompiledInfo();
                    symSavepoint.preprocessSelf();
                    int n2 = this.treeChildren.length;
                    int n3 = n + 1;
                    while (n3 < n2) {
                        this.transData.addKid(this.treeChildren[n3]);
                        ++n3;
                    }
                    symSavepoint.symData = this.transData;
                    symSavepoint.buildSelf();
                    symSavepoint.processSelf();
                    symSavepoint.lastIncludedEdit = this.transEditBack;
                    symSavepoint.symData = this.transData;
                    symSavepoint.buildSelf();
                    if (this.transData.kidCount > 0) {
                        SymTransaction.panic();
                    }
                    this.transData.addKid(symSavepoint);
                    this.buildSelf();
                    this.symFile.clearCompiledInfo();
                    SymSavepoint symSavepoint2 = symSavepoint;
                    this.symFile.symFlags = (byte)(this.symFile.symFlags & 0x7F);
                    this.symFlags = (byte)(this.symFlags & 0x7F);
                    return symSavepoint2;
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                this.symFile.symFlags = (byte)(this.symFile.symFlags & 0x7F);
                this.symFlags = (byte)(this.symFlags & 0x7F);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(SourceSavepoint sourceSavepoint) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            SymSavepoint symSavepoint = (SymSavepoint)sourceSavepoint;
            int n = this.indexOf(symSavepoint);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            int n2 = this.transData.kidCount;
            Sym[] symArray = this.transData.kids;
            this.transData = new SyntaxData();
            int n3 = n2 - 1;
            while (n3 >= 0) {
                SymOperation symOperation = (SymOperation)symArray[n3];
                symOperation.undoSelf();
                --n3;
            }
            int n4 = this.treeChildren.length;
            int n5 = n4 - 1;
            while (n5 > n) {
                SymSavepoint symSavepoint2 = (SymSavepoint)this.treeChildren[n5];
                symSavepoint2.undoSelf();
                --n5;
            }
            this.transData.kidCount = 0;
            TextEdit.wa$next(symSavepoint.lastIncludedEdit, null);
            this.symFile.clearFormatInfo();
            this.symFile.adjustOffsets();
            Sym[] symArray2 = new Sym[n + 1];
            System.arraycopy(this.treeChildren, 0, symArray2, 0, n + 1);
            this.treeChildren = symArray2;
            this.symFile.buildSelf();
            this.symFile.clearCompiledInfo();
        }
    }

    public void rollback() {
        this.rollback((SymSavepoint)this.treeChildren[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit commit() {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            this.realTextBuffer.beginEdit();
            try {
                this.savepoint();
                SymTransaction.performTextEdits(this.realTextBuffer, this.transEditFront);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
            UndoableEdit undoableEdit = this.realTextBuffer.endEdit();
            this.close(true);
            this.symFile.notify(this);
            UndoableEdit undoableEdit2 = undoableEdit;
            return undoableEdit2;
        }
    }

    public void abort() {
        try {
            this.rollback();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        this.close(false);
    }

    protected TextBuffer getTextBuffer() {
        return this.transTextBuffer;
    }

    public Collection getChanges() {
        return InternalConstants.kEmptyList;
    }

    public Collection getChanges(SourceSavepoint sourceSavepoint, SourceSavepoint sourceSavepoint2) {
        return InternalConstants.kEmptyList;
    }

    protected void begin() {
        this.realTextBuffer.writeLock();
        this.copyTextBuffer = SymTransaction.acquireTextBuffer();
        char[] cArray = this.realTextBuffer.getChars(0, this.realTextBuffer.getLength());
        this.copyTextBuffer.insert(0, cArray);
        this.copyTextBuffer.addTextBufferListener(this);
        this.transTextBuffer = this.copyTextBuffer;
        SymSavepoint symSavepoint = new SymSavepoint(this);
        symSavepoint.lastIncludedEdit = this.transEditBack;
        this.treeChildren = new Sym[]{symSavepoint};
    }

    private void close(boolean bl) {
        SymTransaction symTransaction = this.symFile.getTransactionSym();
        if (symTransaction != this) {
            SymTransaction.panic();
        }
        this.transTextBuffer = null;
        this.copyTextBuffer.removeTextBufferListener(this);
        SymTransaction.releaseTextBuffer(this.copyTextBuffer);
        this.copyTextBuffer = null;
        this.realTextBuffer.writeUnlock();
        this.symFile.closeTransaction();
        int n = this.listeners.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            this.listeners[n2].closeUpdate(this, bl);
            --n2;
        }
        this.listeners = SourceTransactionListener.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SymOperation newOperation(byte by) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            SymOperation symOperation = new SymOperation(this, by);
            this.transData.addKid(symOperation);
            SymOperation symOperation2 = symOperation;
            return symOperation2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOperation(SymOperation symOperation) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            int n = this.listeners.length;
            int n2 = n - 1;
            while (n2 >= 0) {
                this.listeners[n2].changeUpdate(this, null);
                --n2;
            }
        }
    }

    public void buildSelf() {
        this.symData = this.transData;
        super.buildSelf();
        this.transData.kidCount = 0;
    }

    private int findListener(SourceTransactionListener sourceTransactionListener) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.listeners[n2] == sourceTransactionListener) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SourceTransactionListener sourceTransactionListener) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            int n = this.findListener(sourceTransactionListener);
            if (n != -1) {
                return;
            }
            int n2 = this.listeners.length;
            SourceTransactionListener[] sourceTransactionListenerArray = new SourceTransactionListener[n2 + 1];
            if (n2 > 0) {
                System.arraycopy(this.listeners, 0, sourceTransactionListenerArray, 0, n2);
            }
            sourceTransactionListenerArray[n2] = sourceTransactionListener;
            this.listeners = sourceTransactionListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SourceTransactionListener sourceTransactionListener) {
        SymTransaction symTransaction = this;
        synchronized (symTransaction) {
            int n = this.findListener(sourceTransactionListener);
            if (n == -1) {
                return;
            }
            int n2 = this.listeners.length;
            if (n2 == 1) {
                this.listeners = SourceTransactionListener.EMPTY_ARRAY;
            } else {
                SourceTransactionListener[] sourceTransactionListenerArray = new SourceTransactionListener[n2 - 1];
                if (n != 0) {
                    System.arraycopy(this.listeners, 0, sourceTransactionListenerArray, 0, n);
                }
                if (n != n2 - 1) {
                    System.arraycopy(this.listeners, n + 1, sourceTransactionListenerArray, n, n2 - 1 - n);
                }
                this.listeners = sourceTransactionListenerArray;
            }
        }
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        TextEdit textEdit = new TextEdit(n, cArray, null);
        TextEdit.wa$next(this.transEditBack, textEdit);
        this.transEditBack = textEdit;
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        TextEdit textEdit = new TextEdit(n, n2, null);
        TextEdit.wa$next(this.transEditBack, textEdit);
        this.transEditBack = textEdit;
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    private static void performTextEdits(TextBuffer textBuffer, TextEdit textEdit) {
        TextEdit textEdit2 = textEdit;
        while (textEdit2 != null) {
            if (TextEdit.ra$insertedData(textEdit2) != null) {
                textBuffer.insert(TextEdit.ra$offset(textEdit2), TextEdit.ra$insertedData(textEdit2));
            } else {
                textBuffer.remove(TextEdit.ra$offset(textEdit2), TextEdit.ra$count(textEdit2));
            }
            textEdit2 = TextEdit.ra$next(textEdit2);
        }
    }

    protected static class TextEdit {
        private final int offset;
        private final int count;
        private final char[] insertedData;
        private TextEdit next;

        void $init$() {
            this.next = null;
        }

        private TextEdit(int n, char[] cArray) {
            this.$init$();
            this.offset = n;
            this.count = 0;
            this.insertedData = cArray;
        }

        private TextEdit(int n, int n2) {
            this.$init$();
            this.offset = n;
            this.count = n2;
            this.insertedData = null;
        }

        static char[] ra$insertedData(TextEdit textEdit) {
            return textEdit.insertedData;
        }

        static int ra$offset(TextEdit textEdit) {
            return textEdit.offset;
        }

        static int ra$count(TextEdit textEdit) {
            return textEdit.count;
        }

        static TextEdit ra$next(TextEdit textEdit) {
            return textEdit.next;
        }

        TextEdit(int n, int n2, 1 var3_3) {
            this(n, n2);
        }

        static void wa$next(TextEdit textEdit, TextEdit textEdit2) {
            textEdit.next = textEdit2;
        }

        TextEdit(int n, char[] cArray, 1 var3_3) {
            this(n, cArray);
        }

        public final class 1 {
        }
    }
}

