/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.IndirectSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.SymUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public class TreeSym
extends Sym {
    public Sym[] treeChildren;

    void $init$() {
        this.treeChildren = Sym.EMPTY_ARRAY;
    }

    public final SourceName getNameElement() {
        return this.getNameSym();
    }

    public void setNameElement(SourceName sourceName) {
        this.setNameSym((NameSym)sourceName);
    }

    public String getName() {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            return nameSym.getValue();
        }
        return "";
    }

    public void setName(String string) {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            if (!string.equals(nameSym.getValue())) {
                nameSym.setValue(string);
            }
        } else {
            NameSym nameSym2 = (NameSym)this.symFile.factory.createName(string);
            this.setNameSym(nameSym2);
        }
    }

    public final SourceBlock getBlock() {
        return this.getBlockSym();
    }

    public final void setBlock(SourceBlock sourceBlock) {
        this.setBlockSym((BlockSym)sourceBlock);
    }

    public final SourceTypeReference getSourceType() {
        return this.getTypeSym();
    }

    public final String getTypeName() {
        TypeSym typeSym = this.getTypeSym();
        if (typeSym != null) {
            return typeSym.getName();
        }
        return "";
    }

    public UnresolvedType getUnresolvedType() {
        String string;
        TypeSym typeSym = this.getTypeSym();
        if (typeSym != null && (string = typeSym.getName()).length() > 0) {
            int n = typeSym.getArrayDimension();
            int n2 = 0;
            while (n2 < n) {
                string = string + "[]";
                ++n2;
            }
            return QuickUnresolvedType.createUnresolvedType(string);
        }
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public final void setSourceType(SourceTypeReference sourceTypeReference) {
        this.setTypeSym((TypeSym)sourceTypeReference);
    }

    public final SourceExpression getExpression() {
        return this.getExpressionSym();
    }

    public final Expr getExpressionSym() {
        return (Expr)this.getChild((byte)84);
    }

    public void setExpressionSym(Expr expr) {
        this.setSym((byte)84, expr);
    }

    public List getSourceAnnotations() {
        return this.getChildren((byte)1);
    }

    public final SourceClass getEnclosingClass() {
        return this.getOwningClassSym();
    }

    protected final void setSym(byte by, Sym sym) {
        int n = this.indexOf(by);
        if (n != -1) {
            if (sym != null) {
                this.replaceChild(n, sym);
            } else {
                this.unlinkChild(n);
            }
        } else if (sym != null) {
            this.add(sym);
        }
    }

    public final NameSym getNameSym() {
        return (NameSym)this.getChild((byte)21);
    }

    public final void setNameSym(NameSym nameSym) {
        this.setSym((byte)21, nameSym);
    }

    public final BlockSym getBlockSym() {
        return (BlockSym)this.getChild((byte)2);
    }

    public final void setBlockSym(BlockSym blockSym) {
        this.setSym((byte)2, blockSym);
    }

    public TypeSym getTypeSym() {
        return (TypeSym)this.getChild((byte)28);
    }

    public void setTypeSym(TypeSym typeSym) {
        this.setSym((byte)28, typeSym);
    }

    public final SourceDocComment getDocComment() {
        return this.getJavadocSym();
    }

    public final void setDocComment(SourceDocComment sourceDocComment) {
        this.setJavadocSym((DocCommentSym)sourceDocComment);
    }

    public DocCommentSym getJavadocSym() {
        return (DocCommentSym)this.getChild((byte)64);
    }

    public void setJavadocSym(DocCommentSym docCommentSym) {
        this.setSym((byte)64, docCommentSym);
    }

    public final boolean hasHiddenTag() {
        DocCommentSym docCommentSym = this.getJavadocSym();
        if (docCommentSym != null) {
            return docCommentSym.isHidden();
        }
        return false;
    }

    public final boolean hasDeprecatedTag() {
        DocCommentSym docCommentSym = this.getJavadocSym();
        if (docCommentSym != null) {
            return docCommentSym.isDeprecated();
        }
        return false;
    }

    protected void add(Sym sym, byte by) {
        if (this.indexOf(sym) != -1) {
            return;
        }
        int n = this.treeChildren.length;
        int n2 = this.getTargetIndex(sym, by);
        if (n < n2) {
            n2 = n;
        }
        this.linkChild(n2, sym, by);
    }

    protected final void add(Sym sym) {
        this.add(sym, (byte)0);
    }

    protected final void replace(Sym sym, Sym sym2) {
        int n = this.indexOf(sym);
        if (n == -1) {
            TreeSym.errorInvalidParent();
        }
        this.replaceChild(n, sym2);
    }

    protected final void remove(Sym sym) {
        int n = this.indexOf(sym);
        if (n == -1) {
            TreeSym.errorInvalidParent();
        }
        this.unlinkChild(n);
    }

    protected final void remove(Sym sym, byte by) {
        int n = this.indexOf(sym);
        if (n == -1) {
            TreeSym.errorInvalidParent();
        }
        this.unlinkChild(n, by);
    }

    public final int indexOf(Sym sym) {
        if (sym == null) {
            return -1;
        }
        int n = sym.symSiblingIndex;
        if (sym.getParentSym() == this && n != -1) {
            Sym sym2;
            if (n < this.treeChildren.length && (sym2 = this.getNthChildImpl(n)) == sym) {
                return n;
            }
            try {
                TreeSym.panic();
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
        }
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            if (sym == this.getNthChildImpl(n3)) {
                return n3;
            }
            ++n3;
        }
        return super.indexOf(sym);
    }

    public final int lastIndexOf(Sym sym) {
        return this.indexOf(sym);
    }

    public List getChildren() {
        return new SimpleSymList(0);
    }

    public List getChildren(int n) {
        if (n == 0) {
            return InternalConstants.kEmptyList;
        }
        if (n == 65536) {
            return this.getChildren();
        }
        if (n < 0 || n >> 8 == 0 || (n & 0xFFFFFF00) == -256) {
            return this.getChildren((byte)n);
        }
        if (n == 131072) {
            return this.getChildren((byte)70);
        }
        if (n == 262144) {
            return this.getChildren((byte)71);
        }
        int n2 = 458752;
        if ((n & 0xFFF8FFFF) != 0) {
            throw new IllegalArgumentException("Invalid mask " + Integer.toHexString(n));
        }
        if ((n & 0x10000) == 0) {
            TreeSym.notImplementedYet();
        }
        boolean bl = (n & 0x20000) != 0;
        boolean bl2 = (n & 0x40000) != 0;
        return new SimpleSymList(0, bl, bl2);
    }

    public Collection getSyms(byte by) {
        if (91 <= by && by < 94) {
            return new SymCollection(by);
        }
        return this.getChildren(by);
    }

    public final void clearAllBindings(int n) {
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            this.getNthChildImpl(n3).clearBinding(n);
            ++n3;
        }
        this.clearBinding(n);
    }

    public final void clearOffsets() {
        super.clearOffsets();
        int n = this.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            this.getNthChildImpl(n2).clearOffsets();
            ++n2;
        }
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        int n = this.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            this.getNthChildImpl(n2).clearCompiledInfo();
            ++n2;
        }
    }

    protected final void clearFormatInfo() {
        super.clearFormatInfo();
        int n = this.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            this.getNthChildImpl(n2).clearFormatInfo();
            ++n2;
        }
    }

    public void hookupChildren() {
        if ((this.symFormat & 2) == 0) {
            TreeSym.panic("Should only be called by the factory");
        }
        Sym[] symArray = this.treeChildren;
        int n = symArray.length;
        int n2 = 0;
        while (n2 < n) {
            Sym sym;
            Sym sym2 = symArray[n2];
            if (this.symFile != sym2.symFile) {
                TreeSym.errorDifferentFile();
            }
            if ((sym = sym2.symParent) != this) {
                if (sym != null) {
                    TreeSym.errorHasParent();
                }
                SymOperation symOperation = null;
                if ((sym2.symFormat & 2) == 0) {
                    SymTransaction symTransaction = this.verifyTransaction();
                    symOperation = symTransaction.newOperation((byte)1);
                    symOperation.opNewSym = sym2;
                    symOperation.opParent = this;
                    symOperation.opTargetIndex = n2;
                } else if (!this.isValidChild(sym2, (byte)0)) {
                    TreeSym.errorCannotLink(sym2, this);
                }
                sym2.symParent = this;
                if (symOperation != null) {
                    symOperation.buildSelf();
                }
                sym2.linkSelfTrigger(this, (byte)0);
                this.linkChildTrigger(sym2, (byte)0);
            }
            ++n2;
        }
        this.renumberSelf();
    }

    protected final int getTargetIndex(Sym sym) {
        return this.getTargetIndex(sym, (byte)0);
    }

    protected int getTargetIndex(Sym sym, byte by) {
        return this.treeChildren.length;
    }

    protected final void linkChild(int n, Sym sym) {
        this.linkChild(n, sym, (byte)0);
    }

    protected final void unlinkChild(int n) {
        this.unlinkChild(n, (byte)0);
    }

    protected final void replaceChild(int n, Sym sym) {
        this.replaceChild(n, sym, (byte)0);
    }

    protected void linkChild(int n, Sym sym, byte by) {
        this.linkChildImpl(n, sym, by);
    }

    protected void unlinkChild(int n, byte by) {
        this.unlinkChildImpl(n, by);
    }

    protected void replaceChild(int n, Sym sym, byte by) {
        this.replaceChildImpl(n, sym, by);
    }

    private boolean verifyLinkChild(Sym sym, byte by) {
        if (!this.isValidChild(sym, by)) {
            return false;
        }
        if (this.indexOf(sym) != -1) {
            return false;
        }
        if (sym.isSynthetic() && !sym.is((byte)90)) {
            TreeSym.errorSynthetic();
        }
        if (sym.getParentSym() != null) {
            TreeSym.errorHasParent();
        }
        if (this.symFile != sym.symFile) {
            TreeSym.errorDifferentFile();
        }
        if (sym.getContextImpl() != null) {
            TreeSym.panic("Cannot have both parent and context");
        }
        return true;
    }

    private boolean verifyUnlinkChild(Sym sym, byte by, boolean bl) {
        if (sym.isSynthetic() && !sym.is((byte)90)) {
            TreeSym.errorSynthetic();
        }
        if (!bl && sym.is((byte)86) && !sym.is((byte)90)) {
            TreeSym.errorSkeleton();
        }
        if (sym.getParentSym() == null) {
            TreeSym.errorNoParent();
        }
        return true;
    }

    private void linkChildImpl(int n, Sym sym, byte by) {
        if (sym == null) {
            TreeSym.panic("Null made it this far into the internals. Why?");
        }
        if (!this.verifyLinkChild(sym, by)) {
            TreeSym.errorCannotLink(sym, this);
        }
        int n2 = this.treeChildren.length;
        if (n < 0 || n2 < n) {
            TreeSym.errorInvalidRange(n);
        }
        if (n < n2) {
            Sym sym2 = this.treeChildren[n];
            if (sym2.symKind == sym.symKind && sym2.is((byte)86)) {
                this.replaceChild(n, sym, by);
                return;
            }
        }
        SymOperation symOperation = null;
        if (!sym.is((byte)86)) {
            SymTransaction symTransaction = this.verifyTransaction();
            symOperation = symTransaction.newOperation((byte)1);
            symOperation.opNewSym = sym;
            symOperation.opParent = this;
            symOperation.opTargetIndex = n;
            symOperation.opFilter = by;
            symOperation.symSiblingIndex = n;
        }
        Sym[] symArray = new Sym[n2 + 1];
        if (n != 0) {
            System.arraycopy(this.treeChildren, 0, symArray, 0, n);
        }
        if (n != n2) {
            System.arraycopy(this.treeChildren, n, symArray, n + 1, n2 - n);
        }
        symArray[n] = sym;
        this.treeChildren = symArray;
        this.renumberSelf();
        sym.symParent = this;
        if (symOperation != null) {
            symOperation.buildSelf();
        }
        sym.linkSelfTrigger(this, by);
        this.linkChildTrigger(sym, by);
    }

    private void unlinkChildImpl(int n, byte by) {
        Sym sym;
        int n2 = this.treeChildren.length;
        if (n < 0 || n2 <= n) {
            TreeSym.errorInvalidRange(n);
        }
        if (!this.verifyUnlinkChild(sym = this.treeChildren[n], by, false)) {
            throw new IllegalArgumentException("May not be removed");
        }
        SymOperation symOperation = null;
        SymTransaction symTransaction = this.verifyTransaction();
        symOperation = symTransaction.newOperation((byte)3);
        symOperation.opTarget = sym;
        symOperation.opParent = this;
        symOperation.opTargetIndex = n;
        symOperation.opFilter = by;
        symOperation.symSiblingIndex = n;
        Sym[] symArray = new Sym[n2 - 1];
        if (n != 0) {
            System.arraycopy(this.treeChildren, 0, symArray, 0, n);
        }
        if (n != n2 - 1) {
            System.arraycopy(this.treeChildren, n + 1, symArray, n, n2 - 1 - n);
        }
        this.treeChildren = symArray;
        this.renumberSelf();
        sym.symParent = null;
        if (symOperation != null) {
            symOperation.buildSelf();
        }
        sym.unlinkSelfTrigger(this, by);
        this.unlinkChildTrigger(sym, by);
    }

    private void replaceChildImpl(int n, Sym sym, byte by) {
        int n2 = this.treeChildren.length;
        if (n < 0 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        Sym sym2 = this.treeChildren[n];
        if (sym2 == sym) {
            return;
        }
        if (sym == null) {
            this.unlinkChild(n, by);
            return;
        }
        if (!this.verifyLinkChild(sym, by)) {
            TreeSym.errorCannotLink(sym, this);
        }
        if (!this.verifyUnlinkChild(sym2, by, true)) {
            throw new IllegalArgumentException();
        }
        SymOperation symOperation = null;
        SymTransaction symTransaction = this.verifyTransaction();
        symOperation = symTransaction.newOperation((byte)2);
        symOperation.opTarget = sym2;
        symOperation.opNewSym = sym;
        symOperation.opParent = this;
        symOperation.opTargetIndex = n;
        symOperation.opFilter = by;
        symOperation.symSiblingIndex = n;
        symOperation.buildSelf();
        this.treeChildren[n] = sym;
        sym2.symSiblingIndex = -1;
        sym.symSiblingIndex = n;
        sym2.symParent = null;
        sym.symParent = this;
        if (symOperation != null) {
            symOperation.buildSelf();
        }
        sym2.unlinkSelfTrigger(this, by);
        this.unlinkChildTrigger(sym2, by);
        sym.linkSelfTrigger(this, by);
        this.linkChildTrigger(sym, by);
    }

    protected void setNameTrigger(String string) {
    }

    protected void linkChildTrigger(Sym sym, byte by) {
        if (this.is((byte)86)) {
            this.symFlags = (byte)(this.symFlags & 0xFFFFFFFB);
            this.symFormat = (char)(this.symFormat | 2);
        } else {
            this.unsaveText();
        }
    }

    protected void unlinkChildTrigger(Sym sym, byte by) {
        if (!this.is((byte)86)) {
            this.unsaveText();
        }
    }

    protected Sym createSkeleton(byte by) {
        Sym sym = this.createSkeletonImpl(by);
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.symFlags = (byte)(sym.symFlags | 4);
        this.add(sym);
        return sym;
    }

    protected Sym createSkeletonImpl(byte by) {
        return SymFactory.createNode(this.symFile, by);
    }

    protected final Sym getChildOrCreateSkeleton(byte by) {
        Sym sym = this.getChild(by);
        if (sym != null) {
            return sym;
        }
        return this.createSkeleton(by);
    }

    protected void setupSkeleton() {
    }

    private void renumberSelf() {
        int n = this.treeChildren.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            Sym sym = this.treeChildren[n2];
            sym.symSiblingIndex = n2;
            if (sym.symKind == 71) {
                BlanklineSym blanklineSym = (BlanklineSym)sym;
                blanklineSym.blanklineFollowing = (byte)-1;
            }
            --n2;
        }
    }

    public void buildSelf() {
        if (this.hasSyntaxData()) {
            SyntaxData syntaxData = (SyntaxData)this.symData;
            Sym[] symArray = syntaxData.kids;
            int n = syntaxData.kidCount;
            if (n > 0) {
                boolean bl = false;
                ArrayList<Sym> arrayList = new ArrayList<Sym>();
                int n2 = this.treeChildren.length;
                int n3 = 0;
                while (n3 < n2) {
                    Sym sym = this.treeChildren[n3];
                    arrayList.add(sym);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < n) {
                    Sym sym = symArray[n4];
                    arrayList.add(sym);
                    ++n4;
                }
                int n5 = arrayList.size();
                if (n5 > 0) {
                    Sym[] symArray2 = new Sym[n5];
                    this.treeChildren = arrayList.toArray(symArray2);
                }
                this.renumberSelf();
            }
        }
        super.buildSelf();
        this.setupSkeleton();
    }

    public Sym cloneSelf(FileSym fileSym) {
        TreeSym treeSym = (TreeSym)super.cloneSelf(fileSym);
        int n = this.treeChildren.length;
        treeSym.treeChildren = new Sym[n];
        int n2 = 0;
        while (n2 < n) {
            Sym sym;
            treeSym.treeChildren[n2] = sym = this.treeChildren[n2].cloneSelf(fileSym);
            ++n2;
        }
        treeSym.hookupChildren();
        treeSym.renumberSelf();
        return treeSym;
    }

    public final void sortSelf() {
        int n = this.treeChildren.length;
        if (n < 2) {
            return;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < n2) {
                if (this.treeChildren[n3 + 1].symStart < this.treeChildren[n3].symStart) {
                    Sym sym = this.treeChildren[n3];
                    this.treeChildren[n3] = this.treeChildren[n3 + 1];
                    this.treeChildren[n3 + 1] = sym;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            --n2;
        }
        this.renumberSelf();
    }

    protected JavaElement compileImpl(CompilerDriver compilerDriver) {
        int n = this.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            this.getNthChildImpl(n2).compile(compilerDriver);
            ++n2;
        }
        return this.resolveImpl(compilerDriver);
    }

    protected void verboseSelf(StringBuffer stringBuffer) {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            stringBuffer.append(" name \"");
            stringBuffer.append(this.getName());
            stringBuffer.append('\"');
        }
    }

    public void describeSelf(int n) {
        super.describeSelf(n);
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            this.getNthChildImpl(n3).describeSelf(n + 1);
            ++n3;
        }
    }

    protected int indexSelf(Sym[] symArray, int n, TokenArray tokenArray) {
        Sym sym = this;
        if ((this.symFlags & 2) != 0) {
            sym = this.symParent;
        }
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            Sym sym2 = this.getNthChildImpl(n3);
            while (n < sym2.symStart) {
                symArray[n++] = sym;
            }
            n = sym2.indexSelf(symArray, n, tokenArray);
            ++n3;
        }
        return super.indexSelf(symArray, n, tokenArray);
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print((Sym)this);
    }

    public final boolean traverseSelf(Sym.SymTraversal symTraversal) {
        try {
            boolean bl = symTraversal.enter(this);
            if (bl) {
                int n = this.treeChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean bl2 = this.getNthChildImpl(n2).traverseSelf(symTraversal);
                    if (!bl2) break;
                    ++n2;
                }
            }
            boolean bl3 = symTraversal.leave(this);
            return bl3;
        }
        catch (Sym.TraversalCancelledException traversalCancelledException) {
            boolean bl = false;
            return bl;
        }
    }

    private boolean childrenMatch(TreeSym treeSym) {
        int n = this.treeChildren.length;
        Sym[] symArray = treeSym.treeChildren;
        int n2 = symArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            Sym sym = this.getNthChildImpl(n3);
            Sym sym2 = treeSym.getNthChildImpl(n4);
            if (sym.symKind != sym2.symKind) {
                while (n4 + 1 < n2 && sym2.symKind == 71) {
                    sym2 = treeSym.getNthChildImpl(++n4);
                }
                while (n3 + 1 < n && sym.symKind == 71) {
                    sym = this.getNthChildImpl(++n3);
                }
            }
            if (sym.symKind != sym2.symKind) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public final boolean traverseDual(Sym sym, Sym.SymDualTraversal symDualTraversal) {
        try {
            boolean bl = symDualTraversal.enter(this, sym);
            if (bl && sym instanceof TreeSym) {
                int n = this.treeChildren.length;
                TreeSym treeSym = (TreeSym)sym;
                Sym[] symArray = treeSym.treeChildren;
                int n2 = symArray.length;
                if (this.childrenMatch(treeSym)) {
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < n && n4 < n2) {
                        boolean bl2;
                        Sym sym2 = this.getNthChildImpl(n3);
                        Sym sym3 = treeSym.getNthChildImpl(n4);
                        if (sym2.symKind != sym3.symKind) {
                            while (n4 < n2 && sym3.symKind == 71) {
                                sym3 = treeSym.getNthChildImpl(++n4);
                            }
                            while (n3 < n && sym2.symKind == 71) {
                                sym2 = this.getNthChildImpl(++n3);
                            }
                        }
                        if (bl2 = sym2.traverseDual(sym3, symDualTraversal)) {
                            ++n3;
                            ++n4;
                            continue;
                        }
                        break;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < n2) {
                        Sym sym4 = symArray[n5];
                        byte by = sym4.symKind;
                        int n6 = this.count(by);
                        if (n6 == 1) {
                            boolean bl3 = this.getChild(by).traverseDual(sym4, symDualTraversal);
                            if (!bl3) {
                                break;
                            }
                        } else {
                            boolean bl4;
                            int n7 = 0;
                            int n8 = n5 - 1;
                            while (n8 >= 0) {
                                if (symArray[n8].symKind == by) {
                                    ++n7;
                                }
                                --n8;
                            }
                            if (n7 < n6 && !(bl4 = this.getNthChild(by, n7).traverseDual(sym4, symDualTraversal))) break;
                        }
                        ++n5;
                    }
                }
            }
            boolean bl5 = symDualTraversal.leave(this, sym);
            return bl5;
        }
        catch (Sym.TraversalCancelledException traversalCancelledException) {
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void adjustSelfImpl(Sym var1_1) {
        block4: {
            super.adjustSelfImpl(var1_1);
            var2_2 = this.symFile.getTransactionSym();
            if (var2_2 == null || !(var1_1 instanceof TreeSym) || !this.childrenMatch((TreeSym)var1_1)) break block4;
            var3_3 = this.treeChildren.length;
            var4_4 = (TreeSym)var1_1;
            var5_5 = var4_4.treeChildren;
            var6_6 = var5_5.length;
            var7_7 = var3_3 - 1;
            var8_8 = var6_6 - 1;
            while (var7_7 >= 0) {
                block5: {
                    var9_9 = this.getNthChildImpl(var7_7);
                    var10_10 = null;
                    if (var8_8 >= 0) {
                        var10_10 = var4_4.getNthChildImpl(var8_8);
                    }
                    var11_11 = var9_9.symKind == 71;
                    v0 = var12_12 = var10_10 != null && var10_10.symKind == 71;
                    if (!var11_11 && !var12_12) break block5;
                    if (!var11_11 || !var12_12) ** GOTO lbl26
                    var9_9.adjustSelfImpl(var10_10);
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        var13_13 = SymFactory.createNode(this.symFile, 71);
                        var13_13.adjustSelfImpl(var10_10);
                        this.linkChild(var7_7 + 1, var13_13);
                        if (var8_8 == 0) break;
                        var10_10 = var4_4.getNthChildImpl(--var8_8);
lbl26:
                        // 2 sources

                        ** while (var8_8 >= 0 && var10_10.symKind == 71)
                    }
lbl27:
                    // 3 sources

                    while (var7_7 >= 0 && var9_9.symKind == 71) {
                        this.unlinkChild(var7_7);
                        if (var7_7 == 0) break;
                        var9_9 = this.getNthChildImpl(--var7_7);
                    }
                }
                --var7_7;
                --var8_8;
            }
        }
    }

    public void print(PrintWriter printWriter, int n) {
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            TreeSym.print(this.getNthChildImpl(n3), printWriter, n);
            ++n3;
        }
    }

    public final void print_annotations(PrintWriter printWriter) {
        List list = this.getSourceAnnotations();
        int n = list.size();
        if (n > 0) {
            for (Sym sym : list) {
                TreeSym.print(sym, printWriter);
            }
            printWriter.println();
        }
    }

    public final Sym getNthChild(int n) {
        if (n < 0) {
            return null;
        }
        if (this.treeChildren.length <= n) {
            return null;
        }
        return this.getNthChildImpl(n);
    }

    private final Sym getNthChildImpl(int n) {
        Sym sym = this.treeChildren[n];
        if (sym.symKind != 73) {
            return sym;
        }
        IndirectSym indirectSym = (IndirectSym)sym;
        return indirectSym.getSym();
    }

    public final Sym getChildAt(int n) {
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            Sym sym = this.getNthChildImpl(n3);
            if (n < sym.symStart) break;
            if (n <= sym.symEnd) {
                if ((sym.symFlags & 2) == 0) {
                    return sym;
                }
                return null;
            }
            ++n3;
        }
        return null;
    }

    public ListIterator getSiblingsFor(Sym sym) {
        List list = this.getChildren();
        int n = this.indexOf(sym);
        if (n == -1) {
            return InternalConstants.kEmptyList.listIterator();
        }
        ListIterator listIterator = list.listIterator(n);
        return listIterator;
    }

    public ListIterator getSiblingsFor(Sym sym, int n) {
        List list = this.getChildren(n);
        int n2 = this.indexOf(sym);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        ListIterator listIterator = list.listIterator(n2);
        return listIterator;
    }

    public final int count(byte by) {
        int n = this.treeChildren.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Sym sym = this.getNthChildImpl(n3);
            if (sym.is(by)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public final int indexOf(byte by) {
        return this.indexOf(by, 0);
    }

    public final int indexOf(byte by, int n) {
        int n2 = this.treeChildren.length;
        int n3 = n;
        while (n3 < n2) {
            Sym sym = this.getNthChildImpl(n3);
            if (sym.is(by)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int indexOfNth(byte by, int n) {
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            Sym sym = this.getNthChildImpl(n3);
            if (sym.is(by) && n-- == 0) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int lastIndexOf(byte by) {
        int n = this.treeChildren.length;
        return this.lastIndexOf(by, n - 1);
    }

    public final int lastIndexOf(byte by, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Sym sym = this.getNthChildImpl(n2);
            if (sym.is(by)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final Sym getChild(byte by) {
        return this.getNthChild(by, 0);
    }

    public final Sym getNthChild(byte by, int n) {
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            Sym sym = this.getNthChildImpl(n3);
            if (sym.is(by) && n-- == 0) {
                return sym;
            }
            ++n3;
        }
        return null;
    }

    public final Sym getLastChild(byte by) {
        int n = this.treeChildren.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            Sym sym = this.getNthChildImpl(n2);
            if (sym.is(by)) {
                return sym;
            }
            --n2;
        }
        return null;
    }

    public final List getChildren(byte by) {
        return new SimpleSymList(by);
    }

    public final void getChildrenRecursive(byte by, ArrayList arrayList) {
        if (this.is(by)) {
            arrayList.add(this);
        }
        int n = this.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            this.getNthChildImpl(n2).getChildrenRecursive(by, arrayList);
            ++n2;
        }
    }

    public final JavaElement getObject(byte by) {
        int n = this.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Sym sym = this.getNthChildImpl(n2);
            if (sym.is(by)) {
                return sym.getCompiledObject();
            }
            ++n2;
        }
        return null;
    }

    public final JavaElement getObject(byte by, int n) {
        int n2 = this.treeChildren.length;
        int n3 = 0;
        while (n3 < n2) {
            Sym sym = this.getNthChildImpl(n3);
            if (sym.is(by) && n-- == 0) {
                return sym.getCompiledObject();
            }
            ++n3;
        }
        return null;
    }

    public final JavaElement getLastObject(byte by) {
        int n = this.treeChildren.length;
        int n2 = n - 1;
        while (n2 >= 0) {
            Sym sym = this.getNthChildImpl(n2);
            if (sym.is(by)) {
                return sym.getCompiledObject();
            }
            --n2;
        }
        return null;
    }

    public final List getObjects(byte by) {
        if (this.treeChildren.length == 0) {
            return InternalConstants.kEmptyList;
        }
        return new ObjList(by, null);
    }

    public TreeSym() {
        this.$init$();
    }

    static Sym mav$getNthChildImpl(TreeSym treeSym, int n) {
        return treeSym.getNthChildImpl(n);
    }

    private class SimpleSymList
    extends AbstractList {
        protected final byte filter;
        protected final boolean showComments;
        protected final boolean showBlanklines;

        protected SimpleSymList(byte by) {
            this(by, by == 70, by == 71);
        }

        protected SimpleSymList(byte by, boolean bl, boolean bl2) {
            this.filter = by;
            if (91 <= by && by < 94) {
                throw new IllegalArgumentException("" + by);
            }
            this.showComments = bl;
            this.showBlanklines = bl2;
        }

        protected final boolean match(Sym sym) {
            if (!sym.is(this.filter) || sym.is((byte)86)) {
                return false;
            }
            switch (sym.symKind) {
                case 70: {
                    return this.showComments;
                }
                case 71: {
                    return this.showBlanklines;
                }
            }
            return true;
        }

        protected final int logical2real(int n) {
            int n2 = TreeSym.this.treeChildren.length;
            if (n2 == 0) {
                return -1;
            }
            int n3 = 0;
            while (n3 < n2) {
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n3);
                if (this.match(sym) && n-- == 0) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }

        public Iterator iterator() {
            return new SimpleSymListIterator();
        }

        public ListIterator listIterator() {
            return new SimpleSymListIterator();
        }

        public ListIterator listIterator(int n) {
            return new SimpleSymListIterator(n);
        }

        public int size() {
            int n = TreeSym.this.treeChildren.length;
            if (n == 0) {
                return 0;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n3);
                if (this.match(sym)) {
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }

        public boolean isEmpty() {
            int n = TreeSym.this.treeChildren.length;
            if (n == 0) {
                return true;
            }
            int n2 = 0;
            while (n2 < n) {
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n2);
                if (this.match(sym)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public Object get(int n) {
            int n2 = this.logical2real(n);
            if (n2 != -1) {
                return TreeSym.this.treeChildren[n2];
            }
            return null;
        }

        public Object[] toArray() {
            int n = TreeSym.this.treeChildren.length;
            if (n == 0) {
                return Sym.EMPTY_ARRAY;
            }
            ArrayList<Sym> arrayList = new ArrayList<Sym>();
            int n2 = 0;
            while (n2 < n) {
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n2);
                if (this.match(sym)) {
                    arrayList.add(sym);
                }
                ++n2;
            }
            int n3 = arrayList.size();
            return arrayList.toArray(new Sym[n3]);
        }

        public boolean add(Sym sym) {
            if (sym == null) {
                return false;
            }
            TreeSym.this.add(sym, this.filter);
            return true;
        }

        public void add(int n, Sym sym) {
            if (sym == null) {
                return;
            }
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n2 = this.logical2real(n);
            if (n2 != -1) {
                TreeSym.this.linkChild(n2, sym, this.filter);
            } else {
                int n3 = TreeSym.this.lastIndexOf(this.filter);
                if (n3 >= 0) {
                    TreeSym.this.linkChild(n3 + 1, sym, this.filter);
                } else {
                    TreeSym.this.add(sym, this.filter);
                }
            }
        }

        public Object set(int n, Sym sym) {
            if (sym == null) {
                return this.remove(n);
            }
            if (n < 0) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n2 = this.logical2real(n);
            if (n2 == -1) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            return this.setImpl(n, sym);
        }

        private Object setImpl(int n, Sym sym) {
            Sym sym2 = TreeSym.this.treeChildren[n];
            if (sym2 == sym) {
                return sym2;
            }
            if (sym.symParent != TreeSym.this) {
                TreeSym.this.replaceChild(n, sym, this.filter);
            } else {
                int n2 = TreeSym.this.indexOf(sym);
                if (n2 == -1) {
                    SymUtilities.errorInvalidParent();
                }
                Sym sym3 = SymFactory.createNode(TreeSym.this.symFile, 71);
                TreeSym.this.replaceChild(n2, sym3);
                TreeSym.this.replaceChild(n, sym, this.filter);
                TreeSym.this.replaceChild(n2, sym2, this.filter);
            }
            return sym2;
        }

        public boolean contains(Sym sym) {
            return this.indexOf(sym) != -1;
        }

        public int indexOf(Sym sym) {
            if (sym == null) {
                return -1;
            }
            int n = TreeSym.this.treeChildren.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Sym sym2 = TreeSym.mav$getNthChildImpl(TreeSym.this, n3);
                if (sym2 == sym) {
                    return n2;
                }
                if (this.match(sym2)) {
                    ++n2;
                }
                ++n3;
            }
            return -1;
        }

        public int lastIndexOf(Sym sym) {
            return this.indexOf(sym);
        }

        public boolean add(Object object) {
            return this.add((Sym)object);
        }

        public void add(int n, Object object) {
            this.add(n, (Sym)object);
        }

        public Object set(int n, Object object) {
            return this.set(n, (Sym)object);
        }

        public boolean remove(Object object) {
            int n = this.indexOf(object);
            if (n == -1) {
                return false;
            }
            this.remove(n);
            return true;
        }

        public Object remove(int n) {
            int n2 = this.logical2real(n);
            if (n2 == -1) {
                throw new IndexOutOfBoundsException("" + n);
            }
            Sym sym = TreeSym.this.treeChildren[n2];
            TreeSym.this.unlinkChild(n2, this.filter);
            return sym;
        }

        public boolean contains(Object object) {
            return this.contains((Sym)object);
        }

        public int indexOf(Object object) {
            return this.indexOf((Sym)object);
        }

        public int lastIndexOf(Object object) {
            return this.lastIndexOf((Sym)object);
        }

        static Object mav$setImpl(SimpleSymList simpleSymList, int n, Sym sym) {
            return simpleSymList.setImpl(n, sym);
        }

        protected class SimpleSymListIterator
        implements ListIterator {
            private int iteratorCursorLogical;
            private int iteratorReturned;
            private int iteratorNext;
            private int iteratorPrev;

            void $init$() {
                this.iteratorCursorLogical = -1;
                this.iteratorReturned = -1;
                this.iteratorNext = -1;
                this.iteratorPrev = -1;
            }

            SimpleSymListIterator() {
                this.$init$();
                this.advance();
            }

            SimpleSymListIterator(int n) {
                this.$init$();
                while (n >= 0) {
                    if (!this.hasNext()) {
                        throw new IndexOutOfBoundsException("" + n);
                    }
                    this.advance();
                    --n;
                }
            }

            public boolean hasNext() {
                return this.iteratorNext < TreeSym.this.treeChildren.length;
            }

            public boolean hasPrevious() {
                return this.iteratorPrev >= 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.iteratorReturned = this.iteratorNext;
                this.advance();
                return TreeSym.this.treeChildren[this.iteratorReturned];
            }

            public int nextIndex() {
                return this.iteratorCursorLogical;
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    return null;
                }
                this.iteratorReturned = this.iteratorPrev;
                this.backup();
                return TreeSym.this.treeChildren[this.iteratorReturned];
            }

            public int previousIndex() {
                return this.iteratorCursorLogical - 1;
            }

            public void add(Object object) {
                Sym sym = (Sym)object;
                if (!SimpleSymList.this.match(sym)) {
                    throw new IllegalArgumentException("Invalid input");
                }
                SimpleSymList.this.add(this.iteratorNext, sym);
                this.advance();
            }

            public void remove() {
                if (0 <= this.iteratorReturned && this.iteratorReturned < TreeSym.this.treeChildren.length) {
                    boolean bl;
                    int n = this.iteratorReturned;
                    this.iteratorReturned = -1;
                    boolean bl2 = bl = n < this.iteratorNext;
                    if (bl) {
                        this.backup();
                    }
                    TreeSym.this.unlinkChild(n, SimpleSymList.this.filter);
                    this.iteratorNext = this.iteratorPrev;
                    this.advance();
                }
            }

            public void set(Object object) {
                SimpleSymList.mav$setImpl(SimpleSymList.this, this.iteratorReturned, (Sym)object);
            }

            private void backup() {
                if (this.iteratorPrev < 0) {
                    return;
                }
                --this.iteratorCursorLogical;
                this.iteratorNext = this.iteratorPrev--;
                while (this.iteratorPrev >= 0) {
                    Sym sym = TreeSym.this.treeChildren[this.iteratorPrev];
                    if (SimpleSymList.this.match(sym)) break;
                    --this.iteratorPrev;
                }
            }

            private void advance() {
                int n = TreeSym.this.treeChildren.length;
                if (n <= this.iteratorNext) {
                    return;
                }
                ++this.iteratorCursorLogical;
                this.iteratorPrev = this.iteratorNext++;
                while (this.iteratorNext < n) {
                    Sym sym = TreeSym.this.treeChildren[this.iteratorNext];
                    if (SimpleSymList.this.match(sym)) break;
                    ++this.iteratorNext;
                }
            }
        }
    }

    private class SymCollection
    extends AbstractCollection {
        protected final byte filter;

        protected SymCollection(byte by) {
            this.filter = by;
        }

        public Iterator iterator() {
            return new SymIterator();
        }

        public int size() {
            Iterator iterator = this.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        public boolean isEmpty() {
            Iterator iterator = this.iterator();
            return iterator.hasNext() ^ true;
        }

        public boolean add(Object object) {
            String string = "Can't add to Collection. Find a List.";
            throw new UnsupportedOperationException("Can't add to Collection. Find a List.");
        }

        public boolean remove(Object object) {
            String string = "Can't add to Collection. Find a List.";
            throw new UnsupportedOperationException("Can't add to Collection. Find a List.");
        }

        protected class SymIterator
        implements Iterator {
            private Sym next;
            private int currentIndex;
            private Iterator childIterator;

            void $init$() {
                this.next = null;
                this.currentIndex = -1;
                this.childIterator = null;
            }

            SymIterator() {
                this.$init$();
                this.advance();
            }

            private boolean match(Sym sym) {
                return sym.is(SymCollection.this.filter) && !sym.is((byte)86);
            }

            private byte getChildFilter(Sym sym) {
                switch (SymCollection.this.filter) {
                    case 91: 
                    case 92: {
                        if (sym.symKind != 9) break;
                        return SymCollection.this.filter;
                    }
                    case 93: {
                        if (sym.symKind != 18) break;
                        return SymCollection.this.filter;
                    }
                }
                return -1;
            }

            public boolean hasNext() {
                return this.currentIndex < TreeSym.this.treeChildren.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                Sym sym = this.next;
                this.advance();
                return sym;
            }

            public void remove() {
                String string = "Can't add to Collection. Find a List.";
                throw new UnsupportedOperationException("Can't add to Collection. Find a List.");
            }

            private void advance() {
                int n;
                if (this.childIterator != null) {
                    while (this.childIterator.hasNext()) {
                        this.next = (Sym)this.childIterator.next();
                        if (!this.match(this.next)) continue;
                        return;
                    }
                    this.childIterator = null;
                }
                if ((n = TreeSym.this.treeChildren.length) <= this.currentIndex) {
                    return;
                }
                ++this.currentIndex;
                while (this.currentIndex < n) {
                    this.next = TreeSym.this.treeChildren[this.currentIndex];
                    byte by = this.getChildFilter(this.next);
                    this.childIterator = by != -1 ? this.next.getSyms(by).iterator() : null;
                    if (this.match(this.next)) {
                        return;
                    }
                    if (this.childIterator != null) {
                        while (this.childIterator.hasNext()) {
                            this.next = (Sym)this.childIterator.next();
                            if (!this.match(this.next)) continue;
                            return;
                        }
                    }
                    ++this.currentIndex;
                }
            }
        }
    }

    private final class ObjList
    extends SimpleSymList {
        private ObjList(byte by) {
            super(by);
        }

        public Iterator iterator() {
            return new ObjIterator(super.iterator(), null);
        }

        public int size() {
            int n = TreeSym.this.treeChildren.length;
            if (n == 0) {
                return 0;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n3);
                if (this.match(sym) && sym.getCompiledObject() != null) {
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }

        public boolean isEmpty() {
            int n = TreeSym.this.treeChildren.length;
            if (n == 0) {
                return true;
            }
            int n2 = 0;
            while (n2 < n) {
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n2);
                if (this.match(sym) && sym.getCompiledObject() != null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public Object[] toArray() {
            int n = TreeSym.this.treeChildren.length;
            if (n == 0) {
                return Sym.EMPTY_ARRAY;
            }
            ArrayList<JavaElement> arrayList = new ArrayList<JavaElement>();
            int n2 = 0;
            while (n2 < n) {
                JavaElement javaElement;
                Sym sym = TreeSym.mav$getNthChildImpl(TreeSym.this, n2);
                if (this.match(sym) && (javaElement = sym.getCompiledObject()) != null) {
                    arrayList.add(javaElement);
                }
                ++n2;
            }
            int n3 = arrayList.size();
            return arrayList.toArray(new JavaElement[n3]);
        }

        ObjList(byte by, 1 var3_3) {
            this(by);
        }

        private final class ObjIterator
        implements Iterator {
            private Iterator symIterator;
            private JavaElement next;

            private ObjIterator(Iterator iterator) {
                this.symIterator = iterator;
            }

            public boolean hasNext() {
                this.advance();
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                JavaElement javaElement = this.next;
                this.next = null;
                return javaElement;
            }

            public void remove() {
                CommonUtilities.unsupported("Immutable");
            }

            private void advance() {
                while (this.next == null && this.symIterator.hasNext()) {
                    Sym sym = (Sym)this.symIterator.next();
                    this.next = sym.getCompiledObject();
                }
            }

            ObjIterator(Iterator iterator, 1 var3_3) {
                this(iterator);
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

