/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class TypeSym
extends ObjectSym
implements SourceTypeReference {
    public short typeBaseDimension;
    public short typeXtraDimension;
    public short typeToken;
    public JavaType typeResolved;

    void $init$() {
        this.typeBaseDimension = 0;
        this.typeXtraDimension = 0;
    }

    public boolean isPrimitive() {
        return 96 <= this.typeToken && this.typeToken < 146;
    }

    public boolean isArray() {
        return this.getArrayDimension() > 0;
    }

    public SourceTypeReference getQualifyingType() {
        return this.getTypeSym();
    }

    public List getTypeArguments() {
        return this.getChildren((byte)26);
    }

    public int getArrayDimension() {
        if (!this.isVarargs()) {
            return this.typeBaseDimension + this.typeXtraDimension;
        }
        return this.typeBaseDimension + this.typeXtraDimension + 1;
    }

    public JavaElement getCompiledObject() {
        return this.getResolvedType();
    }

    public JavaType getResolvedType() {
        if (this.typeResolved == null) {
            this.resolve();
        }
        return this.typeResolved;
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.typeResolved = null;
    }

    public String printCompiledInfo() {
        JavaType javaType = this.getResolvedType();
        if (javaType != null) {
            return "refers to " + javaType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 21: 
            case 26: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }

    protected void linkSelfTrigger(TreeSym treeSym, byte by) {
        super.linkSelfTrigger(treeSym, by);
        this.symAccess = (char)(this.symAccess & 0xFFFFEFFF);
    }

    protected void unlinkSelfTrigger(TreeSym treeSym, byte by) {
        this.symKind = (byte)28;
        super.unlinkSelfTrigger(treeSym, by);
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        if (this.typeResolved == null && !this.isProcessed()) {
            this.typeResolved = compilerDriver.resolve(this);
        }
        return this.typeResolved;
    }

    protected JavaElement compileImpl(CompilerDriver compilerDriver) {
        JavaElement javaElement = super.compileImpl(compilerDriver);
        if (javaElement != null) {
            compilerDriver.compile(this);
        }
        return javaElement;
    }

    private String qualifySelfImpl() {
        TypeSym typeSym;
        JavaType javaType = this.getResolvedType();
        if (javaType != null && !javaType.isPrimitive() && javaType instanceof JavaClass && javaType.isExported() && (typeSym = this.getTypeSym()) == null) {
            JavaClass javaClass = (JavaClass)javaType;
            String string = javaClass.getRawName();
            int n = string.indexOf(91);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (TypeSym.isValidQualifiedName(string) && !this.getName().equals(string)) {
                return string;
            }
        }
        return null;
    }

    public final void qualifySelf() {
        NameSym nameSym;
        String string = this.qualifySelfImpl();
        if (string != null && (nameSym = this.getNameSym()) != null) {
            nameSym.setValue(string);
            this.symFormat = (char)(this.symFormat | 0x20);
        }
    }

    public Sym cloneSelf(FileSym fileSym) {
        NameSym nameSym;
        String string;
        TypeSym typeSym = (TypeSym)super.cloneSelf(fileSym);
        typeSym.typeBaseDimension = this.typeBaseDimension;
        typeSym.typeXtraDimension = this.typeXtraDimension;
        typeSym.typeToken = this.typeToken;
        SourcePreferences sourcePreferences = this.symFile.getPreferences();
        if (sourcePreferences.getBoolean(66) && (string = this.qualifySelfImpl()) != null && (nameSym = typeSym.getNameSym()) != null) {
            nameSym.nameString = string;
        }
        return typeSym;
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public void print(PrintWriter printWriter, int n) {
        this.print(printWriter);
    }

    public TypeSym() {
        this.$init$();
    }
}

