/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;

public class VariableSym
extends ObjectSym
implements SourceVariable {
    public short varXDimension;
    public TypeSym varType;

    public final SourceVariableDeclaration getOwningDeclaration() {
        return this.getOwningDeclarationSym();
    }

    public final VardeclSym getOwningDeclarationSym() {
        Sym sym = this.getParentSym();
        if (sym == null) {
            return null;
        }
        switch (sym.symKind) {
            case 9: 
            case 18: {
                return (VardeclSym)sym;
            }
        }
        return null;
    }

    public SourceBlock getOwningBlock() {
        Sym sym = this.getParentSym();
        switch (this.symKind) {
            case 17: {
                Sym sym2 = sym;
                while (sym2 != null) {
                    if (sym2.symKind == 2) {
                        return (SourceBlock)((Object)sym2);
                    }
                    sym2 = sym2.symParent;
                }
                break;
            }
            case 13: {
                Sym sym3 = sym;
                while (sym3 != null) {
                    switch (sym3.symKind) {
                        case 6: 
                        case 19: {
                            MethodSym methodSym = (MethodSym)sym3;
                            return methodSym.getBlock();
                        }
                        case 2: {
                            return (SourceBlock)((Object)sym3);
                        }
                        case 32: {
                            return ((TreeSym)sym3).getBlock();
                        }
                    }
                    sym3 = sym3.symParent;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public final TypeSym getTypeSym() {
        TypeSym typeSym = super.getTypeSym();
        if (typeSym != null) {
            return typeSym;
        }
        return this.varType;
    }

    public void setTypeSym(TypeSym typeSym) {
        if (typeSym == null) {
            throw new IllegalArgumentException();
        }
        int n = this.indexOf((byte)28);
        if (n != -1) {
            this.replaceChild(n, typeSym);
            return;
        }
        VardeclSym vardeclSym = this.getOwningDeclarationSym();
        if (vardeclSym == null) {
            this.add(typeSym);
            return;
        }
        List list = vardeclSym.getVariables();
        TypeSym typeSym2 = vardeclSym.getTypeSym();
        if (list.size() > 1) {
            String string = typeSym2.getName();
            if (string.equals(typeSym.getName())) {
                this.varType.typeXtraDimension = typeSym.typeXtraDimension;
                return;
            }
            this.separateSelf();
        }
        vardeclSym.setTypeSym(typeSym);
        if (this.varType == null) {
            this.buildSelf();
        }
        this.useType(typeSym);
    }

    public SourceExpression getInitializer() {
        return this.getExpressionSym();
    }

    public void setInitializer(SourceExpression sourceExpression) {
        this.setExpressionSym((Expr)sourceExpression);
    }

    public Object getConstantValue() {
        if (!this.isFinal()) {
            return null;
        }
        Expr expr = this.getExpressionSym();
        if (expr == null) {
            return null;
        }
        return expr.getConstantValue();
    }

    protected void setModifiersImpl(char c) {
        VardeclSym vardeclSym;
        boolean bl;
        Sym sym = this.getParentSym();
        boolean bl2 = bl = sym != null && sym.symAccess != c;
        if (bl && (vardeclSym = this.getOwningDeclarationSym()) != null) {
            List list = vardeclSym.getVariables();
            if (list.size() > 1) {
                this.separateSelf();
            }
            vardeclSym.setModifiers(c);
            return;
        }
        this.setAccess(c);
    }

    public void separateSelf() {
        this.separateSelfImpl();
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        if (this.varType != null) {
            this.varType.clearCompiledInfo();
        }
    }

    public String printCompiledInfo() {
        JavaType javaType = this.getResolvedType();
        if (javaType != null) {
            return "FieldSignature " + javaType.getTypeSignature();
        }
        return "FieldSignatrue <unknown>";
    }

    protected void add(Sym sym, byte by) {
        VardeclSym vardeclSym;
        if (sym != null && sym.symKind == 1 && (vardeclSym = this.getOwningDeclarationSym()) != null) {
            vardeclSym.add(sym, by);
            return;
        }
        super.add(sym, by);
    }

    protected int getTargetIndex(Sym sym, byte by) {
        switch (sym.symKind) {
            case 28: {
                return 0;
            }
            case 21: {
                if (this.varType != null) {
                    return 0;
                }
                return 1;
            }
        }
        return super.getTargetIndex(sym, by);
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 21: 
            case 28: {
                return true;
            }
        }
        if (sym.is((byte)84)) {
            return true;
        }
        return super.isValidChild(sym, by);
    }

    protected final void linkSelfTrigger(TreeSym treeSym, byte by) {
        super.linkSelfTrigger(treeSym, by);
    }

    protected final void unlinkSelfTrigger(TreeSym treeSym, byte by) {
        super.unlinkSelfTrigger(treeSym, by);
    }

    public void buildSelf() {
        VardeclSym vardeclSym = this.getOwningDeclarationSym();
        if (vardeclSym != null) {
            this.symAccess = (char)(this.symAccess | vardeclSym.symAccess);
            this.objectImplicit = vardeclSym.objectImplicit;
        }
        super.buildSelf();
        switch (this.symKind) {
            case 7: 
            case 10: 
            case 17: {
                this.varType = (TypeSym)SymFactory.createNode(this.symFile, 28);
                SymFactory.setupSynthetic(this.varType, this, -1);
            }
        }
        if (this.varXDimension > 0) {
            TypeSym typeSym = this.getTypeSym();
            typeSym.typeXtraDimension = this.varXDimension;
        }
    }

    public Sym cloneSelf(FileSym fileSym) {
        VariableSym variableSym = (VariableSym)super.cloneSelf(fileSym);
        variableSym.varXDimension = this.varXDimension;
        if (this.varType != null) {
            variableSym.varType = (TypeSym)this.varType.cloneSelf(fileSym);
            variableSym.varType.symParent = this;
        }
        return variableSym;
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        return compilerDriver.resolve(this);
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    private void print_initializer(PrintWriter printWriter) {
        Sym sym = this.getChild((byte)84);
        if (sym != null) {
            printWriter.print(" = ");
            sym.print(printWriter);
        }
    }

    public void print(PrintWriter printWriter, int n) {
        switch (n) {
            default: {
                this.print_annotations(printWriter);
                this.print_modifiers(printWriter);
                VariableSym.print(this.getTypeSym(), printWriter, n);
                printWriter.print(' ');
                VariableSym.print(this.getNameSym(), printWriter, n);
                this.print_initializer(printWriter);
                break;
            }
            case 2: {
                VariableSym.print(this.getTypeSym(), printWriter, n);
                printWriter.print(' ');
                VariableSym.print(this.getNameSym(), printWriter, n);
                break;
            }
            case 1: {
                VariableSym.print(this.getNameSym(), printWriter, n);
                int n2 = 0;
                while (n2 < this.varXDimension) {
                    printWriter.print("[]");
                    ++n2;
                }
                this.print_initializer(printWriter);
                break;
            }
            case 3: {
                VariableSym.print(this.getTypeSym(), printWriter, n);
            }
        }
    }

    protected void finishSynthetic(NameSym nameSym) {
        if (this.varType == null) {
            VariableSym.panic();
        }
        SyntaxData syntaxData = new SyntaxData();
        syntaxData.addKid(nameSym);
        this.varType.symData = syntaxData;
        this.varType.buildSelf();
    }

    protected void setupSynthetic(Sym sym) {
        this.symAccess = (char)(this.symAccess | 0x1000);
        this.symStart = sym.symStart;
        this.symEnd = sym.symEnd;
        this.symFile = sym.symFile;
        TypeSym typeSym = (TypeSym)SymFactory.createNode(this.symFile, 28);
        SymFactory.setupSynthetic(typeSym, this, sym.symStart);
        this.varType = typeSym;
    }

    protected void useType(TypeSym typeSym) {
        if (this.varType == null) {
            VariableSym.panic();
        }
        TypeSym typeSym2 = this.varType;
        typeSym2.symStart = typeSym.symStart;
        typeSym2.symEnd = typeSym.symEnd;
        typeSym2.treeChildren = typeSym.treeChildren;
        typeSym2.typeBaseDimension = typeSym.typeBaseDimension;
        typeSym2.typeXtraDimension = this.varXDimension;
        typeSym2.typeToken = typeSym.typeToken;
    }

    private void separateSelf(TypeSym typeSym) {
        TreeSym treeSym;
        VardeclSym vardeclSym = this.getOwningDeclarationSym();
        if (vardeclSym == null) {
            VariableSym.panic("No owning declaration");
        }
        if ((treeSym = (TreeSym)vardeclSym.getParentSym()) == null) {
            VariableSym.errorNoParent();
        }
        int n = treeSym.indexOf(vardeclSym);
        VardeclSym vardeclSym2 = (VardeclSym)SymFactory.createNode(this.symFile, vardeclSym.symKind);
        vardeclSym2.symAccess = this.symAccess;
        vardeclSym2.symFormat = (char)(vardeclSym2.symFormat | 2);
        this.varXDimension = 0;
        this.varType = null;
        this.removeSelf();
        vardeclSym2.add(typeSym);
        vardeclSym2.add(this);
        this.buildSelf();
        this.useType(typeSym);
        treeSym.linkChild(n + 1, vardeclSym2);
    }

    private void separateSelfImpl() {
        List list;
        int n;
        TreeSym treeSym;
        VardeclSym vardeclSym = this.getOwningDeclarationSym();
        if (vardeclSym == null) {
            VariableSym.unsupported("No owning declaration");
        }
        if ((treeSym = (TreeSym)vardeclSym.getParentSym()) == null) {
            VariableSym.errorNoParent();
        }
        if ((n = (list = vardeclSym.getVariables()).size()) < 2) {
            return;
        }
        int n2 = list.indexOf(this);
        if (n2 == -1) {
            VariableSym.panic();
        }
        if (n2 > 0) {
            VardeclSym vardeclSym2 = (VardeclSym)vardeclSym.cloneSelf(this.symFile);
            vardeclSym2.addSelfBefore(vardeclSym);
            List list2 = vardeclSym2.getVariables();
            int n3 = n - 1;
            while (n3 >= n2) {
                list2.remove(n3);
                --n3;
            }
        }
        if (n2 != n - 1) {
            VardeclSym vardeclSym3 = (VardeclSym)vardeclSym.cloneSelf(this.symFile);
            vardeclSym3.addSelfAfter(vardeclSym);
            List list3 = vardeclSym3.getVariables();
            int n4 = n2;
            while (n4 >= 0) {
                list3.remove(n4);
                --n4;
            }
        }
        int n5 = n - 1;
        while (n5 >= 0) {
            if (n5 != n2) {
                list.remove(n5);
            }
            --n5;
        }
    }
}

