/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

public class DocReferenceSym
extends DocSym
implements SourceDocReference {
    protected static final JavaHasType kEmptyResult = CompilerDriver.kEmptyResult;
    public static final DocReferenceSym[] EMPTY_ARRAY = new DocReferenceSym[0];
    public String refClassName;
    public String refMemberName;
    public List refMethodParameters;
    public String refParameterName;
    public JavaHasType refObject;

    public SourceDocTag getOwningTag() {
        return (SourceDocTag)((Object)this.getParentSym());
    }

    public String getNormalizedText() {
        if (this.refParameterName != null) {
            return this.refParameterName;
        }
        if (this.refMemberName == null || this.refMemberName.length() == 0) {
            return this.refClassName;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.refClassName != null) {
            stringBuffer.append(this.refClassName);
        }
        stringBuffer.append("#");
        stringBuffer.append(this.refMemberName);
        if (this.refMethodParameters != null) {
            stringBuffer.append('(');
            int n = 0;
            while (n < this.refMethodParameters.size()) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((String)this.refMethodParameters.get(n));
                ++n;
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getClassName() {
        return this.refClassName;
    }

    public String getMemberName() {
        return this.refMemberName;
    }

    public Collection getMethodParameterTypeNames() {
        if (this.refMethodParameters == null) {
            return InternalConstants.kEmptyList;
        }
        return Collections.unmodifiableList(this.refMethodParameters);
    }

    public String getParameterName() {
        return this.refParameterName;
    }

    public JavaHasType getResolvedObject() {
        return (JavaHasType)this.getCompiledObject();
    }

    public SourceFormalParameter getResolvedParameter() {
        if (this.refParameterName == null) {
            return null;
        }
        JavaElement javaElement = this.getCompiledObject();
        if (javaElement instanceof SourceFormalParameter) {
            return (SourceFormalParameter)javaElement;
        }
        return null;
    }

    public JavaMember getResolvedMember() {
        if (this.refParameterName != null) {
            return null;
        }
        JavaElement javaElement = this.getCompiledObject();
        if (javaElement instanceof JavaMember) {
            return (JavaMember)javaElement;
        }
        return null;
    }

    public Sym cloneSelf(FileSym fileSym) {
        DocReferenceSym docReferenceSym = (DocReferenceSym)super.cloneSelf(fileSym);
        docReferenceSym.refClassName = this.refClassName;
        docReferenceSym.refMemberName = this.refMemberName;
        if (this.refMethodParameters != null) {
            docReferenceSym.refMethodParameters = DocReferenceSym.mutableCopy(this.refMethodParameters);
        }
        docReferenceSym.refParameterName = this.refParameterName;
        return docReferenceSym;
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 69: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }

    protected void printSelf(FormatDriver formatDriver) {
        formatDriver.print(this);
    }

    public JavaElement getCompiledObject() {
        if (this.refObject == null) {
            this.resolve();
        }
        if (this.refObject != kEmptyResult) {
            return this.refObject;
        }
        return null;
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.refObject = null;
    }

    protected JavaElement resolveImpl(CompilerDriver compilerDriver) {
        if (this.refObject == null) {
            try {
                this.refObject = (JavaHasType)compilerDriver.resolve(this);
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
        }
        return this.refObject;
    }

    void appendDocText(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n > 0 && stringBuffer.charAt(n - 1) != ' ') {
            stringBuffer.append(' ');
        }
        super.appendDocText(stringBuffer);
    }
}

