/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTagNameSym;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

public abstract class DocTagSym
extends DocSym
implements SourceDocTag {
    static final DocTagSym[] EMPTY_ARRAY = new DocTagSym[0];
    public short tagCode;

    public String getName() {
        DocTagNameSym docTagNameSym = this.getTagNameSym();
        if (docTagNameSym != null) {
            return docTagNameSym.getText();
        }
        return "";
    }

    public DocTagNameSym getTagNameSym() {
        return (DocTagNameSym)this.getChild((byte)68);
    }

    public String getArgumentText() {
        int n = this.treeChildren.length;
        if (n == 0) {
            return "";
        }
        int n2 = 0;
        if (this.treeChildren[n2].symKind == 68) {
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2;
        while (n3 < n) {
            DocSym docSym = (DocSym)this.treeChildren[n3];
            docSym.appendDocText(stringBuffer);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public boolean isStandard() {
        return this.tagCode != 201;
    }

    public boolean isException() {
        return this.tagCode == 205 || this.tagCode == 213;
    }

    public boolean isParameter() {
        return this.tagCode == 207;
    }

    public boolean isReference() {
        switch (this.tagCode) {
            case 206: {
                return true;
            }
            case 216: {
                return true;
            }
            case 209: {
                return this.getChild((byte)67) != null;
            }
            case 218: {
                return this.getChildren().size() > 1;
            }
        }
        return false;
    }

    public boolean isReference(String string) {
        SourceDocReference sourceDocReference = this.getReference();
        if (sourceDocReference == null) {
            return false;
        }
        return string.equals(sourceDocReference.getNormalizedText());
    }

    public SourceDocReference getReference() {
        if (!(this.isException() || this.isParameter() || this.isReference())) {
            return null;
        }
        return this.getReferenceSym();
    }

    private DocReferenceSym getReferenceSym() {
        return (DocReferenceSym)this.getChild((byte)67);
    }

    public String getReferenceText() {
        if (!(this.isException() || this.isParameter() || this.isReference())) {
            return null;
        }
        DocReferenceSym docReferenceSym = this.getReferenceSym();
        if (docReferenceSym == null) {
            return "";
        }
        return docReferenceSym.getNormalizedText();
    }

    public boolean isSerial() {
        return this.tagCode == 217 || this.tagCode == 210;
    }

    public boolean isSerialField() {
        return this.tagCode == 211;
    }

    public SourceDocReference getFieldNameReference() {
        if (!this.isSerialField()) {
            return null;
        }
        return this.getReferenceSym();
    }

    public SourceDocReference getFieldTypeReference() {
        if (!this.isSerialField()) {
            return null;
        }
        return (DocReferenceSym)this.getLastChild((byte)67);
    }

    protected boolean isValidChild(Sym sym, byte by) {
        switch (sym.symKind) {
            case 65: 
            case 67: 
            case 68: {
                return true;
            }
        }
        return super.isValidChild(sym, by);
    }
}

