/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;

public final class FormatHelper
extends InternalUtilities {
    private final FileSym fileSym;
    private FileSym formattedFile;
    private final FormatRegion[] regions;
    private boolean success;
    private TokenMap tokenMap;

    void $init$() {
        this.formattedFile = null;
        this.success = false;
    }

    public FormatHelper(FileSym fileSym, FormatRegion formatRegion) {
        this.$init$();
        if (formatRegion == null) {
            throw new IllegalArgumentException();
        }
        this.fileSym = fileSym;
        this.regions = new FormatRegion[]{formatRegion};
    }

    public FormatHelper(FileSym fileSym, FormatRegion[] formatRegionArray) {
        this.$init$();
        if (formatRegionArray == null) {
            throw new IllegalArgumentException();
        }
        this.fileSym = fileSym;
        this.regions = formatRegionArray;
    }

    public boolean process() {
        if (this.fileSym.getTransactionSym() == null) {
            FormatHelper.panic();
        }
        if (this.success) {
            FormatHelper.panic();
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.fileSym.print(printWriter);
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            char[] cArray = stringWriter.toString().toCharArray();
            textBuffer.insert(0, cArray);
            this.formattedFile = (FileSym)JavaParser.parse(textBuffer, this.fileSym.j2se);
            this.formattedFile.setTextBuffer(textBuffer);
            this.tokenMap = new TokenMap(this.fileSym, this.formattedFile);
            int n = this.regions.length;
            int n2 = n - 1;
            while (n2 >= 0) {
                FormatRegion formatRegion = this.regions[n2];
                this.performRegionReplace(formatRegion);
                --n2;
            }
            this.success = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.success;
    }

    private void performRegionReplace(FormatRegion formatRegion) {
        int n = formatRegion.fromIndices.getStartOffset();
        int n2 = this.fileSym.tokens.tokenStarts[n];
        int n3 = formatRegion.fromIndices.getEndOffset();
        int n4 = this.fileSym.tokens.tokenEnds[n3];
        int n5 = n4 - n2;
        if (n5 <= 0) {
            FormatHelper.panic();
        }
        int n6 = formatRegion.toIndices.getStartOffset();
        int n7 = this.formattedFile.tokens.tokenStarts[n6];
        int n8 = formatRegion.toIndices.getEndOffset();
        int n9 = this.formattedFile.tokens.tokenEnds[n8];
        int n10 = n9 - n7;
        if (n10 <= 0) {
            FormatHelper.panic();
        }
        TextBuffer textBuffer = this.formattedFile.getTextBuffer();
        char[] cArray = textBuffer.getChars(n7, n10);
        TextBuffer textBuffer2 = this.fileSym.getTextBuffer();
        CompareUtils.replaceText(textBuffer2, n2, n5, cArray);
    }
}

