/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class ImportHelper
implements InternalConstants {
    private final FileSym fileSym;
    private final Set importNames;
    private final SourcePreferences preferences;
    private ArrayList typeSyms;
    private ArrayList dotExprs;
    private ArrayList docReferenceSyms;
    public String addImportName;
    public String simplifiedName;

    void $init$() {
        this.typeSyms = new ArrayList();
        this.dotExprs = new ArrayList();
        this.docReferenceSyms = new ArrayList();
    }

    public ImportHelper(FileSym fileSym) {
        this.$init$();
        this.fileSym = fileSym;
        this.importNames = fileSym.getSourceImportNames();
        this.preferences = fileSym.getPreferences();
    }

    public void process() {
        ImportHelperTraversal importHelperTraversal = new ImportHelperTraversal();
        this.processImpl(importHelperTraversal);
    }

    public void process(Sym sym) {
        ImportHelperTraversal importHelperTraversal = new ImportHelperTraversal(false);
        this.processImpl(importHelperTraversal);
    }

    private void processImpl(ImportHelperTraversal importHelperTraversal) {
        this.fileSym.traverseSelf(importHelperTraversal);
        if (!this.typeSyms.isEmpty()) {
            for (TypeSym typeSym : this.typeSyms) {
                this.performAutoImport(typeSym);
            }
            this.typeSyms.clear();
        }
        if (!this.dotExprs.isEmpty()) {
            Iterator iterator = this.dotExprs.iterator();
            while (iterator.hasNext()) {
                try {
                    DotExpr dotExpr = (DotExpr)iterator.next();
                    if (dotExpr.getParent() == null) continue;
                    this.performAutoImport(dotExpr);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    unsupportedOperationException.printStackTrace();
                }
            }
            this.dotExprs.clear();
        }
        if (!this.docReferenceSyms.isEmpty()) {
            Iterator iterator = this.docReferenceSyms.iterator();
            while (iterator.hasNext()) {
                try {
                    DocReferenceSym docReferenceSym = (DocReferenceSym)iterator.next();
                    this.performAutoImport(docReferenceSym);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    unsupportedOperationException.printStackTrace();
                }
            }
            this.dotExprs.clear();
        }
    }

    public final void performAutoImport(TypeSym typeSym) {
        this.performAutoImport(typeSym, typeSym.getName());
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(typeSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(DotExpr dotExpr) {
        String string = dotExpr.getQualifiedName();
        this.performAutoImport(dotExpr, string);
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(dotExpr, this.simplifiedName);
        }
    }

    public final void performAutoImport(DocReferenceSym docReferenceSym) {
        String string = docReferenceSym.refClassName;
        this.performAutoImport(docReferenceSym, string);
        if (this.addImportName == null && this.simplifiedName != null) {
            this.dropPrefix(docReferenceSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(Sym sym, String string) {
        String string2;
        this.addImportName = null;
        this.simplifiedName = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return;
        }
        String string3 = string.substring(0, n);
        String string4 = string2 = string.substring(n + 1);
        JavaProvider javaProvider = this.fileSym.getProvider();
        if (javaProvider == null) {
            return;
        }
        CompilerDriver compilerDriver = new CompilerDriver(javaProvider, this.fileSym.j2se);
        JavaType javaType = compilerDriver.resolveType(sym, string3);
        if (javaType != null) {
            boolean bl = this.preferences.getBoolean(64);
            String string5 = javaType.getQualifiedName();
            if (!string3.equals(string5)) {
                if (!bl) {
                    return;
                }
            } else if (!bl) {
                string3 = javaType.getPackageName();
                string4 = javaType.getName();
                string2 = string.substring(string3.length() + 1);
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        JavaType javaType2 = compilerDriver.resolveType(sym, string4);
        if (javaType2 != null) {
            int n2;
            int n3 = string3.length();
            String string6 = javaType2.getQualifiedName();
            String string7 = string6.substring(0, n2 = string6.lastIndexOf(46));
            if (!string3.equals(string7)) {
                bl2 = true;
                if (!this.isSafeToAddNarrowImport(string4)) {
                    return;
                }
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.addImportName = string3 + '.' + string4;
        }
        this.simplifiedName = string2;
    }

    private void dropPrefix(TypeSym typeSym, String string) {
        TypeSym typeSym2 = typeSym;
        typeSym2.setName(string);
    }

    private void dropPrefix(DotExpr dotExpr, String string) {
        DotExpr dotExpr2 = dotExpr;
        FileSym fileSym = dotExpr2.symFile;
        SymFactory symFactory = fileSym.getSymFactory();
        try {
            Expr expr = (Expr)symFactory.createExpression(string);
            dotExpr2.replaceSelf(expr);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void dropPrefix(DocReferenceSym docReferenceSym, String string) {
        try {
            DocReferenceSym docReferenceSym2 = (DocReferenceSym)docReferenceSym.cloneSelf(this.fileSym);
            docReferenceSym2.refClassName = string;
            docReferenceSym.replaceSelf(docReferenceSym2);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private boolean isSafeToAddNarrowImport(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (String string2 : this.importNames) {
            if (!string2.endsWith(string)) continue;
            return false;
        }
        SourceClass sourceClass = this.fileSym.getSourceClass(string);
        return sourceClass == null;
    }

    static ArrayList ra$typeSyms(ImportHelper importHelper) {
        return importHelper.typeSyms;
    }

    static ArrayList ra$dotExprs(ImportHelper importHelper) {
        return importHelper.dotExprs;
    }

    static ArrayList ra$docReferenceSyms(ImportHelper importHelper) {
        return importHelper.docReferenceSyms;
    }

    private class ImportHelperTraversal
    extends Sym.SymTraversal {
        private final boolean onlyNew;

        ImportHelperTraversal() {
            this(true);
        }

        ImportHelperTraversal(boolean bl) {
            this.onlyNew = bl;
        }

        protected boolean enter(Sym sym) {
            if (this.onlyNew && (sym.symFormat & 2) == 0) {
                return true;
            }
            if ((sym.symFormat & 0x20) != 0) {
                return true;
            }
            switch (sym.symKind) {
                case 28: {
                    ImportHelper.ra$typeSyms(ImportHelper.this).add(sym);
                    break;
                }
                case 50: {
                    DotExpr dotExpr = (DotExpr)sym;
                    if (!dotExpr.isQualifiedName()) break;
                    while (dotExpr != null) {
                        DotExpr dotExpr2 = dotExpr;
                        dotExpr = null;
                        JavaHasType javaHasType = dotExpr2.getResolvedObject();
                        if (javaHasType != null && javaHasType.getElementKind() == 3) {
                            ImportHelper.ra$dotExprs(ImportHelper.this).add(dotExpr2);
                            continue;
                        }
                        Expr expr = dotExpr2.getLhsOperandSym();
                        if (expr == null || expr.symKind != 50) continue;
                        dotExpr = (DotExpr)expr;
                    }
                    break;
                }
                case 67: {
                    DocReferenceSym docReferenceSym = (DocReferenceSym)sym;
                    String string = docReferenceSym.refClassName;
                    if (string == null || string.length() <= 0) break;
                    ImportHelper.ra$docReferenceSyms(ImportHelper.this).add(docReferenceSym);
                }
            }
            return true;
        }
    }
}

