/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.Arrays;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.util.OffsetPair;

public final class TokenMap {
    private final FileSym fromFile;
    private final FileSym toFile;
    public final int[] forwardMap;
    public final int[] backwardMap;

    public TokenMap(FileSym fileSym, FileSym fileSym2) {
        this.fromFile = fileSym;
        this.toFile = fileSym2;
        int n = fileSym.tokens.tokenCount;
        this.forwardMap = new int[n];
        Arrays.fill(this.forwardMap, -1);
        int n2 = fileSym2.tokens.tokenCount;
        this.backwardMap = new int[n2];
        Arrays.fill(this.backwardMap, -1);
        TokenMapTraversal tokenMapTraversal = new TokenMapTraversal(null);
        fileSym.traverseDual(fileSym2, tokenMapTraversal);
        this.forwardMap[n - 1] = n2 - 1;
        this.backwardMap[n2 - 1] = n - 1;
    }

    public int mapForward(int n) {
        return this.map(n, this.forwardMap);
    }

    public int mapBackward(int n) {
        return this.map(n, this.backwardMap);
    }

    private int map(int n, int[] nArray) {
        try {
            int n2 = nArray[n];
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n3 = -1;
            return n3;
        }
    }

    void alignSelf(FormatRegion formatRegion, boolean bl) {
        OffsetPair offsetPair;
        OffsetPair offsetPair2;
        int[] nArray;
        if (bl) {
            nArray = this.forwardMap;
            offsetPair2 = formatRegion.fromIndices;
            offsetPair = formatRegion.toIndices;
        } else {
            nArray = this.backwardMap;
            offsetPair2 = formatRegion.toIndices;
            offsetPair = formatRegion.fromIndices;
        }
        int n = offsetPair2.getStartOffset();
        int n2 = 0;
        while (n >= 0) {
            n2 = this.map(n, nArray);
            if (n2 >= 0) break;
            --n;
        }
        if (n < 0) {
            n = 0;
            n2 = 0;
        }
        int n3 = nArray.length;
        int n4 = offsetPair2.getEndOffset();
        int n5 = 0;
        while (n4 < n3) {
            n5 = this.map(n4, nArray);
            if (n5 >= 0) break;
            ++n4;
        }
        offsetPair2.setStartAndEnd(n, n4);
        offsetPair.setStartAndEnd(n2, n5);
    }

    private class TokenMapTraversal
    extends Sym.SymDualTraversal {
        int i;

        void $init$() {
            this.i = -1;
        }

        protected boolean enter(Sym sym, Sym sym2) {
            int n;
            int n2;
            if (sym.symKind == 71) {
                return false;
            }
            if (sym.symKind == 70) {
                return false;
            }
            if (sym2 != null && (n2 = sym.getStartIndex()) >= 0 && this.i < n2 && (n = sym2.getStartIndex()) >= 0) {
                TokenMap.this.forwardMap[n2] = n;
                TokenMap.this.backwardMap[n] = n2;
                this.i = n2;
            }
            return sym.symKind != 64;
        }

        protected boolean leave(Sym sym, Sym sym2) {
            int n;
            int n2;
            if (sym2 != null && (n2 = sym.getEndIndex()) >= 0 && this.i < n2 && (n = sym2.getEndIndex()) >= 0) {
                try {
                    TokenMap.this.forwardMap[n2] = n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println("Length is " + TokenMap.this.forwardMap.length);
                    sym.describeSelf(0);
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
                try {
                    TokenMap.this.backwardMap[n] = n2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println("Length is " + TokenMap.this.backwardMap.length);
                    sym2.describeSelf(0);
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
                this.i = n2;
            }
            return true;
        }

        private TokenMapTraversal() {
            this.$init$();
        }

        TokenMapTraversal(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

