/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class ArrayedLexer
extends FastLexer {
    private boolean flag_arrayed;
    private boolean flag_checkarrayed;
    private TokenArray tokens;
    private FastLexer baseLexer;
    private int index;

    void $init$() {
        this.flag_arrayed = true;
        this.flag_checkarrayed = false;
        this.index = -1;
    }

    public ArrayedLexer(TokenArray tokenArray, FastLexer fastLexer) {
        this.$init$();
        this.tokens = tokenArray;
        this.baseLexer = fastLexer;
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        super.setTextBuffer(readTextBuffer);
        this.baseLexer.setTextBuffer(readTextBuffer);
    }

    public void setPosition(int n) {
        this.align(n);
        this.baseLexer.setPosition(n);
    }

    private boolean align(int n) {
        this.flag_arrayed = false;
        if (n == 0) {
            this.flag_checkarrayed = true;
            this.index = -1;
        } else {
            this.index = this.tokens.search(n);
            if (this.index >= 0) {
                boolean bl = this.flag_checkarrayed = this.tokens.tokenStarts[this.index] == n;
                if (this.flag_checkarrayed) {
                    --this.index;
                }
            } else {
                this.flag_checkarrayed = false;
                this.index = -this.index - 1;
            }
        }
        return this.flag_checkarrayed;
    }

    public void setTokenIndex(int n) {
        boolean bl;
        this.flag_arrayed = true;
        boolean bl2 = bl = 0 <= n && n < this.tokens.tokenCount;
        if (!bl) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.index = n - 1;
    }

    public void setSkipComments(boolean bl) {
        super.setSkipComments(bl);
        this.baseLexer.setSkipComments(bl);
    }

    protected boolean isComment(int n) {
        return this.baseLexer.isComment(n);
    }

    public int getToken() {
        if (this.flag_arrayed) {
            if (this.index != -1) {
                return this.tokens.tokenValues[this.index];
            }
            return -1;
        }
        return this.baseLexer.getToken();
    }

    public int getStartOffset() {
        if (this.flag_arrayed) {
            if (this.index != -1) {
                return this.tokens.tokenStarts[this.index];
            }
            return 0;
        }
        return this.baseLexer.getStartOffset();
    }

    public int getEndOffset() {
        if (this.flag_arrayed) {
            if (this.index != -1) {
                return this.tokens.tokenEnds[this.index];
            }
            return 0;
        }
        return this.baseLexer.getEndOffset();
    }

    public int getTokenIndex() {
        return this.index;
    }

    public int lex() {
        return this.lex(null);
    }

    public int lex(LexerToken lexerToken) {
        if (this.flag_checkarrayed) {
            this.flag_arrayed = true;
            this.flag_checkarrayed = false;
        }
        if (this.flag_arrayed) {
            while (this.tokens.tokenCount > this.index + 1) {
                ++this.index;
                if (this.skipComments && this.isComment(this.tokens.tokenValues[this.index])) continue;
            }
            return this.tokens.tokenValues[this.index];
        }
        int n = this.baseLexer.lex(lexerToken);
        int n2 = this.baseLexer.getStartOffset();
        this.align(n2);
        if (this.align(n2)) {
            return this.lex();
        }
        return n;
    }
}

