/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.util.KeywordTable;

public class JavaLexer
extends FastLexer
implements LexerToken,
JavaTokens {
    public static final KeywordTable keyword13Table;
    public static final KeywordTable keyword14Table;
    public static final KeywordTable keyword15Table;
    private static final int TK_EOF = 0;
    private static final int FL_WHITESPACE = 0x1000000;
    private static final int FL_ID_START = 0x2000000;
    private static final int FL_ID_PART = 0x4000000;
    private static final int FL_SIMPLE_OP = 0x8000000;
    private static final int FL_DIGIT = 0x10000000;
    private static final int FL_COMP_EQ_OP = 0x20000000;
    private static final int MASK_TK = 4095;
    private static final int[] lookupTable;
    private short lastToken;
    private int startOffset;
    private int endOffset;
    private boolean recognizeSQLJ;
    private final KeywordTable keywordTable;

    static {
        lookupTable = new int[256];
        if (JavaTokens.KW_words.length != 50) {
            System.out.println("Warning: Keyword count mismatch");
        }
        if (JavaTokens.DW_words.length != JavaTokens.DW_values.length) {
            System.out.println("Warning: Duplicate word count mismatch");
        }
        int n = JavaTokens.DW_words.length;
        keyword13Table = new KeywordTable(48 + n);
        keyword13Table.setCaseSensitivity(true);
        keyword14Table = new KeywordTable(49 + n);
        keyword14Table.setCaseSensitivity(true);
        keyword15Table = new KeywordTable(50 + n);
        keyword15Table.setCaseSensitivity(true);
        int n2 = 96;
        while (n2 < 146) {
            if (n2 < 144) {
                keyword13Table.addKeyword(JavaTokens.KW_words[n2 - 96], n2);
            }
            if (n2 < 145) {
                keyword14Table.addKeyword(JavaTokens.KW_words[n2 - 96], n2);
            }
            if (n2 < 146) {
                keyword15Table.addKeyword(JavaTokens.KW_words[n2 - 96], n2);
            }
            n2 = (short)(n2 + 1);
        }
        int n3 = 0;
        while (n3 < n) {
            keyword13Table.addKeyword(JavaTokens.DW_words[n3], JavaTokens.DW_values[n3]);
            keyword14Table.addKeyword(JavaTokens.DW_words[n3], JavaTokens.DW_values[n3]);
            keyword15Table.addKeyword(JavaTokens.DW_words[n3], JavaTokens.DW_values[n3]);
            ++n3;
        }
        char c = lookupTable.length;
        char c2 = '\u0000';
        while (c2 < c) {
            int n4 = 0;
            if (Character.isWhitespace(c2)) {
                n4 |= 0x1000000;
            }
            if (Character.isJavaIdentifierStart(c2)) {
                n4 |= 0x2000000;
            }
            if (Character.isJavaIdentifierPart(c2)) {
                n4 |= 0x4000000;
            }
            if (Character.isDigit(c2) && c2 != '0') {
                n4 |= 0x10000000;
            }
            if (n4 != 0) {
                JavaLexer.lookupTable[c2] = n4;
            }
            c2 = (char)(c2 + '\u0001');
        }
        JavaLexer.setSimpleOp(64, 79);
        JavaLexer.setSimpleOp(123, 49);
        JavaLexer.setSimpleOp(125, 70);
        JavaLexer.setSimpleOp(91, 50);
        JavaLexer.setSimpleOp(93, 71);
        JavaLexer.setSimpleOp(40, 55);
        JavaLexer.setSimpleOp(41, 72);
        JavaLexer.setSimpleOp(44, 39);
        JavaLexer.setSimpleOp(59, 75);
        JavaLexer.setSimpleOp(126, 35);
        JavaLexer.setSimpleOp(63, 69);
        JavaLexer.setSimpleOp(58, 38);
        JavaLexer.setCompoundEqualsOp(33, 53, 65);
        JavaLexer.setCompoundEqualsOp(42, 63, 64);
        JavaLexer.setCompoundEqualsOp(61, 33, 44);
        JavaLexer.setCompoundEqualsOp(37, 61, 62);
        JavaLexer.setCompoundEqualsOp(94, 37, 78);
    }

    public JavaLexer() {
        this(JavaParser.j2se);
    }

    public JavaLexer(int n) {
        this.setSkipComments(false);
        this.recognizeSQLJ = true;
        this.setTextBuffer(null);
        this.setPosition(0);
        switch (n) {
            case 1: {
                this.keywordTable = keyword13Table;
                break;
            }
            default: {
                this.keywordTable = keyword14Table;
                break;
            }
            case 3: {
                this.keywordTable = keyword15Table;
            }
        }
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.lastToken = (short)-1;
        this.startOffset = -1;
        this.endOffset = -1;
    }

    public void setRecognizeSQLJ(boolean bl) {
        this.recognizeSQLJ = bl;
    }

    protected boolean isComment(int n) {
        switch (n) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public int getToken() {
        return this.lastToken;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int lex() {
        return this.lex(null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken var1_1) {
        block84: {
            block85: {
                this.lastToken = 0;
                try {
                    block60: while (true) {
                        this.startOffset = this.currentPos;
                        if ((var2_2 = this.textBuffer.getChar(this.currentPos++)) < '\u0100') {
                            var3_3 = JavaLexer.lookupTable[var2_2];
                            if ((var3_3 & 0x1000000) != 0) continue;
                            if ((var3_3 & 0x2000000) != 0) {
                                this.handleIdentifier(var2_2);
                                break block84;
                            }
                            if ((var3_3 & 0x8000000) != 0) {
                                this.lastToken = (short)(var3_3 & 4095);
                                break block84;
                            }
                            if ((var3_3 & 0x20000000) != 0) {
                                this.lastToken = (short)(var3_3 & 4095);
                                if (this.textBuffer.getChar(this.currentPos) == '=') {
                                    this.lastToken = (short)(var3_3 >> 12 & 4095);
                                    ++this.currentPos;
                                }
                                break block84;
                            }
                            if ((var3_3 & 0x10000000) != 0) {
                                this.lastToken = (short)8;
                                this.handleDecimal(var2_2);
                                break block84;
                            }
                        }
                        switch (var2_2) {
                            case '&': {
                                this.lastToken = (short)34;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '&': {
                                        this.lastToken = (short)52;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = (short)32;
                                        ++this.currentPos;
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '|': {
                                this.lastToken = (short)36;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '|': {
                                        this.lastToken = (short)54;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = (short)66;
                                        ++this.currentPos;
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '+': {
                                this.lastToken = (short)67;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '+': {
                                        this.lastToken = (short)48;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = (short)68;
                                        ++this.currentPos;
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '-': {
                                this.lastToken = (short)59;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '-': {
                                        this.lastToken = (short)40;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = (short)60;
                                        ++this.currentPos;
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '<': {
                                this.lastToken = (short)58;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '=': {
                                        this.lastToken = (short)51;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '<': {
                                        this.lastToken = (short)56;
                                        ++this.currentPos;
                                        var2_2 = this.textBuffer.getChar(this.currentPos);
                                        if (var2_2 == '=') {
                                            this.lastToken = (short)57;
                                            ++this.currentPos;
                                        }
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '>': {
                                this.lastToken = (short)46;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                block35 : switch (var2_2) {
                                    case '=': {
                                        this.lastToken = (short)45;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '>': {
                                        this.lastToken = (short)73;
                                        ++this.currentPos;
                                        var2_2 = this.textBuffer.getChar(this.currentPos);
                                        switch (var2_2) {
                                            case '=': {
                                                this.lastToken = (short)74;
                                                ++this.currentPos;
                                                break block35;
                                            }
                                            case '>': {
                                                this.lastToken = (short)76;
                                                ++this.currentPos;
                                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                                if (var2_2 != '=') break;
                                                this.lastToken = (short)77;
                                                ++this.currentPos;
                                            }
                                        }
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '/': {
                                this.lastToken = (short)41;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '=': {
                                        this.lastToken = (short)42;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '*': {
                                        this.lastToken = (short)25;
                                        ++this.currentPos;
                                        this.skipMultiLineComment();
                                        if (this.textBuffer.getChar(this.startOffset + 2) == '*') {
                                            this.lastToken = (short)26;
                                        }
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            continue block60;
                                        }
                                        break block84;
                                    }
                                    case '/': {
                                        this.lastToken = (short)24;
                                        ++this.currentPos;
                                        this.skipLineComment();
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            continue block60;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block84;
                            }
                            case '\"': {
                                this.lastToken = (short)14;
                                this.skipStringLiteral();
                                break block60;
                            }
                            case '\'': {
                                this.lastToken = (short)13;
                                this.skipCharacterLiteral();
                                break block60;
                            }
                            case '.': {
                                this.lastToken = (short)43;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                if (JavaLexer.isDecimalDigit(var2_2)) {
                                    ++this.currentPos;
                                    this.lastToken = (short)10;
                                    this.skipFloatLiteral();
                                    break block60;
                                }
                                if (var2_2 == '.' && this.textBuffer.getChar(this.currentPos + 1) == '.') {
                                    this.lastToken = (short)80;
                                    this.currentPos += 2;
                                    break block60;
                                }
                                break block84;
                            }
                            case '0': {
                                this.lastToken = (short)8;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case 'X': 
                                    case 'x': {
                                        ++this.currentPos;
                                        this.skipHexDigits();
                                        break block60;
                                    }
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        ++this.currentPos;
                                        this.skipDecimalDigits();
                                        break;
                                    }
                                }
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '.': {
                                        ++this.currentPos;
                                        this.lastToken = (short)11;
                                        this.skipFloatLiteral();
                                        break;
                                    }
                                    case 'E': 
                                    case 'e': {
                                        this.lastToken = (short)11;
                                        this.skipFloatLiteral();
                                        break;
                                    }
                                    case 'L': 
                                    case 'l': {
                                        ++this.currentPos;
                                        this.lastToken = (short)9;
                                        break;
                                    }
                                    case 'F': 
                                    case 'f': {
                                        ++this.currentPos;
                                        this.lastToken = (short)10;
                                        break;
                                    }
                                    case 'D': 
                                    case 'd': {
                                        ++this.currentPos;
                                        this.lastToken = (short)11;
                                        break block84;
                                    }
                                }
                                break block84;
                            }
                            case '#': {
                                if (this.recognizeSQLJ && this.textBuffer.getLength() - this.currentPos >= 3 && this.textBuffer.getChar(this.currentPos) == 's' && this.textBuffer.getChar(this.currentPos + 1) == 'q' && this.textBuffer.getChar(this.currentPos + 2) == 'l') {
                                    if (this.textBuffer.getLength() - this.currentPos > 3) {
                                        var2_2 = this.textBuffer.getChar(this.currentPos + 3);
                                        if (Character.isWhitespace(var2_2) || var2_2 == '{' || var2_2 == '[') {
                                            this.lastToken = (short)6;
                                            this.currentPos += 4;
                                            this.skipSQLJStatement();
                                            break block60;
                                        }
                                    } else {
                                        this.lastToken = (short)6;
                                        this.currentPos += 3;
                                        this.skipSQLJStatement();
                                        break block60;
                                    }
                                }
                            }
                            default: {
                                if (!Character.isJavaIdentifierStart(var2_2)) {
                                    this.lastToken = 0;
                                    continue block60;
                                }
                                this.handleIdentifier(var2_2);
                            }
                        }
                        break;
                    }
                    break block84;
                }
                catch (IndexOutOfBoundsException var4_4) {
                    this.currentPos = this.textBuffer.getLength();
                    if (this.lastToken == 0) {
                        this.startOffset = this.currentPos;
                        break block85;
                    }
                    if (this.lastToken != 4) break block85;
                    var5_5 = 0;
                    var6_6 = this.startOffset;
                    ** while (var6_6 < this.currentPos)
                }
lbl-1000:
                // 1 sources

                {
                    var7_7 = this.textBuffer.getChar(var6_6);
                    var5_5 = KeywordTable.computePartialHash(var7_7, var5_5);
                    ++var6_6;
                    continue;
                }
lbl236:
                // 1 sources

                var8_8 = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, var5_5);
                if (var8_8 != -1) {
                    this.lastToken = (short)var8_8;
                }
            }
            if (this.skipComments && this.isComment(this.lastToken)) {
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            } else if (this.lastToken == 25 && this.startOffset + 2 < this.currentPos && this.textBuffer.getChar(this.startOffset + 2) == '*') {
                this.lastToken = (short)26;
            }
        }
        this.endOffset = this.currentPos;
        return this.fillLexerToken(var1_1);
    }

    public void backup() {
        throw new RuntimeException("Operation not supported");
    }

    private void handleIdentifier(char c) {
        int n;
        this.lastToken = (short)4;
        int n2 = KeywordTable.computePartialHash(c, 0);
        while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && (lookupTable[c] & 0x4000000) != 0) {
            n2 = KeywordTable.computePartialHash(c, n2);
            ++this.currentPos;
        }
        if (c >= '\u0100') {
            while (Character.isJavaIdentifierPart(c = this.textBuffer.getChar(this.currentPos))) {
                n2 = KeywordTable.computePartialHash(c, n2);
                ++this.currentPos;
            }
        }
        if ((n = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, n2)) != -1) {
            this.lastToken = (short)n;
        }
    }

    private void handleDecimal(char c) {
        this.lastToken = (short)8;
        this.skipDecimalDigits();
        c = this.textBuffer.getChar(this.currentPos);
        switch (c) {
            case 'L': 
            case 'l': {
                ++this.currentPos;
                this.lastToken = (short)9;
                break;
            }
            case 'F': 
            case 'f': {
                ++this.currentPos;
                this.lastToken = (short)10;
                break;
            }
            case 'D': 
            case 'd': {
                ++this.currentPos;
                this.lastToken = (short)11;
                break;
            }
            case '.': {
                ++this.currentPos;
                this.lastToken = (short)11;
                this.skipFloatLiteral();
                break;
            }
            case 'E': 
            case 'e': {
                this.lastToken = (short)11;
                this.skipFloatLiteral();
            }
        }
    }

    private void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipCharacterLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\'': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipSQLJStatement() {
        boolean bl = false;
        block8: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case ';': {
                    if (bl) continue block8;
                    return;
                }
                case '{': {
                    bl = true;
                    break;
                }
                case '}': {
                    bl = false;
                    break;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c == '/') {
                        this.skipLineComment();
                        break;
                    }
                    if (c != '*') continue block8;
                    this.skipMultiLineComment();
                    break;
                }
                case '-': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '-') continue block8;
                    this.skipLineComment();
                    break;
                }
                case '\"': 
                case '\'': {
                    char c2 = c;
                    while ((c = this.textBuffer.getChar(this.currentPos++)) != c2) {
                    }
                    break;
                }
            }
        }
    }

    private void skipFloatLiteral() {
        char c = this.textBuffer.getChar(this.currentPos);
        while (JavaLexer.isDecimalDigit(c)) {
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
        }
        switch (c) {
            case 'E': 
            case 'e': {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '+' || c == '-') {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                while (JavaLexer.isDecimalDigit(c)) {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                break;
            }
        }
        switch (c) {
            case 'F': 
            case 'f': {
                this.lastToken = (short)10;
            }
            case 'D': 
            case 'd': {
                ++this.currentPos;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (JavaLexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void skipHexDigits() {
        while (true) {
            char c;
            if (!JavaLexer.isHexDigit(c = this.textBuffer.getChar(this.currentPos))) {
                if (c == 'l' || c == 'L') {
                    this.lastToken = (short)9;
                    ++this.currentPos;
                }
                return;
            }
            ++this.currentPos;
        }
    }

    private int fillLexerToken(LexerToken lexerToken) {
        if (lexerToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    public static boolean isHexDigit(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        if ('a' <= c && c <= 'f') {
            return true;
        }
        return 'A' <= c && c <= 'F';
    }

    private static void setSimpleOp(int n, int n2) {
        JavaLexer.lookupTable[n] = 0x8000000 | n2 & 0xFFF;
    }

    private static void setCompoundEqualsOp(int n, int n2, int n3) {
        JavaLexer.lookupTable[n] = 0x20000000 | n2 & 0xFFF | (n3 & 0xFFF) << 12;
    }
}

