/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.java.v2.scanner.LexerUtilities;

public class LexerLiteral
implements JavaConstants {
    private static boolean[] isHexDigit = new boolean[256];
    private static boolean[] isOctDigit = new boolean[256];
    private static boolean[] isDecDigit = new boolean[256];
    private static byte[] hexValue = new byte[256];
    public final short literalToken;
    public short literalError;
    public boolean flag_dw;
    public boolean literalBoolean;
    public char literalChar;
    public String literalString;
    public long literalInteger;
    public double literalFloat;

    static {
        int n = 48;
        while (n <= 57) {
            LexerLiteral.isOctDigit[n] = true;
            LexerLiteral.isDecDigit[n] = true;
            LexerLiteral.isHexDigit[n] = true;
            LexerLiteral.hexValue[n] = (byte)(n - 48);
            n = (byte)(n + 1);
        }
        LexerLiteral.isOctDigit[56] = false;
        LexerLiteral.isOctDigit[57] = false;
        int n2 = 97;
        while (n2 <= 102) {
            LexerLiteral.isHexDigit[n2] = true;
            LexerLiteral.hexValue[n2] = (byte)(n2 - 97 + 10);
            n2 = (byte)(n2 + 1);
        }
        int n3 = 65;
        while (n3 <= 70) {
            LexerLiteral.isHexDigit[n3] = true;
            LexerLiteral.hexValue[n3] = (byte)(n3 - 65 + 10);
            n3 = (byte)(n3 + 1);
        }
    }

    public static LexerLiteral scanConstant(FastLexer fastLexer) {
        boolean bl;
        int n = fastLexer.getToken();
        boolean bl2 = bl = 8 <= n && n < 16;
        if (!bl) {
            return null;
        }
        ReadTextBuffer readTextBuffer = fastLexer.getTextBuffer();
        int n2 = fastLexer.getStartOffset();
        int n3 = fastLexer.getEndOffset();
        return new LexerLiteral(readTextBuffer, n, n2, n3);
    }

    public static LexerLiteral scanConstant(LexerToken lexerToken, ReadTextBuffer readTextBuffer) {
        boolean bl;
        int n = lexerToken.getToken();
        boolean bl2 = bl = 8 <= n && n < 16;
        if (!bl) {
            return null;
        }
        int n2 = lexerToken.getStartOffset();
        int n3 = lexerToken.getEndOffset();
        return new LexerLiteral(readTextBuffer, n, n2, n3);
    }

    public static LexerLiteral copyConstant(LexerLiteral lexerLiteral) {
        return new LexerLiteral(lexerLiteral);
    }

    void $init$() {
        this.literalError = 0;
        this.flag_dw = false;
        this.literalBoolean = false;
        this.literalChar = '\u0000';
        this.literalString = null;
        this.literalInteger = 0L;
        this.literalFloat = 0.0;
    }

    private LexerLiteral(LexerLiteral lexerLiteral) {
        this.$init$();
        this.literalToken = lexerLiteral.literalToken;
        this.literalError = lexerLiteral.literalError;
        this.flag_dw = lexerLiteral.flag_dw;
        this.literalBoolean = lexerLiteral.literalBoolean;
        this.literalChar = lexerLiteral.literalChar;
        this.literalString = lexerLiteral.literalString;
        this.literalInteger = lexerLiteral.literalInteger;
        this.literalFloat = lexerLiteral.literalFloat;
    }

    private LexerLiteral(ReadTextBuffer readTextBuffer, int n, int n2, int n3) {
        this.$init$();
        this.literalToken = (short)n;
        switch (n) {
            case 12: {
                this.scanBooleanLiteral(readTextBuffer, n2, n3);
                break;
            }
            case 13: {
                this.scanCharLiteral(readTextBuffer, n2, n3);
                break;
            }
            case 9: {
                this.flag_dw = true;
            }
            case 8: {
                this.scanIntegerLiteral(readTextBuffer, n2, n3);
                break;
            }
            case 11: {
                this.flag_dw = true;
            }
            case 10: {
                this.scanFloatLiteral(readTextBuffer, n2, n3);
                break;
            }
            case 14: {
                this.scanStringLiteral(readTextBuffer, n2, n3);
                break;
            }
            case 15: {
                break;
            }
        }
    }

    public Object getConstantValue() {
        switch (this.literalToken) {
            case 12: {
                if (this.literalBoolean) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 13: {
                return new Character(this.literalChar);
            }
            case 9: {
                return new Long(this.literalInteger);
            }
            case 8: {
                return new Integer((int)this.literalInteger);
            }
            case 11: {
                return new Double(this.literalFloat);
            }
            case 10: {
                return new Float((float)this.literalFloat);
            }
            case 14: {
                return this.literalString;
            }
        }
        return null;
    }

    private void scanBooleanLiteral(ReadTextBuffer readTextBuffer, int n, int n2) {
        this.literalBoolean = readTextBuffer.getChar(n) == 't';
    }

    private void scanStringLiteral(ReadTextBuffer readTextBuffer, int n, int n2) {
        if (n2 > n + 2) {
            char[] cArray = readTextBuffer.getChars(n + 1, n2 - n - 2);
            this.literalString = LexerUtilities.chars2string(cArray);
        } else {
            this.literalString = "";
        }
    }

    private void scanCharLiteral(ReadTextBuffer readTextBuffer, int n, int n2) {
        if (n2 > n + 2) {
            char[] cArray = readTextBuffer.getChars(n + 1, n2 - n - 1);
            String string = LexerUtilities.chars2string(cArray);
            this.literalChar = string.charAt(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void scanIntegerLiteral(ReadTextBuffer var1_1, int var2_2, int var3_3) {
        block8: {
            var4_4 = 0;
            try {
                block9: {
                    var5_5 = var2_2;
                    var6_6 = var1_1.getChar(var5_5++);
                    if (var6_6 != '0') break block9;
                    if (var3_3 == var5_5) {
                        return;
                    }
                    if ((var6_6 = var1_1.getChar(var5_5++)) != 'x' && var6_6 != 'X') ** GOTO lbl19
                    while (var5_5 < var3_3) {
                        if ((var6_6 = var1_1.getChar(var5_5++)) < '\u0100' && LexerLiteral.isHexDigit[var6_6]) {
                            var4_4 *= 16;
                            var4_4 += LexerLiteral.hexValue[var6_6];
                            continue;
                        }
                        break block8;
                    }
                    break block8;
                    while ((var6_6 = var1_1.getChar(var5_5++)) < '\u0100' && LexerLiteral.isOctDigit[var6_6]) {
                        var4_4 *= 8;
                        var4_4 += LexerLiteral.hexValue[var6_6];
lbl19:
                        // 2 sources

                        if (var5_5 < var3_3) continue;
                        break block8;
                    }
                    break block8;
                }
                var4_4 = LexerLiteral.hexValue[var6_6];
                if (var4_4 == 0) break block8;
                while (var5_5 < var3_3) {
                    if ((var6_6 = var1_1.getChar(var5_5++)) < '\u0100' && LexerLiteral.isDecDigit[var6_6]) {
                        var4_4 *= 10;
                        var4_4 += LexerLiteral.hexValue[var6_6];
                        continue;
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException var7_7) {
                // empty catch block
            }
        }
        this.literalInteger = var4_4;
    }

    private boolean isZeroFloating(ReadTextBuffer readTextBuffer, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = readTextBuffer.getChar(n3);
            if (49 < n3 && n3 <= 57) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private strictfp void scanFloatLiteral(ReadTextBuffer readTextBuffer, int n, int n2) {
        this.flag_dw = true;
        char c = readTextBuffer.getChar(n2 - 1);
        boolean bl = true;
        if (c == 'f' || c == 'F') {
            this.flag_dw = false;
            bl = false;
        } else if (c == 'd' || c == 'D') {
            bl = false;
        }
        int n3 = n2 - n;
        if (!bl) {
            --n3;
        }
        String string = readTextBuffer.getString(n, n3);
        try {
            double d = this.flag_dw ? Double.parseDouble(string) : (double)Float.parseFloat(string);
            if (d == 0.0 && !this.isZeroFloating(readTextBuffer, n, n2)) {
                this.literalError = (short)6;
            } else if (d == Double.POSITIVE_INFINITY) {
                this.literalError = (short)5;
            }
            this.literalFloat = d;
        }
        catch (NumberFormatException numberFormatException) {
            this.literalError = (short)4;
        }
    }
}

