/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import java.util.Arrays;
import oracle.javatools.parser.java.v2.scanner.FastLexer;

public final class TokenArray {
    public int tokenCount;
    public short[] tokenValues;
    public int[] tokenStarts;
    public int[] tokenEnds;

    void $init$() {
        this.tokenCount = 0;
        this.tokenValues = new short[1];
        this.tokenStarts = new int[1];
        this.tokenEnds = new int[1];
    }

    public TokenArray(FastLexer fastLexer) {
        this.$init$();
        this.tokenize(fastLexer);
        this.finish();
    }

    public void adjust(int n) {
        int n2 = this.tokenCount;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            this.tokenStarts[n4] = this.tokenStarts[n4] + n;
            int n5 = n3++;
            this.tokenEnds[n5] = this.tokenEnds[n5] + n;
        }
    }

    public int search(int n) {
        int n2 = Arrays.binarySearch(this.tokenStarts, n);
        if (n2 >= 0) {
            return n2;
        }
        int n3 = -n2;
        if (n3 == this.tokenCount) {
            return this.tokenCount - 1;
        }
        if (n3 == -1) {
            return 0;
        }
        int n4 = n3 - 1;
        int n5 = this.tokenEnds[n4];
        if (n5 < n) {
            return n4 + 1;
        }
        return -n4;
    }

    public int offset2index(int n, boolean bl) {
        int n2 = Arrays.binarySearch(this.tokenStarts, n);
        if (n2 >= 0) {
            if (bl) {
                return n2;
            }
            if (n2 == 0) {
                return n2;
            }
            int n3 = this.tokenEnds[n2 - 1];
            if (n3 == n) {
                return n2 - 1;
            }
            return n2;
        }
        int n4 = -n2 - 1;
        if (n4 == 0) {
            return -1;
        }
        if (n <= this.tokenEnds[n4 - 1]) {
            return n4 - 1;
        }
        return -(n4 + 1);
    }

    private void tokenize(FastLexer fastLexer) {
        short s;
        do {
            s = (short)fastLexer.lex();
            int n = fastLexer.getStartOffset();
            int n2 = fastLexer.getEndOffset();
            this.addToken(s, n, n2);
        } while (s != 0);
    }

    private void finish() {
        if (this.tokenCount == 0) {
            throw new RuntimeException();
        }
        this.trim();
        if (this.tokenValues[this.tokenCount - 1] != 0) {
            throw new RuntimeException();
        }
    }

    private void trim() {
        int n = this.tokenValues.length;
        if (n == this.tokenCount) {
            return;
        }
        short[] sArray = new short[this.tokenCount];
        short[] sArray2 = this.tokenValues;
        int[] nArray = new int[this.tokenCount];
        int[] nArray2 = this.tokenStarts;
        int[] nArray3 = new int[this.tokenCount];
        int[] nArray4 = this.tokenEnds;
        System.arraycopy(sArray2, 0, sArray, 0, this.tokenCount);
        System.arraycopy(nArray2, 0, nArray, 0, this.tokenCount);
        System.arraycopy(nArray4, 0, nArray3, 0, this.tokenCount);
        this.tokenValues = sArray;
        this.tokenStarts = nArray;
        this.tokenEnds = nArray3;
    }

    private void addToken(short s, int n, int n2) {
        if (this.tokenCount == this.tokenValues.length) {
            this.expandTokenArrays();
        }
        this.tokenValues[this.tokenCount] = s;
        this.tokenStarts[this.tokenCount] = n;
        this.tokenEnds[this.tokenCount] = n2;
        ++this.tokenCount;
    }

    private void expandTokenArrays() {
        int n = this.tokenCount << 3;
        short[] sArray = new short[n];
        short[] sArray2 = this.tokenValues;
        int[] nArray = new int[n];
        int[] nArray2 = this.tokenStarts;
        int[] nArray3 = new int[n];
        int[] nArray4 = this.tokenEnds;
        System.arraycopy(sArray2, 0, sArray, 0, this.tokenCount);
        System.arraycopy(nArray2, 0, nArray, 0, this.tokenCount);
        System.arraycopy(nArray4, 0, nArray3, 0, this.tokenCount);
        this.tokenValues = sArray;
        this.tokenStarts = nArray;
        this.tokenEnds = nArray3;
    }
}

