/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.util.ArrayListHeap;

public class Conversions
extends ArrayListHeap
implements JavaConstants {
    public static boolean applyWideningConversion(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        return PrimitiveType.applyWideningConversion(primitiveType, primitiveType2);
    }

    public static boolean applyNarrowingConversion(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        return PrimitiveType.applyNarrowingConversion(primitiveType, primitiveType2);
    }

    public static JavaType applyBoxingConversion(PrimitiveType primitiveType, JavaProvider javaProvider) {
        if (primitiveType == null) {
            return null;
        }
        byte by = primitiveType.primCode;
        String string = JavaConstants.PRIMITIVE_autoboxes[by];
        if (string != null && javaProvider != null) {
            return javaProvider.getClassByVMName(string);
        }
        return null;
    }

    public static PrimitiveType applyUnboxingConversion(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType.isPrimitive()) {
            return (PrimitiveType)javaType;
        }
        return PrimitiveType.applyUnboxingConversion(javaType);
    }

    public static boolean applyAssignmentConversion(JavaType javaType, JavaType javaType2, boolean bl, JavaProvider javaProvider) {
        if (javaType == null || javaType2 == null) {
            return true;
        }
        if (Conversions.applyMethodConversion(javaType, javaType2, true, javaProvider)) {
            return true;
        }
        if (bl && javaType.isPrimitive() && javaType2.isPrimitive()) {
            return PrimitiveType.applyNarrowingConversion((PrimitiveType)javaType, (PrimitiveType)javaType2);
        }
        return javaType.getElementKind() != 3 && Conversions.getUpperBounds(javaType).isEmpty() && Conversions.getLowerBounds(javaType).isEmpty();
    }

    public static boolean applyMethodConversion(JavaType javaType, JavaType javaType2, boolean bl, JavaProvider javaProvider) {
        if (javaType == null || javaType2 == null) {
            return false;
        }
        if (Conversions.isSubtypeOf(javaType, javaType2)) {
            return true;
        }
        if (javaType.isPrimitive()) {
            if (!bl) {
                return false;
            }
            JavaType javaType3 = Conversions.applyBoxingConversion((PrimitiveType)javaType, javaProvider);
            if (javaType3 != null) {
                return Conversions.applyMethodConversion(javaType3, javaType2, false, javaProvider);
            }
            return false;
        }
        if (javaType2.isPrimitive()) {
            if (!bl) {
                return false;
            }
            PrimitiveType primitiveType = Conversions.applyUnboxingConversion(javaType);
            if (primitiveType != null) {
                return Conversions.applyMethodConversion(primitiveType, javaType2, false, javaProvider);
            }
            return false;
        }
        if (javaType.isArray() || javaType2.isArray()) {
            return false;
        }
        return false;
    }

    public static boolean applyCastingConversion(JavaType javaType, JavaType javaType2, JavaProvider javaProvider) {
        if (javaType == null || javaType2 == null) {
            return true;
        }
        boolean bl = Conversions.applyAssignmentConversion(javaType, javaType2, true, javaProvider);
        if (bl) {
            return true;
        }
        if (javaType.isPrimitive() && javaType2.isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)javaType;
            PrimitiveType primitiveType2 = (PrimitiveType)javaType2;
            return primitiveType.primCode == 1 && primitiveType2.primCode == 2;
        }
        if (javaType.isInterface()) {
            if (!javaType2.isFinal()) {
                return true;
            }
            return Conversions.isSubtypeOf(javaType2, javaType);
        }
        if (javaType2.isInterface() && !javaType.isFinal()) {
            return true;
        }
        return Conversions.isSubtypeOf(javaType2, javaType);
    }

    public static boolean inheritsFrom(JavaType javaType, JavaType javaType2) {
        if (javaType == null || javaType2 == null) {
            return false;
        }
        String string = javaType2.getDescriptor();
        if ("Ljava/lang/Object;".equals(javaType2.getTypeSignature())) {
            return true;
        }
        if (string.equals(javaType.getDescriptor())) {
            return true;
        }
        for (JavaType javaType3 : javaType.getHierarchy()) {
            if (!string.equals(javaType3.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubtypeOf(JavaType javaType, JavaType javaType2) {
        if (javaType == null || javaType2 == null) {
            return false;
        }
        if (javaType.equals(javaType2)) {
            return true;
        }
        if (javaType.isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)javaType;
            if (javaType2.isPrimitive()) {
                return PrimitiveType.applyWideningConversion(primitiveType, (PrimitiveType)javaType2);
            }
            if (primitiveType.primCode == 8) {
                return true;
            }
        }
        if (javaType2.isPrimitive()) {
            return false;
        }
        if (javaType.isArray() && javaType2.isArray()) {
            JavaType javaType3 = javaType.getComponentType();
            if (javaType3 == null) {
                return false;
            }
            if (!javaType3.isPrimitive()) {
                return Conversions.isSubtypeOf(javaType3, javaType2.getComponentType());
            }
            PrimitiveType primitiveType = (PrimitiveType)javaType3;
            return primitiveType.primCode == 8;
        }
        return Conversions.isSubtypeOfImpl(javaType, javaType2);
    }

    public static boolean isSubtypeOfImpl(JavaType javaType, JavaType javaType2) {
        if (javaType == null || javaType2 == null) {
            return false;
        }
        if (javaType.equals(javaType2)) {
            return true;
        }
        if ("*".equals(javaType.getTypeSignature()) || "Ljava/lang/Object;".equals(javaType2.getTypeSignature())) {
            return true;
        }
        int n = javaType.getElementKind();
        int n2 = javaType2.getElementKind();
        if (n2 == 3) {
            if (n == 3) {
                return Conversions.inheritsFrom(javaType, javaType2);
            }
            Collection collection = Conversions.getUpperBounds(javaType);
            for (JavaType javaType3 : collection) {
                if (!Conversions.isSubtypeOfImpl(javaType3, javaType2)) continue;
                return true;
            }
            return false;
        }
        Collection collection = Conversions.getUpperBounds(javaType2);
        if (!Conversions.satisfiesBounds(javaType, collection, true)) {
            return false;
        }
        Collection collection2 = Conversions.getLowerBounds(javaType2);
        return Conversions.satisfiesBounds(javaType, collection2, false);
    }

    private static Collection getUpperBounds(JavaType javaType) {
        if (javaType.getElementKind() == 10) {
            JavaTypeVariable javaTypeVariable = (JavaTypeVariable)javaType;
            return javaTypeVariable.getBounds();
        }
        JavaWildcardType javaWildcardType = (JavaWildcardType)javaType;
        return javaWildcardType.getUpperBounds();
    }

    private static Collection getLowerBounds(JavaType javaType) {
        if (javaType.getElementKind() == 10) {
            return JavaConstants.kEmptyCollection;
        }
        JavaWildcardType javaWildcardType = (JavaWildcardType)javaType;
        return javaWildcardType.getLowerBounds();
    }

    private static boolean satisfiesBounds(JavaType javaType, Collection collection, boolean bl) {
        if (collection == JavaConstants.kEmptyCollection) {
            return true;
        }
        if (collection.isEmpty()) {
            return true;
        }
        for (JavaType javaType2 : collection) {
            if (!(bl ? !Conversions.satisfiesUpperBound(javaType, javaType2) : !Conversions.satisfiesLowerBound(javaType, javaType2))) continue;
            return false;
        }
        return true;
    }

    private static boolean satisfiesUpperBound(JavaType javaType, JavaType javaType2) {
        if (javaType.getElementKind() == 3) {
            return Conversions.isSubtypeOfImpl(javaType, javaType2);
        }
        Collection collection = Conversions.getUpperBounds(javaType);
        if (collection.isEmpty()) {
            return true;
        }
        for (JavaType javaType3 : collection) {
            if (!Conversions.isSubtypeOf(javaType3, javaType2)) continue;
            return true;
        }
        return false;
    }

    private static boolean satisfiesLowerBound(JavaType javaType, JavaType javaType2) {
        int n = javaType.getElementKind();
        if (n == 3) {
            return Conversions.isSubtypeOfImpl(javaType2, javaType);
        }
        Collection collection = Conversions.getLowerBounds(javaType);
        if (collection.isEmpty()) {
            return true;
        }
        for (JavaType javaType3 : collection) {
            if (!Conversions.isSubtypeOf(javaType2, javaType3)) continue;
            return true;
        }
        return false;
    }

    protected static JavaType applyUnaryPromotion(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        if (!javaType.isPrimitive()) {
            javaType = Conversions.applyUnboxingConversion(javaType);
        }
        if (javaType == null) {
            return null;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        byte by = JavaConstants.PRIMITIVE_unary[primitiveType.primCode];
        return PrimitiveType.PRIMITIVE_objects[by];
    }

    protected static JavaType applyBinaryPromotion(JavaType javaType, JavaType javaType2) {
        if (javaType == null || javaType2 == null) {
            return null;
        }
        if (!javaType.isPrimitive()) {
            javaType = Conversions.applyUnboxingConversion(javaType);
        }
        if (javaType == null) {
            return null;
        }
        if (!javaType2.isPrimitive()) {
            javaType2 = Conversions.applyUnboxingConversion(javaType);
        }
        if (javaType2 == null) {
            return null;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        PrimitiveType primitiveType2 = (PrimitiveType)javaType2;
        byte by = JavaConstants.PRIMITIVE_binary[primitiveType.primCode][primitiveType2.primCode];
        if (by != -1) {
            return PrimitiveType.PRIMITIVE_objects[by];
        }
        return null;
    }

    public static boolean hasSubsignatureOf(JavaMethod javaMethod, JavaMethod javaMethod2) {
        if (javaMethod == null || javaMethod2 == null) {
            return false;
        }
        if (!javaMethod2.getName().equals(javaMethod.getName())) {
            return false;
        }
        Collection collection = javaMethod.getParameters();
        Collection collection2 = javaMethod2.getParameters();
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass;
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            JavaVariable javaVariable2 = (JavaVariable)iterator2.next();
            JavaType javaType = javaVariable.getResolvedType();
            JavaType javaType2 = javaVariable2.getResolvedType();
            if (javaType == null && javaType2 == null) continue;
            if (javaType == null || javaType2 == null) {
                return false;
            }
            if (javaType2.equals(javaType) || (javaClass = javaType.getTypeErasure()) != null && javaType2.equals(javaClass)) continue;
            return false;
        }
        return true;
    }
}

