/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.util.ImportHelper;
import oracle.javatools.parser.java.v2.model.SourceElement;

public class SimplifyTypeHelper
implements JavaConstants {
    private final ImportHelper helper;

    public static void simplifyType(SourceElement sourceElement) {
        switch (sourceElement.getSymbolKind()) {
            case 28: {
                TypeSym typeSym = (TypeSym)sourceElement;
                ImportHelper importHelper = new ImportHelper(typeSym.symFile);
                importHelper.performAutoImport(typeSym);
                break;
            }
            case 50: {
                DotExpr dotExpr = (DotExpr)sourceElement;
                ImportHelper importHelper = new ImportHelper(dotExpr.symFile);
                importHelper.performAutoImport(dotExpr);
                break;
            }
            case 67: {
                DocReferenceSym docReferenceSym = (DocReferenceSym)sourceElement;
                ImportHelper importHelper = new ImportHelper(docReferenceSym.symFile);
                importHelper.performAutoImport(docReferenceSym);
            }
        }
    }

    public static void simplifyAllTypes(SourceElement sourceElement) {
        Sym sym = (Sym)sourceElement;
        ImportHelper importHelper = new ImportHelper(sym.symFile);
        importHelper.process(sym);
    }

    public static SimplifyTypeHelper simplifyTypeName(SourceElement sourceElement, String string) {
        if (sourceElement == null || string == null || !CommonUtilities.isValidQualifiedName(string)) {
            throw new IllegalArgumentException();
        }
        Sym sym = (Sym)sourceElement;
        FileSym fileSym = sym.symFile;
        try {
            SimplifyTypeHelper simplifyTypeHelper = new SimplifyTypeHelper(fileSym, sym, string);
            return simplifyTypeHelper;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            SimplifyTypeHelper simplifyTypeHelper = null;
            return simplifyTypeHelper;
        }
    }

    public String getImportName() {
        return this.helper.addImportName;
    }

    public String getSimplifiedName() {
        return this.helper.simplifiedName;
    }

    private SimplifyTypeHelper(FileSym fileSym, Sym sym, String string) {
        this.helper = new ImportHelper(fileSym);
        this.helper.performAutoImport(sym, string);
    }
}

