/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

public class AnnotationFilter
implements JavaConstants,
JavaFilter {
    private final SourceHasModifiers decl;
    private final byte declKind;
    private final HashSet hits;
    private final HashSet misses;

    public final boolean accepts(JavaElement javaElement) {
        if (!(javaElement instanceof JavaType)) {
            return false;
        }
        JavaType javaType = (JavaType)javaElement;
        if (javaType == null) {
            return false;
        }
        if (!javaType.isAnnotation()) {
            return false;
        }
        if (this.declKind == 0) {
            return true;
        }
        if (this.hits.contains(javaType)) {
            return true;
        }
        if (this.misses.contains(javaType)) {
            return false;
        }
        boolean bl = this.acceptsImpl(javaType);
        if (bl) {
            this.hits.add(javaType);
        } else {
            this.misses.add(javaType);
        }
        return bl;
    }

    private boolean acceptsImpl(JavaType javaType) {
        Collection collection = javaType.getDeclaredAnnotations();
        if (!collection.isEmpty()) {
            for (JavaAnnotation javaAnnotation : collection) {
                Object v;
                JavaType javaType2 = javaAnnotation.getAnnotationType();
                if (javaType2 == null || !"java/lang/annotation/Target".equals(javaType2.getVMName()) || (v = javaAnnotation.getComponents().get("value")) == null) continue;
                try {
                    String string;
                    switch (this.declKind) {
                        case 9: 
                        case 10: {
                            string = "FIELD";
                            break;
                        }
                        case 6: {
                            string = "CONSTRUCTOR";
                            break;
                        }
                        case 19: {
                            string = "METHOD";
                            break;
                        }
                        case 17: 
                        case 18: {
                            string = "LOCAL_VARIABLE";
                            break;
                        }
                        case 12: 
                        case 13: {
                            string = "PARAMETER";
                            break;
                        }
                        case 22: {
                            string = "PACKAGE";
                            break;
                        }
                        default: {
                            string = null;
                        }
                    }
                    Object[] objectArray = (Object[])v;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JavaField javaField = (JavaField)objectArray[n2];
                        String string2 = javaField.getName();
                        if (string != null) {
                            if (string.equals(string2)) {
                                boolean bl = true;
                                return bl;
                            }
                        } else if (this.declKind == 3) {
                            SourceClass sourceClass;
                            if ("TYPE".equals(string2)) {
                                boolean bl = true;
                                return bl;
                            }
                            if ("ANNOTATION_TYPE".equals(string2) && this.decl != null && (sourceClass = (SourceClass)this.decl).isAnnotation()) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        ++n2;
                    }
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    void $init$() {
        this.hits = new HashSet(10);
        this.misses = new HashSet();
    }

    public AnnotationFilter() {
        this.$init$();
        this.decl = null;
        this.declKind = 0;
    }

    public AnnotationFilter(SourceHasModifiers sourceHasModifiers) {
        this.$init$();
        this.decl = sourceHasModifiers;
        this.declKind = (byte)sourceHasModifiers.getSymbolKind();
    }

    public AnnotationFilter(int n) {
        this.$init$();
        this.decl = null;
        this.declKind = (byte)n;
    }
}

