/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import java.util.HashSet;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

public class AssignableFilter
implements JavaFilter {
    public static final int REQUIRE_none = 0;
    public static final int REQUIRE_INSTANCE = 1;
    public static final int REQUIRE_TYPE = 2;
    public static final int REQUIRE_EXACT_TYPE = 3;
    private final JavaType target;
    private final int require;
    private final HashSet hits;
    private final HashSet misses;

    public final boolean accepts(JavaElement javaElement) {
        JavaHasType javaHasType;
        JavaType javaType;
        if (!(javaElement instanceof JavaHasType)) {
            return false;
        }
        if (this.require > 0) {
            boolean bl;
            boolean bl2 = javaElement instanceof JavaType;
            switch (this.require) {
                case 1: {
                    bl = false;
                    break;
                }
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    CommonUtilities.panic("Invalid require: " + this.require);
                    bl = false;
                }
            }
            if (bl2 != bl) {
                return false;
            }
        }
        if ((javaType = (javaHasType = (JavaHasType)javaElement).getResolvedType()) == null) {
            return false;
        }
        if (this.hits.contains(javaType)) {
            return true;
        }
        if (this.misses.contains(javaType)) {
            return false;
        }
        boolean bl = this.acceptsImpl(javaType);
        if (bl) {
            this.hits.add(javaType);
        } else {
            this.misses.add(javaType);
        }
        return bl;
    }

    private boolean acceptsImpl(JavaType javaType) {
        if (this.require == 3) {
            return this.target.equals(javaType);
        }
        return this.target.isAssignableFrom(javaType);
    }

    void $init$() {
        this.hits = new HashSet(10);
        this.misses = new HashSet();
    }

    public AssignableFilter(JavaType javaType) {
        this(javaType, 0);
    }

    public AssignableFilter(JavaType javaType, int n) {
        this.$init$();
        this.target = javaType;
        this.require = n;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

