/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;

public class DeprecatedFilter {
    public static final DeprecatedFilter SINGLETON = new DeprecatedFilter();
    public static final int REJECT_DEPRECATED = 0;
    public static final int REJECT_HIDDEN = 1;
    public static final int REJECT_BOTH = 2;
    private final int reject;

    public final boolean accepts(JavaElement javaElement) {
        switch (this.reject) {
            case 0: {
                return javaElement.isDeprecated() ^ true;
            }
            case 1: {
                return javaElement.isHidden() ^ true;
            }
            case 2: {
                return !javaElement.isDeprecated() && !javaElement.isHidden();
            }
        }
        CommonUtilities.panic("Invalid reject " + this.reject);
        return false;
    }

    public DeprecatedFilter() {
        this(0);
    }

    public DeprecatedFilter(int n) {
        this.reject = n;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public DeprecatedFilter(boolean bl, boolean bl2) {
        if (bl2) {
            this.reject = bl ? 2 : 1;
        } else {
            this.reject = 0;
            if (!bl) {
                throw new IllegalArgumentException();
            }
        }
    }
}

