/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.write;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

final class MemberComparator
implements JavaPreferences.MemberOrder,
JavaConstants,
Comparator {
    private final byte[] values;

    MemberComparator() {
        this.values = JavaPreferences.MemberOrder.MEMBER_default;
    }

    MemberComparator(SourcePreferences sourcePreferences) {
        HashStructure hashStructure = sourcePreferences.getMemberOrderHashStructure();
        if (hashStructure != null) {
            int n = 11;
            this.values = new byte[11];
            Arrays.fill(this.values, (byte)-1);
            int n2 = 0;
            while (n2 < 11) {
                String string = JavaPreferences.MemberOrder.MEMBER_keys[n2];
                if (hashStructure.containsKey(string)) {
                    this.values[n2] = (byte)hashStructure.getInt(string);
                }
                if (this.values[n2] < 0) {
                    this.values[n2] = JavaPreferences.MemberOrder.MEMBER_default[n2];
                }
                ++n2;
            }
        } else {
            this.values = JavaPreferences.MemberOrder.MEMBER_default;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof MemberComparator) {
            return this.equals((MemberComparator)object);
        }
        return false;
    }

    public boolean equals(MemberComparator memberComparator) {
        if (this == memberComparator) {
            return true;
        }
        return Arrays.equals(this.values, memberComparator.values);
    }

    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        Sym sym = (Sym)object;
        Sym sym2 = (Sym)object2;
        int n = this.classify(sym);
        int n2 = this.classify(sym2);
        return n - n2;
    }

    private int classify(Sym sym) {
        int n;
        switch (sym.symKind) {
            case 7: {
                return Integer.MIN_VALUE;
            }
            case 9: {
                int n2 = sym.getModifiers();
                boolean bl = Modifier.isStatic(n2);
                if (Modifier.isPublic(n2)) {
                    if (bl) {
                        n = 0;
                        break;
                    }
                    n = 4;
                    break;
                }
                if (Modifier.isProtected(n2)) {
                    if (bl) {
                        n = 1;
                        break;
                    }
                    n = 5;
                    break;
                }
                if (Modifier.isPrivate(n2)) {
                    if (bl) {
                        n = 3;
                        break;
                    }
                    n = 7;
                    break;
                }
                if (bl) {
                    n = 2;
                    break;
                }
                n = 6;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 19: {
                n = 9;
                break;
            }
            case 3: {
                n = 10;
                break;
            }
            default: {
                return Integer.MAX_VALUE;
            }
        }
        return this.values[n];
    }
}

