/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.write;

import java.util.Comparator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.parser.java.v2.JavaPreferences;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.write.SourceComparator;

public final class SourcePreferences
implements JavaPreferences {
    private final HashStructure hash;

    public static SourcePreferences copy(SourcePreferences sourcePreferences) {
        HashStructure hashStructure = sourcePreferences.hash;
        HashStructure hashStructure2 = hashStructure.copyTo(null);
        return new SourcePreferences(hashStructure2);
    }

    public static SourcePreferences createCascadingPreferences(SourcePreferences sourcePreferences) {
        HashStructure hashStructure = sourcePreferences.hash;
        HashStructure hashStructure2 = HashStructure.newInstance();
        HashStructure[] hashStructureArray = new HashStructure[]{hashStructure2, hashStructure};
        HashStructure hashStructure3 = HashStructure.newChainForOverriding(hashStructureArray);
        return new SourcePreferences(hashStructure3);
    }

    public SourcePreferences() {
        this.hash = HashStructure.newInstance();
    }

    public SourcePreferences(HashStructure hashStructure) {
        this.hash = hashStructure;
    }

    public boolean getBoolean(int n) {
        String string = SourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getBoolean(string);
        }
        Boolean bl = (Boolean)JavaPreferences.PREFERENCES_defaults[n - 0];
        return bl;
    }

    public void setBoolean(int n, boolean bl) {
        String string = SourcePreferences.setting2key(n);
        Boolean bl2 = (Boolean)JavaPreferences.PREFERENCES_defaults[n - 0];
        this.hash.putBoolean(string, bl);
    }

    public String getString(int n) {
        String string = SourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getString(string);
        }
        String string2 = (String)JavaPreferences.PREFERENCES_defaults[n - 0];
        return string2;
    }

    public void setString(int n, String string) {
        String string2 = SourcePreferences.setting2key(n);
        String string3 = (String)JavaPreferences.PREFERENCES_defaults[n - 0];
        this.hash.putString(string2, string);
    }

    public int getInt(int n) {
        String string = SourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getInt(string);
        }
        Integer n2 = (Integer)JavaPreferences.PREFERENCES_defaults[n - 0];
        return n2;
    }

    public void setInt(int n, int n2) {
        String string = SourcePreferences.setting2key(n);
        Integer n3 = (Integer)JavaPreferences.PREFERENCES_defaults[n - 0];
        this.hash.putInt(string, n2);
    }

    private HashStructure getHashStructure(int n) {
        String string = SourcePreferences.setting2key(n);
        if (this.hash.containsKey(string)) {
            return this.hash.getHashStructure(string);
        }
        return null;
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.getHashStructure(67);
    }

    public Comparator getMemberComparator() {
        return SourceComparator.memberComparator(this);
    }

    public byte getMemberOrder(int n) {
        String string = SourcePreferences.setting2key(67);
        HashStructure hashStructure = this.hash.getHashStructure(string);
        byte by = JavaPreferences.MemberOrder.MEMBER_default[n];
        if (hashStructure == null) {
            return by;
        }
        String string2 = SourcePreferences.member2key(n);
        byte by2 = -1;
        if (hashStructure.containsKey(string2)) {
            by2 = (byte)hashStructure.getInt(string2);
        }
        if (by2 >= 0) {
            return by2;
        }
        return by;
    }

    public void setMemberOrder(int n, byte by) {
        String string = SourcePreferences.setting2key(67);
        HashStructure hashStructure = this.hash.getOrCreateHashStructure(string);
        String string2 = SourcePreferences.member2key(n);
        hashStructure.putInt(string2, by);
    }

    public void reloadAll(Object[] objectArray) {
        int n = 68;
        int n2 = 0;
        while (n2 < 68) {
            int n3 = n2;
            Object object = objectArray[n2];
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                boolean bl2 = bl;
                this.setBoolean(n3, bl2);
            } else if (object instanceof Integer) {
                Integer n4 = (Integer)object;
                int n5 = n4;
                this.setInt(n3, n5);
            }
            ++n2;
        }
    }

    private static String setting2key(int n) {
        if (0 <= n && n < 68) {
            return JavaPreferences.PREFERENCES_keys[n - 0];
        }
        CommonUtilities.panic("Invalid setting: " + n);
        return "";
    }

    private static String member2key(int n) {
        if (0 <= n && n < 11) {
            return JavaPreferences.MemberOrder.MEMBER_keys[n];
        }
        CommonUtilities.panic("Invalid member: " + n);
        return "";
    }
}

