/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.syntax.PlsqlDriver;
import oracle.javatools.parser.plsql.syntax.PlsqlLexer;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.parser.plsql.syntax.SqlLexer;

public class PlsqlParser {
    public static final int INPUT_PLS_SRC = 0;
    protected static final int INPUT_SQL_QCPI = 16;
    public static final int INPUT_SQL_BEX = 17;
    public static final int INPUT_default = 0;

    public static Lexer createPlsqlLexer() {
        return new PlsqlLexer();
    }

    public static Lexer createSqlLexer() {
        return new SqlLexer();
    }

    public static PlsqlRoot parsePlsql(ReadTextBuffer readTextBuffer) {
        ParsingOptions parsingOptions = new ParsingOptions();
        parsingOptions.inputType = 0;
        return PlsqlParser.parse(readTextBuffer, parsingOptions);
    }

    public static PlsqlRoot parseSql(ReadTextBuffer readTextBuffer) {
        ParsingOptions parsingOptions = new ParsingOptions();
        parsingOptions.inputType = 16;
        return PlsqlParser.parseSql(readTextBuffer, null);
    }

    public static PlsqlRoot parse(ReadTextBuffer readTextBuffer, ParsingOptions parsingOptions) {
        if (parsingOptions == null) {
            parsingOptions = new ParsingOptions();
        }
        try {
            if (parsingOptions.inputType == 0) {
                PlsqlDriver plsqlDriver = new PlsqlDriver();
                plsqlDriver.setTextBuffer(readTextBuffer);
                PlsqlRoot plsqlRoot = plsqlDriver.ph1drv();
                return plsqlRoot;
            }
            if (parsingOptions.inputType == 16) {
                SqlDriver sqlDriver = new SqlDriver();
                sqlDriver.setTextBuffer(readTextBuffer);
                PlsqlRoot plsqlRoot = sqlDriver.qcpidrv();
                return plsqlRoot;
            }
            if (parsingOptions.inputType == 17) {
                SqlDriver sqlDriver = new SqlDriver();
                sqlDriver.setTextBuffer(readTextBuffer);
                PlsqlRoot plsqlRoot = sqlDriver.qcpidrv(1);
                return plsqlRoot;
            }
            PlsqlRoot plsqlRoot = null;
            return plsqlRoot;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            PlsqlRoot plsqlRoot = null;
            return plsqlRoot;
        }
    }

    private static PlsqlRoot parseSql(ReadTextBuffer readTextBuffer, ParsingOptions parsingOptions) {
        if (parsingOptions == null) {
            parsingOptions = new ParsingOptions();
        }
        try {
            SqlDriver sqlDriver = new SqlDriver();
            sqlDriver.setTextBuffer(readTextBuffer);
            PlsqlRoot plsqlRoot = sqlDriver.qcpidrv();
            return plsqlRoot;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            PlsqlRoot plsqlRoot = null;
            return plsqlRoot;
        }
    }

    public static class ParsingOptions {
        public int inputType;
        public int startOffset;

        void $init$() {
            this.inputType = 0;
            this.startOffset = 0;
        }

        public ParsingOptions() {
            this.$init$();
        }
    }
}

