/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.PlsqlTreeGenerator;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;

public class PlsqlParser {
    public static final boolean ERRORS_CHOKE = false;
    public static final boolean ERRORS_REPORT = true;
    public static final int INPUT_PLSQL_FILE = 1;
    public static final int INPUT_EXPR = 2;
    public static final int DEPTH_DECLARATIONS = 1;
    public static final int DEPTH_FULL = 2;

    public static RootSymbol parse(ReadTextBuffer readTextBuffer) {
        ParsingOptions parsingOptions = new ParsingOptions();
        return (RootSymbol)PlsqlParser.parse(readTextBuffer, parsingOptions);
    }

    public static ErrorReporter parse(ReadTextBuffer readTextBuffer, ParsingOptions parsingOptions) {
        PlsqlTreeGenerator plsqlTreeGenerator = new PlsqlTreeGenerator();
        PlsqlSyntaxRecognizer plsqlSyntaxRecognizer = PlsqlSyntaxRecognizer.newRecognizer(parsingOptions.inputType, parsingOptions.parseDepth);
        plsqlSyntaxRecognizer.initialize(readTextBuffer, parsingOptions.startOffset);
        plsqlSyntaxRecognizer.setDebugLevel(parsingOptions.reportErrors ? 1 : 0);
        plsqlTreeGenerator.initialize(plsqlSyntaxRecognizer);
        try {
            CommonRoot commonRoot = plsqlTreeGenerator.generate();
            if (commonRoot != null) {
                ErrorReporter errorReporter = commonRoot.getRealRoot();
                return errorReporter;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static class ParsingOptions {
        public boolean reportErrors;
        public int inputType;
        public int parseDepth;
        public int startOffset;

        void $init$() {
            this.reportErrors = false;
            this.inputType = 1;
            this.parseDepth = 2;
            this.startOffset = 0;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ERRORS ");
            if (!this.reportErrors) {
                stringBuffer.append("choke ");
            } else {
                stringBuffer.append("report ");
            }
            stringBuffer.append("INPUT-TYPE ");
            switch (this.inputType) {
                case 1: {
                    stringBuffer.append("plsql file ");
                    break;
                }
                case 2: {
                    stringBuffer.append("expression ");
                    break;
                }
                default: {
                    stringBuffer.append("unknown ");
                }
            }
            stringBuffer.append("DEPTH ");
            switch (this.parseDepth) {
                case 1: {
                    stringBuffer.append("decls ");
                    break;
                }
                case 2: {
                    stringBuffer.append("full ");
                }
            }
            stringBuffer.append("START-OFFSET ");
            stringBuffer.append(this.startOffset);
            return stringBuffer.toString();
        }

        public ParsingOptions() {
            this.$init$();
        }
    }
}

