/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.SyntaxListener;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxCodes;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;

public class PlsqlTreeGenerator
implements SyntaxListener,
PlsqlSyntaxCodes {
    private static final int FORCE_FINISH_THRESHOLD = 25;
    private static final boolean kDebugging = false;
    private ReadTextBuffer textBuffer;
    private PlsqlSyntaxRecognizer recognizer;
    private PlsqlSymbolFactory factory;
    private PlsqlSymbol currentParent;
    private CommonRoot currentRoot;
    private int lastOffset;

    void $init$() {
        this.factory = new PlsqlSymbolFactory();
        this.currentParent = null;
        this.currentRoot = null;
        this.lastOffset = 0;
    }

    public PlsqlTreeGenerator() {
        this.$init$();
    }

    public void initialize(PlsqlSyntaxRecognizer plsqlSyntaxRecognizer) {
        this.recognizer = plsqlSyntaxRecognizer;
        this.recognizer.setListener(this);
        this.textBuffer = this.recognizer.getLexer().getTextBuffer();
    }

    public PlsqlSyntaxRecognizer getRecognizer() {
        return this.recognizer;
    }

    private void forceFinish() {
        int n = 0;
        while (this.currentParent != null) {
            PlsqlSymbol plsqlSymbol = this.currentParent.getParent();
            if (!this.factory.forceFinishSymbol(this.currentParent, this.lastOffset, this.textBuffer) && 25 < n++ && this.currentParent != this.currentRoot) {
                this.factory.forceFinishSymbol(this.currentRoot, this.lastOffset, this.textBuffer);
                return;
            }
            this.currentParent = plsqlSymbol;
        }
    }

    public CommonRoot generate() {
        block3: {
            this.currentRoot = (CommonRoot)this.factory.createSymbol(10, -1, -1, null);
            this.currentParent = this.currentRoot;
            try {
                this.recognizer.parse();
            }
            catch (RuntimeException runtimeException) {
                if (this.recognizer.getDebugLevel() != 0) break block3;
                CommonRoot commonRoot = null;
                return commonRoot;
            }
        }
        if (this.currentParent != null) {
            this.forceFinish();
        }
        return this.currentRoot;
    }

    private void debug(SyntaxToken syntaxToken) {
        int n = syntaxToken.getCode();
        int n2 = syntaxToken.getStartOffset();
        int n3 = syntaxToken.getEndOffset();
        String string = this.recognizer._codeToString(n);
        if (n == 1) {
            System.out.println("Error message: " + syntaxToken.getContextString());
        }
        if (n3 == -1) {
            System.out.println("begin> " + string + ". Start = " + n2);
        } else {
            System.out.println("  " + string + ". (  Start, End  ) = (  " + n2 + ", " + n3 + "  )");
            String string2 = "";
            string2 = n3 != -1 && n2 != -1 ? new String(this.textBuffer.getChars(n2, n3 - n2)) : "empty>";
            System.out.println("\t\"" + string2 + "\"");
            System.out.println("");
        }
    }

    public void receive(SyntaxToken syntaxToken, int n) {
        boolean bl;
        if (n == 1) {
            this.factory.createAndFinishErrorSymbol(syntaxToken, this.currentRoot);
            return;
        }
        boolean bl2 = bl = syntaxToken.getEndOffset() == -1;
        if (bl) {
            this.currentParent = this.factory.createSymbol(syntaxToken, this.currentParent);
        } else if (this.currentParent.getCode() == n) {
            this.lastOffset = syntaxToken.getEndOffset();
            PlsqlSymbol plsqlSymbol = this.currentParent.getParent();
            this.factory.finishSymbol(this.currentParent, syntaxToken, this.textBuffer);
            this.currentParent = plsqlSymbol;
        } else if (n != 0) {
            PlsqlSymbol plsqlSymbol = this.factory.createSymbol(syntaxToken, this.currentParent);
            this.factory.finishSymbol(plsqlSymbol, syntaxToken, this.textBuffer);
        } else {
            throw new RuntimeException("EOF!!!");
        }
    }
}

