/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import oracle.javatools.parser.plsql.old.PlsqlLexer;
import oracle.javatools.parser.plsql.old.symbol.ExpressionWrapper;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.Nameable;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;
import oracle.javatools.parser.plsql.old.symbol.Statement;

public class ExpressionSymbol
extends PlsqlSymbol
implements Nameable {
    static final ExpressionSymbol[] EMPTY_ARRAY = new ExpressionSymbol[0];
    static final int verboseValue = 0;
    static final int VERBOSE_RECYCLING = 16;
    static final int VERBOSE_LIST = 4;
    static final int VERBOSE_WRAPPER = 2;
    static final int VERBOSE_BASE = 1;
    public static final int CATEGORY_WRAPPER = 600;
    public static final int CATEGORY_UNKNOWN = -1;
    public static final int CATEGORY_PAREN_WRAPPER = 610;
    public static final int CATEGORY_SQL = 630;
    public static final int CATEGORY_PREFIX_OPERATOR = 711;
    public static final int CATEGORY_POSTFIX_OPERATOR = 714;
    public static final int CATEGORY_INFIX_OPERATOR = 712;
    public static final int CATEGORY_SPECIAL_OPERATOR = 713;
    public static final int CATEGORY_PRIMARY = 750;
    public static final int CATEGORY_ARGUMENTS = 760;
    protected ExpressionSymbol firstOperand;
    protected ExpressionSymbol secondOperand;
    protected ExpressionSymbol thirdOperand;
    private NameSymbol name;
    private PlsqlSymbolFactory factory;

    static boolean verboseOutput(int n) {
        return (0 & n) == n;
    }

    public int getCategory() {
        return this.code;
    }

    public int getExactCode() {
        return this.dataValue;
    }

    public ExpressionSymbol getFirstOperand() {
        return this.firstOperand;
    }

    public ExpressionSymbol getSecondOperand() {
        return this.secondOperand;
    }

    public ExpressionSymbol getThirdOperand() {
        return this.thirdOperand;
    }

    void $init$() {
        this.firstOperand = null;
        this.secondOperand = null;
        this.thirdOperand = null;
        this.name = null;
    }

    ExpressionSymbol(int n, PlsqlSymbolFactory plsqlSymbolFactory) {
        super(n);
        this.$init$();
        this.factory = plsqlSymbolFactory;
    }

    void addOperand(ExpressionSymbol expressionSymbol) {
        if (expressionSymbol.getCategory() == 600) {
            ExpressionSymbol expressionSymbol2 = expressionSymbol;
            expressionSymbol = expressionSymbol.getFirstOperand();
            this.recycleExpression(expressionSymbol2);
        }
        ExpressionSymbol.verbosePrintln("ESymbol: Adding operand, child: ", expressionSymbol);
        ExpressionSymbol.verbosePrintln("ESymbol:  Parent: ", this);
        if (this.firstOperand == null) {
            this.firstOperand = expressionSymbol;
        } else if (this.secondOperand == null) {
            this.secondOperand = expressionSymbol;
        } else if (this.thirdOperand == null) {
            this.thirdOperand = expressionSymbol;
        } else {
            System.out.println("Too many child expressions");
        }
        expressionSymbol.parent = this;
    }

    void recycleExpression(ExpressionSymbol expressionSymbol) {
        ExpressionWrapper expressionWrapper = (ExpressionWrapper)expressionSymbol;
        if (ExpressionSymbol.verboseOutput(16)) {
            System.out.println("Recycling expression");
            this.factory.reclaimWrapper(expressionWrapper);
        }
    }

    void doneParsing() {
        if (this.parent instanceof ExpressionSymbol) {
            ((ExpressionSymbol)this.parent).addOperand(this);
        } else if (this.parent instanceof Statement) {
            ((Statement)this.parent).setExpression(this);
        }
    }

    void adjustOffsets() {
        switch (this.getExactCode()) {
            case -1011: 
            case 1011: {
                ExpressionSymbol expressionSymbol = this.firstOperand;
                ExpressionSymbol expressionSymbol2 = this.secondOperand;
                ExpressionSymbol expressionSymbol3 = this.thirdOperand;
                this.firstOperand = null;
                this.secondOperand = null;
                this.thirdOperand = null;
                this.addOperand(expressionSymbol3);
                this.addOperand(expressionSymbol);
                this.addOperand(expressionSymbol2);
                break;
            }
        }
    }

    public NameSymbol getName() {
        return this.name;
    }

    public void setName(NameSymbol nameSymbol) {
        this.name = nameSymbol;
    }

    String verbose() {
        int n = this.getExactCode();
        String string = n == 0 ? "<wrapper>" : PlsqlLexer.tokenToText(n);
        return this.code + "-" + string;
    }

    static void verbosePrintln(String string, ExpressionSymbol expressionSymbol) {
        if (ExpressionSymbol.verboseOutput(1)) {
            System.out.print(string);
            System.out.println(expressionSymbol.verbose());
        }
    }
}

