/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.javatools.parser.util.ArrayListHeap;
import oracle.javatools.parser.util.SimpleStack;

public class ExpressionWrapper
extends ExpressionSymbol
implements ErrorReporter {
    ExpressionStack estack;
    private ErrorSymbol[] errorArray;

    void $init$() {
        this.estack = new ExpressionStack(null);
        this.errorArray = null;
    }

    ExpressionWrapper(int n, PlsqlSymbolFactory plsqlSymbolFactory) {
        super(n, plsqlSymbolFactory);
        this.$init$();
    }

    void refurbish(int n) {
        if (ExpressionWrapper.verboseOutput(16)) {
            System.out.println("Refurbishing...");
        }
        this.code = n;
        this.firstOperand = null;
        this.secondOperand = null;
        this.thirdOperand = null;
        this.setName(null);
        ExpressionStack.mav$refurbish(this.estack);
    }

    void addOperand(ExpressionSymbol expressionSymbol) {
        ExpressionStack.mav$add(this.estack, expressionSymbol);
    }

    void doneParsing() {
        ExpressionStack.mav$process(this.estack);
        this.firstOperand = ExpressionStack.mav$generate(this.estack);
        if (this.parent instanceof ExpressionSymbol) {
            ((ExpressionSymbol)this.parent).addOperand(this);
        } else if (this.parent instanceof Statement) {
            ((Statement)this.parent).setExpression(this.firstOperand);
            this.recycleExpression(this);
        } else if (this.parent.code == 10) {
            ((CommonRoot)this.parent).setRoot(this);
        }
    }

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public void setErrors(CommonRoot commonRoot) {
        this.errorArray = commonRoot.getErrors();
    }

    static void verbosePrintln(String string, ExpressionSymbol expressionSymbol) {
        if (ExpressionWrapper.verboseOutput(2)) {
            System.out.print(string);
            System.out.println(expressionSymbol.verbose());
        }
    }

    static void maS$freeArrayList(ArrayList arrayList) {
        ArrayListHeap.freeArrayList(arrayList);
    }

    static ArrayList maS$allocArrayList() {
        return ArrayListHeap.allocArrayList();
    }

    private static class ExpressionStack {
        private ArrayList expressions;
        private SimpleStack stack;
        private int pos;

        void $init$() {
            this.expressions = ExpressionWrapper.maS$allocArrayList();
            this.stack = new SimpleStack();
        }

        private void refurbish() {
            if (this.expressions != null) {
                throw new RuntimeException("Non-null array list!");
            }
            this.expressions = ExpressionWrapper.maS$allocArrayList();
            this.stack.clear();
        }

        private void add(ExpressionSymbol expressionSymbol) {
            this.expressions.add(expressionSymbol);
        }

        private void process() {
            if (this.expressions.size() == 1) {
                this.stack.push(this.expressions.get(0));
            } else {
                this.pos = 0;
                while (this.pos < this.expressions.size()) {
                    this.processOperand(1000);
                }
            }
            ExpressionWrapper.maS$freeArrayList(this.expressions);
            this.expressions = null;
        }

        private ExpressionSymbol generate() {
            return (ExpressionSymbol)this.stack.pop();
        }

        private ExpressionSymbol current() {
            return (ExpressionSymbol)this.expressions.get(this.pos);
        }

        private void advance() {
            ++this.pos;
        }

        private boolean eof() {
            return this.expressions.size() <= this.pos;
        }

        private boolean isSuffixOperator(ExpressionSymbol expressionSymbol) {
            int n = expressionSymbol.getCategory();
            switch (n) {
                default: {
                    break;
                }
                case 714: {
                    return true;
                }
                case 713: {
                    switch (expressionSymbol.getExactCode()) {
                        case -1074: 
                        case -1011: 
                        case 1011: 
                        case 1074: {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private void pushOperand(ExpressionSymbol expressionSymbol) {
            ExpressionWrapper.verbosePrintln("Pushing operand: ", expressionSymbol);
            this.stack.push(expressionSymbol);
        }

        private ExpressionSymbol popOperand() {
            ExpressionSymbol expressionSymbol = (ExpressionSymbol)this.stack.pop();
            ExpressionWrapper.verbosePrintln("Popping operand: ", expressionSymbol);
            return expressionSymbol;
        }

        private void processOperator(ExpressionSymbol expressionSymbol) {
            if (this.isSuffixOperator(expressionSymbol)) {
                this.advance();
                ExpressionWrapper.verbosePrintln("Processing suffix operator: ", expressionSymbol);
                expressionSymbol.addOperand(this.popOperand());
                expressionSymbol.adjustOffsets();
                this.pushOperand(expressionSymbol);
            } else {
                this.advance();
                this.processOperand(ExpressionStack.getPrecedence(expressionSymbol));
                if (expressionSymbol.getCategory() == 711) {
                    ExpressionWrapper.verbosePrintln("Processing prefix operator: ", expressionSymbol);
                    expressionSymbol.addOperand(this.popOperand());
                } else {
                    ExpressionWrapper.verbosePrintln("Processing infix operator: ", expressionSymbol);
                    ExpressionSymbol expressionSymbol2 = this.popOperand();
                    expressionSymbol.addOperand(this.popOperand());
                    expressionSymbol.addOperand(expressionSymbol2);
                }
                expressionSymbol.adjustOffsets();
                this.pushOperand(expressionSymbol);
            }
        }

        private void processOperand(int n) {
            ExpressionSymbol expressionSymbol = this.current();
            block0 : switch (expressionSymbol.getCategory()) {
                case 711: 
                case 712: 
                case 713: {
                    this.processOperator(expressionSymbol);
                    break;
                }
                case 610: 
                case 750: 
                case 760: {
                    this.pushOperand(expressionSymbol);
                    this.advance();
                    while (!this.eof()) {
                        ExpressionSymbol expressionSymbol2 = this.current();
                        if (expressionSymbol2.getCategory() == 750 || ExpressionStack.getPrecedence(expressionSymbol2) >= n) break block0;
                        this.processOperator(expressionSymbol2);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("processOperand: bad category" + expressionSymbol.getCategory());
                }
            }
        }

        public static int getPrecedence(ExpressionSymbol expressionSymbol) {
            boolean bl = expressionSymbol.getCategory() == 711;
            int n = expressionSymbol.getExactCode();
            if (n < 0) {
                n = -n;
            }
            switch (n) {
                case 115: {
                    return 1;
                }
                case 125: 
                case 1096: {
                    return 2;
                }
                case 100: 
                case 111: {
                    return bl ? 3 : 5;
                }
                case 103: 
                case 108: {
                    return 4;
                }
                case 114: {
                    return 5;
                }
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 1011: 
                case 1065: 
                case 1074: 
                case 1078: {
                    return 6;
                }
                case 1002: {
                    return 7;
                }
                case 1108: {
                    return 8;
                }
                case 112: 
                case 113: {
                    return 10;
                }
            }
            throw new RuntimeException("getPrecedence: Unknown operator " + n + " category " + expressionSymbol.getCategory());
        }

        private ExpressionStack() {
            this.$init$();
        }

        static void mav$process(ExpressionStack expressionStack) {
            expressionStack.process();
        }

        static ExpressionSymbol mav$generate(ExpressionStack expressionStack) {
            return expressionStack.generate();
        }

        static void mav$add(ExpressionStack expressionStack, ExpressionSymbol expressionSymbol) {
            expressionStack.add(expressionSymbol);
        }

        static void mav$refurbish(ExpressionStack expressionStack) {
            expressionStack.refurbish();
        }

        ExpressionStack(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

