/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxCodes;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.CodeBlockSymbol;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.CompoundStatement;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.plsql.old.symbol.ExpressionList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.javatools.parser.plsql.old.symbol.ExpressionWrapper;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.Nameable;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.javatools.parser.plsql.old.symbol.TypeSymbol;
import oracle.javatools.parser.plsql.old.symbol.VariableSymbol;
import oracle.javatools.parser.util.SimpleStack;

public class PlsqlSymbolFactory
implements PlsqlSyntaxCodes {
    private SimpleStack freeWrappers;

    void $init$() {
        this.freeWrappers = new SimpleStack();
    }

    private ExpressionWrapper getRefurbishedWrapper(int n) {
        int n2 = this.freeWrappers.size();
        if (n2 > 0) {
            int n3 = n2 - 1;
            ExpressionWrapper expressionWrapper = (ExpressionWrapper)this.freeWrappers.pop();
            expressionWrapper.refurbish(n);
            return expressionWrapper;
        }
        return null;
    }

    private ExpressionWrapper getNewExpressionWrapper(int n) {
        ExpressionWrapper expressionWrapper = this.getRefurbishedWrapper(n);
        if (expressionWrapper != null) {
            return expressionWrapper;
        }
        ExpressionWrapper expressionWrapper2 = new ExpressionWrapper(n, this);
        return expressionWrapper2;
    }

    void reclaimWrapper(ExpressionWrapper expressionWrapper) {
        this.freeWrappers.push(expressionWrapper);
    }

    public PlsqlSymbolFactory() {
        this.$init$();
    }

    public PlsqlSymbol createAndFinishErrorSymbol(SyntaxToken syntaxToken, CommonRoot commonRoot) {
        ErrorSymbol errorSymbol = new ErrorSymbol(syntaxToken.getContextString());
        errorSymbol.parent = commonRoot;
        errorSymbol.startOffset = syntaxToken.getStartOffset();
        errorSymbol.endOffset = syntaxToken.getEndOffset();
        errorSymbol.dataValue = syntaxToken.getDataValue();
        commonRoot.addError(errorSymbol);
        return errorSymbol;
    }

    public PlsqlSymbol createSymbol(SyntaxToken syntaxToken, PlsqlSymbol plsqlSymbol) {
        return this.createSymbol(syntaxToken.getCode(), syntaxToken.getStartOffset(), syntaxToken.getEndOffset(), plsqlSymbol);
    }

    public PlsqlSymbol createSymbol(int n, int n2, int n3, PlsqlSymbol plsqlSymbol) {
        PlsqlSymbol plsqlSymbol2;
        switch (n) {
            case 600: {
                plsqlSymbol2 = this.getNewExpressionWrapper(n);
                if (plsqlSymbol.code != 10) break;
                ((CommonRoot)plsqlSymbol).setRoot((ErrorReporter)((Object)plsqlSymbol2));
                break;
            }
            case 610: 
            case 750: 
            case 760: {
                plsqlSymbol2 = new ExpressionList(n, this);
                break;
            }
            case 630: 
            case 711: 
            case 712: 
            case 713: {
                plsqlSymbol2 = new ExpressionSymbol(n, this);
                break;
            }
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 1010: {
                plsqlSymbol2 = new TypeSymbol(n);
                break;
            }
            case 601: 
            case 631: 
            case 632: 
            case 752: 
            case 753: 
            case 1002: 
            case 1003: {
                plsqlSymbol2 = new NameSymbol(n);
                break;
            }
            case 350: {
                plsqlSymbol2 = new CodeBlockSymbol(n);
                break;
            }
            case 330: 
            case 331: 
            case 351: 
            case 352: {
                plsqlSymbol2 = new CompoundStatement(n);
                break;
            }
            case 250: 
            case 311: 
            case 312: 
            case 313: 
            case 332: {
                plsqlSymbol2 = new Statement(n);
                break;
            }
            case 110: {
                plsqlSymbol2 = new PackageSymbol(n);
                break;
            }
            case 140: 
            case 150: {
                plsqlSymbol2 = new FunctionSymbol(n);
                break;
            }
            case 200: {
                plsqlSymbol2 = new CodeBlockSymbol(n);
                break;
            }
            case 156: 
            case 510: 
            case 550: {
                plsqlSymbol2 = new VariableSymbol(n);
                break;
            }
            case 10: {
                plsqlSymbol2 = new CommonRoot();
                break;
            }
            case 25: {
                plsqlSymbol2 = new RootSymbol();
                if (plsqlSymbol.code != 10) break;
                ((CommonRoot)plsqlSymbol).setRoot((RootSymbol)plsqlSymbol2);
                break;
            }
            default: {
                plsqlSymbol2 = new PlsqlSymbol(n);
            }
        }
        plsqlSymbol2.parent = plsqlSymbol;
        plsqlSymbol2.startOffset = n2;
        plsqlSymbol2.endOffset = n3;
        return plsqlSymbol2;
    }

    public boolean forceFinishSymbol(PlsqlSymbol plsqlSymbol, int n, ReadTextBuffer readTextBuffer) {
        try {
            plsqlSymbol.endOffset = n;
            this.finishSymbol(plsqlSymbol, readTextBuffer);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public void finishSymbol(PlsqlSymbol plsqlSymbol, SyntaxToken syntaxToken, ReadTextBuffer readTextBuffer) {
        plsqlSymbol.endOffset = syntaxToken.getEndOffset();
        plsqlSymbol.dataValue = syntaxToken.getDataValue();
        this.finishSymbol(plsqlSymbol, readTextBuffer);
    }

    public void finishSymbol(PlsqlSymbol plsqlSymbol, ReadTextBuffer readTextBuffer) {
        try {
            PlsqlSymbol plsqlSymbol2 = plsqlSymbol.parent;
            switch (plsqlSymbol.code) {
                case 511: 
                case 512: 
                case 513: 
                case 514: 
                case 1010: {
                    if (plsqlSymbol2.code == 150) {
                        ((FunctionSymbol)plsqlSymbol2).setReturnType((TypeSymbol)plsqlSymbol);
                    } else if (plsqlSymbol2 instanceof VariableSymbol) {
                        ((VariableSymbol)plsqlSymbol2).useType((TypeSymbol)plsqlSymbol);
                        ((TypeSymbol)plsqlSymbol).recordName(readTextBuffer);
                    }
                    ((TypeSymbol)plsqlSymbol).recordName(readTextBuffer);
                    break;
                }
                case 601: 
                case 631: 
                case 632: 
                case 752: 
                case 753: 
                case 1002: 
                case 1003: {
                    if (plsqlSymbol2 instanceof Nameable) {
                        ((Nameable)((Object)plsqlSymbol2)).setName((NameSymbol)plsqlSymbol);
                    } else if (plsqlSymbol2.code == 352) {
                        ((CompoundStatement)plsqlSymbol2).setVariableName((NameSymbol)plsqlSymbol);
                    }
                    ((NameSymbol)plsqlSymbol).recordName(readTextBuffer);
                    break;
                }
                case 550: {
                    ((CodeBlockSymbol)plsqlSymbol2).addVariable((VariableSymbol)plsqlSymbol);
                    break;
                }
                case 510: {
                    ((CodeBlockSymbol)plsqlSymbol2).addType((VariableSymbol)plsqlSymbol);
                    break;
                }
                case 156: {
                    if (!(plsqlSymbol2.parent instanceof FunctionSymbol)) break;
                    ((FunctionSymbol)plsqlSymbol2.parent).addParameter((VariableSymbol)plsqlSymbol);
                    break;
                }
                case 200: {
                    if (plsqlSymbol2.code == 25 || !(plsqlSymbol2 instanceof Statement)) break;
                    ((Statement)plsqlSymbol2).setBlock((CodeBlockSymbol)plsqlSymbol);
                    break;
                }
                case 350: {
                    if (!(plsqlSymbol2 instanceof Statement)) break;
                    ((Statement)plsqlSymbol2).setBlock((CodeBlockSymbol)plsqlSymbol);
                    break;
                }
                case 311: 
                case 312: 
                case 313: 
                case 330: 
                case 351: 
                case 352: {
                    PlsqlSymbol plsqlSymbol3 = plsqlSymbol2;
                    while (plsqlSymbol3 != null && !(plsqlSymbol3 instanceof CodeBlockSymbol)) {
                        plsqlSymbol3 = plsqlSymbol3.parent;
                    }
                    if (plsqlSymbol3 == null) break;
                    ((CodeBlockSymbol)plsqlSymbol3).addStatement((Statement)plsqlSymbol);
                    break;
                }
                case 331: 
                case 332: {
                    ((CompoundStatement)plsqlSymbol2).addElseClause((Statement)plsqlSymbol);
                    break;
                }
            }
            plsqlSymbol.doneParsing();
        }
        catch (ClassCastException classCastException) {
            try {
                plsqlSymbol.parent.internalError("I'm the parent");
            }
            catch (Exception exception) {
                // empty catch block
            }
            plsqlSymbol.internalError("Class cast exception during finishSymbol");
        }
        catch (NullPointerException nullPointerException) {
            plsqlSymbol.reportSyntaxError(PlsqlSyntaxRecognizer.SYNTAXERR_SKIPPING);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

