/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;

public class RootSymbol
extends PlsqlSymbol
implements ErrorReporter {
    private PackageSymbol[] packageArray;
    private FunctionSymbol[] functionArray;
    private ErrorSymbol[] errorArray;
    private ArrayList functions;
    private ArrayList packages;

    public FunctionSymbol[] getFunctions() {
        return this.functionArray;
    }

    public PackageSymbol[] getPackages() {
        return this.packageArray;
    }

    void $init$() {
        this.packageArray = null;
        this.functionArray = null;
        this.errorArray = null;
        this.functions = RootSymbol.allocArrayList();
        this.packages = RootSymbol.allocArrayList();
    }

    RootSymbol() {
        super(25);
        this.$init$();
    }

    private void generateFunctionArray() {
        this.functionArray = FunctionSymbol.EMPTY_ARRAY;
        this.functionArray = this.functions.toArray(this.functionArray);
        RootSymbol.freeArrayList(this.functions);
        this.functions = null;
    }

    private void generatePackageArray() {
        this.packageArray = PackageSymbol.EMPTY_ARRAY;
        this.packageArray = this.packages.toArray(this.packageArray);
        RootSymbol.freeArrayList(this.packages);
        this.packages = null;
    }

    void addFunction(FunctionSymbol functionSymbol) {
        this.functions.add(functionSymbol);
    }

    void addPackage(PackageSymbol packageSymbol) {
        this.packages.add(packageSymbol);
    }

    void doneParsing() {
        super.doneParsing();
        this.generateFunctionArray();
        this.generatePackageArray();
        if (this.parent.code == 10) {
            ((CommonRoot)this.parent).setRoot(this);
        }
    }

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public void setErrors(CommonRoot commonRoot) {
        this.errorArray = commonRoot.getErrors();
    }
}

