/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.syntax;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.resource.BundleHelper;
import oracle.javatools.parser.plsql.data.PtnodConstants;
import oracle.javatools.parser.plsql.symtab.PtnodError;
import oracle.javatools.parser.plsql.symtab.PtnodRoot;
import oracle.javatools.parser.plsql.syntax.AST;
import oracle.javatools.parser.plsql.syntax.BaseSqlLexer;
import oracle.javatools.parser.plsql.syntax.ParserException;
import oracle.javatools.parser.plsql.syntax.PlsqlErrorCodes;

abstract class BaseSqlLayer
implements PtnodConstants,
PlsqlErrorCodes {
    protected int curToken;
    protected int lastEndOffset;
    protected int handlerDepth;
    protected BaseSqlLexer lexer;
    protected ReadTextBuffer textBuffer;
    protected AST stackTop;
    protected AST[] stack;
    protected int stackHeight;
    protected PtnodRoot root;
    protected int lastCheckpoint;
    protected int errorCount;
    protected int lastErrorOffset;
    protected static final BundleHelper resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");

    protected void ips() {
        this.skipToken();
        this.lastEndOffset = 0;
        this.handlerDepth = 0;
        this.stackTop = null;
        this.stack = new AST[4];
        this.lastCheckpoint = -1;
        this.stackHeight = 0;
        this.errorCount = 0;
        this.lastErrorOffset = -1;
        this.node(1);
        this.root = (PtnodRoot)this.stackTop;
    }

    protected Context save_context() {
        Context context = new Context();
        this.lexer.save_context(context);
        context.stackHeight = (short)this.stackHeight;
        context.lastEndOffset = this.lastEndOffset;
        context.lastErrorOffset = this.lastErrorOffset;
        context.handlerDepth = this.handlerDepth;
        context.shushDepth = this.stackTop.shushDepth;
        context.skipDepth = this.stackTop.skipDepth;
        return context;
    }

    protected void restore_context(Context context) {
        this.lexer.restore_context(context);
        this.curToken = this.lexer.lastToken;
        this.lastEndOffset = context.lastEndOffset;
        this.lastErrorOffset = context.lastErrorOffset;
        this.handlerDepth = context.handlerDepth;
        short s = context.stackHeight;
        int n = this.stackHeight;
        while (n > s) {
            this.stack[n - 1] = null;
            --n;
        }
        this.stackHeight = s;
        this.stackTop = this.stack[this.stackHeight - 1];
        this.stackTop.shushDepth = context.shushDepth;
        this.stackTop.skipDepth = context.skipDepth;
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        this.lexer.setTextBuffer(readTextBuffer);
        this.textBuffer = readTextBuffer;
    }

    protected final void nextToken(int n) {
        if (this.curToken == n) {
            this.skipToken();
        } else {
            this.errorExpecting(n);
        }
    }

    protected final void nextToken(int n, int n2) {
        if (this.curToken == n || this.curToken == n2) {
            this.skipToken();
        } else {
            this.errorExpecting(n, n2);
        }
    }

    protected final boolean optionalToken(int n) {
        if (this.curToken != n) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final boolean optionalToken(int n, int n2) {
        if (this.curToken != n && this.curToken != n2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final void skipToken() {
        this.lastEndOffset = this.lexer.endOffset;
        this.curToken = this.lexer.lex(null);
    }

    protected abstract AST allocateNode(int var1);

    protected abstract void finishNode();

    protected final boolean node(int n) {
        if (this.stackTop != null && this.stackTop.shushDepth > 0) {
            this.stackTop.shushDepth = (byte)(this.stackTop.shushDepth + 1);
            return false;
        }
        AST aST = this.allocateNode(n);
        if (aST == null) {
            this.stackTop.skipDepth = (byte)(this.stackTop.skipDepth + 1);
            return false;
        }
        aST.parent = this.stackTop;
        aST.kind = n;
        aST.startOffset = this.lexer.startOffset;
        this.push(aST);
        return false;
    }

    private void push(AST aST) {
        if (this.stack.length == this.stackHeight) {
            AST[] aSTArray = new AST[this.stack.length * 2];
            System.arraycopy(this.stack, 0, aSTArray, 0, this.stack.length);
            this.stack = aSTArray;
        }
        aST.stackDepth = (short)this.stackHeight;
        this.stack[this.stackHeight++] = aST;
        this.stackTop = aST;
    }

    protected final void pop() {
        boolean bl;
        if (this.stackTop.shushDepth > 0) {
            this.stackTop.shushDepth = (byte)(this.stackTop.shushDepth - 1);
            return;
        }
        if (this.stackTop.skipDepth > 0) {
            this.stackTop.skipDepth = (byte)(this.stackTop.skipDepth - 1);
            return;
        }
        if (this.stackTop.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        boolean bl2 = bl = this.lexer.startOffset != this.stackTop.startOffset;
        if (bl) {
            this.finishNode();
        }
        if (this.stackHeight == 0) {
            this.internalError();
        }
        this.stack[--this.stackHeight] = null;
        AST aST = this.stackTop;
        this.stackTop = this.stackTop.parent;
        if (this.stackHeight == 0) {
            if (this.stackTop != null) {
                this.internalError();
            }
        } else if (this.stackTop != this.stack[this.stackHeight - 1]) {
            this.internalError();
        }
        if (this.stackTop != null && bl) {
            this.stackTop.addKid(aST);
        }
    }

    protected final boolean checkpoint() {
        if (this.lastCheckpoint == this.lexer.startOffset) {
            this.errorUnexpected();
            return false;
        }
        this.lastCheckpoint = this.lexer.startOffset;
        return true;
    }

    protected final void begin_exception_handler() {
        ++this.handlerDepth;
    }

    protected final void end_exception_handler() {
        --this.handlerDepth;
    }

    protected void notImplementedYet(String string) {
        String string2 = BaseSqlLayer.lookupErrorMessage(10);
        string2 = string2.replaceFirst("{0}", string);
        this.error(10, string2);
    }

    protected void internalError() {
        String string = BaseSqlLayer.lookupErrorMessage(6);
        if (this.root.getErrors().length == 0) {
            this.error(6, string);
        }
        throw new ParserException(string);
    }

    protected void error(int n) {
        String string = BaseSqlLayer.lookupErrorMessage(n);
        this.error(n, string);
    }

    protected void error(int n, String string) {
        if (this.handlerDepth > 0) {
            throw new ParserException(string);
        }
        if (this.errorCount++ < 32 && this.lastErrorOffset != this.lexer.startOffset) {
            PtnodError ptnodError = new PtnodError();
            ptnodError.kind = 2;
            ptnodError.startOffset = this.lexer.startOffset;
            ptnodError.message = string;
            this.root.addKid(ptnodError);
            this.lastErrorOffset = this.lexer.startOffset;
        }
    }

    protected void errorExpecting(int n) {
        this.error(14);
    }

    protected void errorExpecting(int n, int n2) {
        this.error(14);
    }

    protected void errorUnexpected() {
        this.error(14);
        this.skipToken();
    }

    public static String lookupErrorMessage(int n) {
        switch (n) {
            case 1: {
                return resources.getString("PTERR_ALTER_ATTR_MODIFY");
            }
            case 2: {
                return resources.getString("PTERR_ALTER_TYPE");
            }
            case 3: 
            case 15: {
                return resources.getString("PPARSER_ERROR_EXPECTING_IDENTIFIER");
            }
            case 4: {
                return resources.getString("PPARSER_ERROR_EXPECTING_INT_LITERAL");
            }
            case 5: {
                return resources.getString("PTERR_EXPECTING_STRING");
            }
            case 6: {
                return resources.getString("PTERR_INTERNAL_ERROR");
            }
            case 7: {
                return resources.getString("PTERR_INVALID_INTERVAL");
            }
            case 8: 
            case 23: {
                return resources.getString("PTERR_INVALID_PREDICATE");
            }
            case 9: {
                return resources.getString("PTERR_INVALID_TYPE_DEF");
            }
            case 10: {
                return resources.getString("PTERR_NOT_IMPLEMENTED_YET");
            }
            case 11: {
                return resources.getString("PTERR_PARAMETER_STYLE");
            }
            case 12: {
                return resources.getString("PTERR_PARTITION");
            }
            case 13: {
                return resources.getString("PTERR_SQLJ_USING");
            }
            case 14: {
                return resources.getString("PARSER_ERROR_UNEXPECTED");
            }
            case 16: {
                return resources.getString("QCERR_INVALID_CASE");
            }
            case 17: {
                return resources.getString("QCERR_INVALID_DBNM");
            }
            case 18: {
                return resources.getString("QCERR_INVALID_EXPRESSION");
            }
            case 19: {
                return resources.getString("QCERR_INVALID_HEURISTIC");
            }
            case 20: {
                return resources.getString("QCERR_INVALID_INTERVAL");
            }
            case 21: {
                return resources.getString("QCERR_INVALID_JOIN");
            }
            case 22: {
                return resources.getString("QCERR_INVALID_LOCK_TABLE");
            }
            case 24: {
                return resources.getString("QCERR_INVALID_USING");
            }
            case 25: {
                return resources.getString("QCERR_LISTSIZE_MISMATCH");
            }
            case 26: {
                return resources.getString("QCERR_MISSING_EXPRESSION");
            }
            case 27: {
                return resources.getString("QCERR_NO_ALIAS");
            }
            case 28: {
                return resources.getString("QCERR_NO_CUBE_ROLLUP");
            }
            case 29: {
                return resources.getString("QCERR_NO_INLINE_VIEW");
            }
            case 30: {
                return resources.getString("QCERR_NO_LIST_OPERANDS");
            }
            case 31: {
                return resources.getString("QCERR_NO_SAMPLE");
            }
            case 32: {
                return resources.getString("QCERR_RELOP_NEED_ANYALL");
            }
            case 33: {
                return resources.getString("QCERR_SUBQUERY_REQUIRED");
            }
            case 34: {
                return resources.getString("QCERR_TOO_MANY_OPERANDS");
            }
            case 35: {
                return resources.getString("PARSER_ERROR_EOF");
            }
        }
        return resources.getString("QCERR_UNKNOWN");
    }

    BaseSqlLayer() {
    }

    protected static class Context
    extends BaseSqlLexer.Context {
        protected int lastEndOffset;
        protected int lastErrorOffset;
        protected int handlerDepth;
        protected short stackHeight;
        protected byte shushDepth;
        protected byte skipDepth;
        protected int prxopc;

        protected Context() {
        }
    }
}

