/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

public abstract class AsyncTask
implements Runnable {
    public static final int STATUS_READY = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_COMPLETED = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_CANCELLED = 5;
    protected static final String CANCELLED_RESULT = "cancelled";
    private int _status = 1;
    private Object _result;

    protected AsyncTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized int getStatus() {
        int n;
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            n = this._status;
        }
        return n;
    }

    public boolean isFinished() {
        int n = this.getStatus();
        return n == 5 || n == 3 || n == 4;
    }

    public void waitUntilFinished() {
        this.waitUntilFinished(25);
    }

    public void waitUntilFinished(int n) {
        while (!this.isFinished()) {
            AsyncTask.sleep(n);
        }
    }

    protected static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            if (this._status != 1) {
                return;
            }
            this._status = 2;
        }
        try {
            Object object = this.runImpl();
            AsyncTask asyncTask2 = this;
            synchronized (asyncTask2) {
                if (object == CANCELLED_RESULT) {
                    this._status = 5;
                    object = null;
                } else {
                    this._status = 3;
                }
                this.setResult(object);
            }
        }
        catch (CancelledException cancelledException) {
            this.setResult(null);
            AsyncTask asyncTask3 = this;
            synchronized (asyncTask3) {
                this._status = 5;
            }
        }
        catch (RuntimeException runtimeException) {
            this.setResult(runtimeException);
            AsyncTask asyncTask4 = this;
            synchronized (asyncTask4) {
                this._status = 4;
            }
        }
    }

    protected abstract Object runImpl() throws CancelledException;

    protected abstract void requestCancelImpl();

    protected abstract boolean isCancelledImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void requestCancel() {
        AsyncTask asyncTask = this;
        synchronized (asyncTask) {
            switch (this._status) {
                case 1: {
                    this._status = 5;
                    break;
                }
                case 2: {
                    this.requestCancelImpl();
                    break;
                }
            }
        }
    }

    protected void bailIfCancelled() throws CancelledException {
        if (this.isCancelledImpl()) {
            throw new CancelledException();
        }
    }

    public final Object getResult() {
        return this._result;
    }

    private void setResult(Object object) {
        this._result = object;
    }

    public static class CancelledException
    extends Exception {
        public CancelledException() {
        }

        public CancelledException(String string) {
            super(string);
        }

        public CancelledException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public CancelledException(Throwable throwable) {
            super(throwable);
        }
    }
}

