/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import java.util.ArrayList;
import oracle.javatools.parser.util.ArrayListHeap;
import oracle.javatools.parser.util.ExpressionObject;
import oracle.javatools.parser.util.SimpleStack;

public class ExpressionStack
extends ArrayListHeap {
    private ArrayList expressions;
    private SimpleStack stack;
    private Object closingArgument;
    private int pos;
    private int size;

    void $init$() {
        this.expressions = null;
        this.stack = new SimpleStack();
        this.closingArgument = null;
    }

    public void add(ExpressionObject expressionObject) {
        if (this.expressions == null) {
            this.expressions = ExpressionStack.allocArrayList();
        }
        ExpressionStack.verbosePrintln("Adding ", expressionObject);
        this.expressions.add(expressionObject);
    }

    public void setClosingArgument(Object object) {
        this.closingArgument = object;
    }

    public ExpressionObject process() {
        if (this.expressions.size() == 1) {
            this.stack.push(this.expressions.get(0));
        } else {
            this.size = this.expressions.size();
            this.pos = 0;
            while (this.pos < this.size) {
                this.processOperand(1001);
            }
        }
        ExpressionStack.freeArrayList(this.expressions);
        this.expressions = null;
        return (ExpressionObject)this.stack.pop();
    }

    private ExpressionObject current() {
        return (ExpressionObject)this.expressions.get(this.pos);
    }

    private void advance() {
        ++this.pos;
    }

    private boolean eof() {
        return this.size <= this.pos;
    }

    private void pushOperand(ExpressionObject expressionObject) {
        ExpressionStack.verbosePrintln("Pushing operand: ", expressionObject);
        this.stack.push(expressionObject);
    }

    private ExpressionObject popOperand() {
        ExpressionObject expressionObject = (ExpressionObject)this.stack.pop();
        ExpressionStack.verbosePrintln("Popping operand: ", expressionObject);
        return expressionObject;
    }

    private void processOperator(ExpressionObject expressionObject) {
        int n = expressionObject.classify();
        if (n == 3) {
            this.advance();
            ExpressionStack.verbosePrintln("Processing suffix operator: ", expressionObject);
            expressionObject.addOperand(this.popOperand());
        } else if (n == 4) {
            this.advance();
            this.processOperand(1001);
            this.processOperand(expressionObject.getPrecedence());
            ExpressionStack.verbosePrintln("Processing ternary operator: ", expressionObject);
            ExpressionObject expressionObject2 = this.popOperand();
            ExpressionObject expressionObject3 = this.popOperand();
            expressionObject.addOperand(this.popOperand());
            expressionObject.addOperand(expressionObject3);
            expressionObject.addOperand(expressionObject2);
        } else {
            this.advance();
            this.processOperand(expressionObject.getPrecedence());
            if (n == 1) {
                ExpressionStack.verbosePrintln("Processing prefix operator: ", expressionObject);
                expressionObject.addOperand(this.popOperand());
            } else {
                ExpressionStack.verbosePrintln("Processing infix operator: ", expressionObject);
                ExpressionObject expressionObject4 = this.popOperand();
                expressionObject.addOperand(this.popOperand());
                expressionObject.addOperand(expressionObject4);
            }
        }
        expressionObject.closeOperator(this.closingArgument);
        this.pushOperand(expressionObject);
    }

    private void processOperand(int n) {
        ExpressionObject expressionObject = this.current();
        switch (expressionObject.classify()) {
            case 1: 
            case 2: 
            case 3: {
                this.processOperator(expressionObject);
                break;
            }
            case 0: {
                this.pushOperand(expressionObject);
                this.advance();
                break;
            }
            default: {
                throw new RuntimeException("processOperand: bad classify");
            }
        }
        while (!this.eof()) {
            ExpressionObject expressionObject2 = this.current();
            int n2 = expressionObject2.classify();
            if (n2 == 0 || n2 == 1) break;
            int n3 = expressionObject2.getPrecedence();
            if (n3 < n) {
                this.processOperator(expressionObject2);
                continue;
            }
            if (n3 != n || n3 + expressionObject2.getAssociativity() >= n) break;
            this.processOperator(expressionObject2);
        }
    }

    private static void verbosePrintln(String string, Object object) {
    }

    public ExpressionStack() {
        this.$init$();
    }
}

