/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import oracle.javatools.buffer.ReadTextBuffer;

public final class KeywordTable {
    private int tableSize = 16;
    private int tableSizeMask;
    private boolean isCaseSensitive;
    private Keyword[] hashTable;

    public KeywordTable(int n) {
        while (this.tableSize < n) {
            this.tableSize <<= 1;
        }
        this.tableSizeMask = this.tableSize - 1;
        this.isCaseSensitive = true;
        this.hashTable = new Keyword[this.tableSize];
    }

    public void setCaseSensitivity(boolean bl) {
        this.isCaseSensitive = bl;
    }

    public void addKeyword(String string, int n) {
        Keyword keyword = new Keyword(string, n, this.isCaseSensitive, null);
        int n2 = Keyword.mav$getHash(keyword);
        int n3 = n2 & this.tableSizeMask;
        Keyword keyword2 = this.hashTable[n3];
        this.hashTable[n3] = keyword;
        Keyword.mav$setNext(keyword, keyword2);
    }

    public int lookupKeyword(ReadTextBuffer readTextBuffer, int n, int n2, int n3) {
        int n4 = n3 & this.tableSizeMask;
        if (this.isCaseSensitive) {
            Keyword keyword = this.hashTable[n4];
            while (keyword != null) {
                if (Keyword.mav$getHash(keyword) == n3 && Keyword.mav$matches(keyword, readTextBuffer, n, n2)) {
                    return Keyword.mav$getToken(keyword);
                }
                keyword = Keyword.mav$getNext(keyword);
            }
        } else {
            Keyword keyword = this.hashTable[n4];
            while (keyword != null) {
                if (Keyword.mav$getHash(keyword) == n3 && Keyword.mav$matchesInsensitive(keyword, readTextBuffer, n, n2)) {
                    return Keyword.mav$getToken(keyword);
                }
                keyword = Keyword.mav$getNext(keyword);
            }
        }
        return -1;
    }

    public static int computeHash(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n += cArray[n3];
            ++n3;
        }
        return n;
    }

    public static int computeInsensitiveHash(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n += Character.toLowerCase(cArray[n3]);
            ++n3;
        }
        return n;
    }

    public static int computePartialHash(char c, int n) {
        return n + c;
    }

    public static int computeInsensitivePartialHash(char c, int n) {
        return n + Character.toLowerCase(c);
    }

    private static final class Keyword {
        private char[] keyword;
        private int token;
        private int hash;
        private Keyword next;

        private Keyword(String string, int n, boolean bl) {
            this.keyword = string.toCharArray();
            this.token = n;
            this.hash = bl ? KeywordTable.computeHash(this.keyword) : KeywordTable.computeInsensitiveHash(this.keyword);
            this.next = null;
        }

        private int getHash() {
            return this.hash;
        }

        private int getToken() {
            return this.token;
        }

        private char[] getKeyword() {
            return this.keyword;
        }

        private Keyword getNext() {
            return this.next;
        }

        private void setNext(Keyword keyword) {
            this.next = keyword;
        }

        private boolean matches(ReadTextBuffer readTextBuffer, int n, int n2) {
            int n3 = this.keyword.length;
            if (n3 == n2 - n) {
                int n4 = 0;
                while (n4 < n3) {
                    if (this.keyword[n4++] == readTextBuffer.getChar(n++)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean matchesInsensitive(ReadTextBuffer readTextBuffer, int n, int n2) {
            int n3 = this.keyword.length;
            if (n3 == n2 - n) {
                int n4 = 0;
                while (n4 < n3) {
                    char c;
                    char c2;
                    if ((c2 = this.keyword[n4++]) == (c = readTextBuffer.getChar(n++)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        static int mav$getHash(Keyword keyword) {
            return keyword.getHash();
        }

        static boolean mav$matches(Keyword keyword, ReadTextBuffer readTextBuffer, int n, int n2) {
            return keyword.matches(readTextBuffer, n, n2);
        }

        static int mav$getToken(Keyword keyword) {
            return keyword.getToken();
        }

        static Keyword mav$getNext(Keyword keyword) {
            return keyword.getNext();
        }

        static boolean mav$matchesInsensitive(Keyword keyword, ReadTextBuffer readTextBuffer, int n, int n2) {
            return keyword.matchesInsensitive(readTextBuffer, n, n2);
        }

        Keyword(String string, int n, boolean bl, 1 var4_4) {
            this(string, n, bl);
        }

        static void mav$setNext(Keyword keyword, Keyword keyword2) {
            keyword.setNext(keyword2);
        }

        public final class 1 {
        }
    }
}

