/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.patch.PatchIndexFile;

public class PatchContributor {
    private final File _directoryFile;
    private final String _argumentFilePath;

    public PatchContributor(File file) {
        this(file, null);
    }

    public PatchContributor(File file, String string) {
        this._directoryFile = file;
        this._argumentFilePath = string != null ? PatchIndexFile.convertToPatchSeparators(string) : null;
    }

    public File getDirectoryFile() {
        return this._directoryFile;
    }

    public String getArgumentFilePath() {
        return this._argumentFilePath;
    }

    protected String getBaseDirectoryPath() {
        if (this._argumentFilePath == null) {
            return null;
        }
        if (!this.isArgumentDirectory()) {
            return null;
        }
        String string = this._argumentFilePath;
        while (string.endsWith(PatchIndexFile.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string + PatchIndexFile.separator;
    }

    protected String getFilePath() {
        return !this.isArgumentDirectory() ? this._argumentFilePath : null;
    }

    protected String[] listFilePaths(boolean bl) {
        if (!this.isArgumentFileExists()) {
            return new String[0];
        }
        if (!this.isArgumentDirectory()) {
            return new String[]{this._argumentFilePath};
        }
        ArrayList arrayList = new ArrayList();
        this.listDirectory(this.createArgumentFile(), arrayList, bl);
        return arrayList.toArray(new String[0]);
    }

    protected PatchIndexFile constructIndexFile(String string) {
        return this.constructIndexFileImpl(!this.isArgumentDirectory() ? this._directoryFile : this.createArgumentFile(), string);
    }

    protected PatchIndexFile constructIndexFileImpl(File file, String string) {
        return new PatchIndexFile(file, string);
    }

    protected boolean isArgumentFileExists() {
        return this.createArgumentFile().exists();
    }

    protected boolean isArgumentDirectory() {
        return this.createArgumentFile().isDirectory();
    }

    private File createArgumentFile() {
        if (this._argumentFilePath == null) {
            return this._directoryFile;
        }
        return new File(this._directoryFile, PatchIndexFile.convertToFileSeparators(this._argumentFilePath));
    }

    private void listDirectory(File file, Collection collection, boolean bl) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                if (bl) {
                    this.listDirectory(fileArray[n], collection, bl);
                }
            } else {
                String string = fileArray[n].getAbsolutePath().substring(this._directoryFile.getPath().length());
                while (string.startsWith(File.separator)) {
                    string = string.substring(1);
                }
                collection.add(PatchIndexFile.convertToPatchSeparators(string));
            }
            ++n;
        }
    }
}

