/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.DifferenceBlock;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareModel;
import oracle.javatools.patch.PatchApplyOptions;
import oracle.javatools.patch.PatchContext;
import oracle.javatools.patch.PatchContributor;
import oracle.javatools.patch.PatchCreateOptions;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchEvent;
import oracle.javatools.patch.PatchFileComparator;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchIndexFile;
import oracle.javatools.patch.PatchListener;
import oracle.javatools.patch.PatchMatchOptions;
import oracle.javatools.patch.PatchModel;

public class PatchEngine {
    private static final int ENTRY_STATE_ADDED = 1;
    private static final int ENTRY_STATE_REMOVED = 2;
    private static final int ENTRY_STATE_MODIFIED = 3;
    private final PatchContributor _toFileContributor;
    private final Collection _patchListeners;

    void $init$() {
        this._patchListeners = new ArrayList();
    }

    public PatchEngine(PatchContributor patchContributor) {
        this.$init$();
        this._toFileContributor = patchContributor;
    }

    public void addPatchListener(PatchListener patchListener) {
        this._patchListeners.add(patchListener);
    }

    public void removePatchListener(PatchListener patchListener) {
        this._patchListeners.remove(patchListener);
    }

    public PatchModel createModel(PatchContributor patchContributor, PatchCreateOptions patchCreateOptions) throws IOException, CompareFailedException {
        PatchFileComparator patchFileComparator = new PatchFileComparator();
        patchFileComparator.setBaseDirectoryPaths(patchContributor.getBaseDirectoryPath(), this._toFileContributor.getBaseDirectoryPath());
        patchFileComparator.setEquivalientPaths(patchContributor.getFilePath(), this._toFileContributor.getFilePath());
        ArrayList arrayList = new ArrayList();
        String[] stringArray = patchContributor.listFilePaths(patchCreateOptions.isRecursive());
        int n = 0;
        while (n < stringArray.length) {
            this.findOrCreateFilePath(arrayList, patchFileComparator, stringArray[n]).setFromFilePath(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = this._toFileContributor.listFilePaths(patchCreateOptions.isRecursive());
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.findOrCreateFilePath(arrayList, patchFileComparator, stringArray2[n2]).setToFilePath(stringArray2[n2]);
            ++n2;
        }
        Collections.sort(arrayList, new 1(this, patchFileComparator));
        PatchModel patchModel = new PatchModel();
        for (FilePath filePath : arrayList) {
            PatchEntry patchEntry;
            String string = filePath.getFromFilePath();
            String string2 = filePath.getToFilePath();
            if (!patchCreateOptions.isIncludeNewFiles() && (string == null || string2 == null)) continue;
            String string3 = null;
            if (string != null) {
                string3 = PatchEngine.stripFilePathBase(string, patchContributor.getBaseDirectoryPath());
            }
            String string4 = null;
            if (string2 != null) {
                string4 = PatchEngine.stripFilePathBase(string2, this._toFileContributor.getBaseDirectoryPath());
            }
            PatchIndexFile patchIndexFile = string3 != null ? patchContributor.constructIndexFile(string3) : null;
            PatchIndexFile patchIndexFile2 = string4 != null ? this._toFileContributor.constructIndexFile(string4) : null;
            TextBuffer textBuffer = null;
            TextBuffer textBuffer2 = null;
            textBuffer2 = patchIndexFile2 != null ? patchIndexFile2.getTextBuffer() : TextBufferFactory.createArrayTextBuffer();
            textBuffer = patchIndexFile != null ? patchIndexFile.getTextBuffer() : TextBufferFactory.createArrayTextBuffer();
            if (textBuffer != null && textBuffer2 != null) {
                String string5 = string != null ? PatchEngine.extractFilePathExtension(string) : PatchEngine.extractFilePathExtension(string2);
                boolean bl = patchCreateOptions.isIgnoreWhitespace();
                CompareModel compareModel = CompareModelFactory.createCompareModel(new CompareContributorImpl(textBuffer, string5, bl), new CompareContributorImpl(textBuffer2, string5, bl));
                patchEntry = this.createPatchEntry((TextCompareModel)compareModel);
            } else {
                patchEntry = new PatchEntry();
            }
            if (patchIndexFile != null) {
                patchEntry.setFromFile(string);
                patchEntry.setFromFileModificationTime(new Date(patchIndexFile.lastModified()));
                patchEntry.setFromFileRevision(patchIndexFile.getRevision());
            }
            if (patchIndexFile2 != null) {
                patchEntry.setToFile(string2);
                patchEntry.setToFileModificationTime(new Date(patchIndexFile2.lastModified()));
                patchEntry.setToFileRevision(patchIndexFile2.getRevision());
            }
            if (patchIndexFile == null && patchIndexFile2 == null) {
                throw new IllegalStateException();
            }
            if (this.getEntryState(patchEntry) == 3 && patchEntry.getHunks().length <= 0) continue;
            patchModel.addEntry(patchEntry);
        }
        return patchModel;
    }

    public PatchContext matchModel(PatchModel patchModel, PatchMatchOptions patchMatchOptions) throws IOException {
        PatchContext patchContext = new PatchContext();
        patchContext.setPrefixSlashNumber(patchMatchOptions.getPrefixSlashNumber());
        PatchEntry[] patchEntryArray = patchModel.getEntries();
        int n = 0;
        while (n < patchEntryArray.length) {
            if (patchEntryArray[n].getFromFile() != null || patchEntryArray[n].getToFile() != null) {
                if (this.getEntryState(patchEntryArray[n]) == 1) {
                    patchContext.setEntryMatched(patchEntryArray[n], true);
                }
                if (this.getEntryState(patchEntryArray[n]) != 2) {
                    String string = null;
                    if (patchEntryArray[n].getFromFile() != null) {
                        string = PatchEngine.stripFilePathPrefix(patchEntryArray[n].getFromFile(), patchMatchOptions.getPrefixSlashNumber());
                    }
                    if (string != null) {
                        PatchIndexFile patchIndexFile = this._toFileContributor.constructIndexFile(string);
                        if (this.getEntryState(patchEntryArray[n]) == 1 || patchIndexFile.exists() && !patchIndexFile.isDirectory()) {
                            patchContext.setEntryMatched(patchEntryArray[n], true);
                            TextBuffer textBuffer = patchIndexFile.getTextBuffer();
                            textBuffer.setReadOnly(true);
                            PatchHunk[] patchHunkArray = patchEntryArray[n].getHunks();
                            int n2 = 0;
                            while (n2 < patchHunkArray.length) {
                                textBuffer.readLock();
                                try {
                                    patchContext.setHunkMatchLine(patchHunkArray[n2], this.findBufferHunkMatchLine(textBuffer, patchHunkArray[n2], patchMatchOptions));
                                }
                                finally {
                                    textBuffer.readUnlock();
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
            ++n;
        }
        return patchContext;
    }

    public void applyModel(PatchModel patchModel, PatchContext patchContext, PatchApplyOptions patchApplyOptions) throws IOException {
        PatchEntry[] patchEntryArray = patchModel.getEntries();
        this.firePatchEvent(new PatchEvent(this, 1));
        this.firePatchEvent(new PatchEvent(this, 12, 0.0f));
        int n = 0;
        while (n < patchEntryArray.length) {
            block9: {
                PatchIndexFile patchIndexFile;
                block13: {
                    block10: {
                        String string;
                        block11: {
                            String string2;
                            block12: {
                                int n2;
                                this.firePatchEvent(new PatchEvent(this, 12, Math.min((float)((n + 1) / patchEntryArray.length), 1.0f)));
                                if (!patchContext.isEntryMatched(patchEntryArray[n]) || patchEntryArray[n].getFromFile() == null && patchEntryArray[n].getToFile() == null || (n2 = this.getEntryState(patchEntryArray[n])) <= 0) break block9;
                                patchIndexFile = null;
                                if (patchEntryArray[n].getFromFile() == null) break block10;
                                string = PatchEngine.stripFilePathPrefix(patchEntryArray[n].getFromFile(), patchContext.getPrefixSlashNumber());
                                patchIndexFile = this._toFileContributor.constructIndexFile(string);
                                if (!patchApplyOptions.isMakeBackupFiles()) break block11;
                                string2 = patchIndexFile.getBackupName();
                                if (patchIndexFile.createBackup(string2)) break block12;
                                this.firePatchEvent(new PatchEvent(this, 7, string, string2));
                                break block9;
                            }
                            this.firePatchEvent(new PatchEvent(this, 6, string, string2));
                        }
                        if (this.getEntryState(patchEntryArray[n]) != 2) break block13;
                        if (patchIndexFile.delete()) {
                            this.firePatchEvent(new PatchEvent(this, 4, string));
                        } else {
                            this.firePatchEvent(new PatchEvent(this, 5, string));
                        }
                        break block9;
                    }
                    String string = PatchEngine.stripFilePathPrefix(patchEntryArray[n].getToFile(), patchContext.getPrefixSlashNumber());
                    patchIndexFile = this._toFileContributor.constructIndexFile(string);
                    if (!patchIndexFile.exists()) {
                        if (patchIndexFile.createNewFile()) {
                            this.firePatchEvent(new PatchEvent(this, 2, string));
                        } else {
                            this.firePatchEvent(new PatchEvent(this, 3, string));
                        }
                    }
                }
                TextBuffer textBuffer = patchIndexFile.getTextBuffer();
                this.firePatchEvent(new PatchEvent(this, 8, patchIndexFile.getPath()));
                this.applyEntry(patchEntryArray[n], patchContext, textBuffer);
                if (patchIndexFile.saveTextBuffer()) {
                    this.firePatchEvent(new PatchEvent(this, 9, patchIndexFile.getPath()));
                } else {
                    this.firePatchEvent(new PatchEvent(this, 10, patchIndexFile.getPath()));
                }
                Date date = patchEntryArray[n].getToFileModificationTime();
                if (date != null) {
                    patchIndexFile.setLastModified(date.getTime());
                }
            }
            ++n;
        }
        this.firePatchEvent(new PatchEvent(this, 12, 1.0f));
        this.firePatchEvent(new PatchEvent(this, 11));
    }

    public PatchModel reverseModel(PatchModel patchModel, String string) {
        PatchModel patchModel2 = new PatchModel();
        PatchEntry[] patchEntryArray = patchModel.getEntries();
        int n = 0;
        while (n < patchEntryArray.length) {
            patchModel2.addEntry(this.reversePatchEntry(patchEntryArray[n], string));
            ++n;
        }
        return patchModel2;
    }

    private FilePath findOrCreateFilePath(Collection collection, Comparator comparator, String string) {
        FilePath filePath = null;
        for (FilePath filePath2 : collection) {
            String string2;
            String string3 = string2 = filePath2.getFromFilePath() != null ? filePath2.getFromFilePath() : filePath2.getToFilePath();
            if (comparator.compare(string2, string) != 0) continue;
            filePath = filePath2;
            break;
        }
        if (filePath == null) {
            filePath = new FilePath(null);
            collection.add(filePath);
        }
        return filePath;
    }

    private PatchEntry createPatchEntry(TextCompareModel textCompareModel) {
        DifferenceBlock[] differenceBlockArray = textCompareModel.getDifferenceBlocks();
        PatchEntry patchEntry = new PatchEntry();
        int n = 0;
        while (n < differenceBlockArray.length) {
            if (differenceBlockArray[n].getKind() != 0) {
                PatchHunk patchHunk = new PatchHunk();
                patchHunk.setFromFileLineNumber(differenceBlockArray[n].getStart(ContributorKind.FIRST));
                patchHunk.setFromFileLineCount(differenceBlockArray[n].getLength(ContributorKind.FIRST));
                patchHunk.setToFileLineNumber(differenceBlockArray[n].getStart(ContributorKind.SECOND) + 1);
                patchHunk.setToFileLineCount(differenceBlockArray[n].getLength(ContributorKind.SECOND));
                int n2 = -1;
                if (differenceBlockArray[n].isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
                    n2 = 1;
                }
                if (differenceBlockArray[n].isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
                    n2 = 2;
                }
                if (differenceBlockArray[n].isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
                    n2 = 3;
                }
                if (n2 > 0) {
                    String[] stringArray;
                    TextBuffer textBuffer = ((TextCompareContributor)textCompareModel.getContributor(ContributorKind.FIRST)).getTextBuffer();
                    if (n2 == 3 || n2 == 2) {
                        stringArray = this.readTextBufferLines(textBuffer, patchHunk.getFromFileLineNumber(), patchHunk.getFromFileLineCount());
                        patchHunk.setFromFileLineCount(stringArray.length);
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            PatchHunkLine patchHunkLine = new PatchHunkLine(3);
                            patchHunkLine.setLineData(stringArray[n3]);
                            patchHunk.addLine(patchHunkLine);
                            ++n3;
                        }
                    }
                    TextBuffer textBuffer2 = ((TextCompareContributor)textCompareModel.getContributor(ContributorKind.SECOND)).getTextBuffer();
                    if (n2 == 3 || n2 == 1) {
                        stringArray = this.readTextBufferLines(textBuffer2, patchHunk.getToFileLineNumber() - 1, patchHunk.getToFileLineCount());
                        patchHunk.setToFileLineCount(stringArray.length);
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            PatchHunkLine patchHunkLine = new PatchHunkLine(2);
                            patchHunkLine.setLineData(stringArray[n4]);
                            patchHunk.addLine(patchHunkLine);
                            ++n4;
                        }
                    }
                    if (this.hunkContainsRemovedLine(patchHunk)) {
                        patchHunk.setFromFileLineNumber(patchHunk.getFromFileLineNumber() + 1);
                    }
                    if (n2 == 2) {
                        patchHunk.setToFileLineNumber(patchHunk.getToFileLineNumber() - 1);
                    }
                    if (patchHunk.getLines().length > 0) {
                        patchEntry.addHunk(patchHunk);
                    }
                }
            }
            ++n;
        }
        return patchEntry;
    }

    private int getEntryState(PatchEntry patchEntry) {
        if (patchEntry.getFromFile() != null && patchEntry.getToFile() == null) {
            return 2;
        }
        if (patchEntry.getFromFile() == null && patchEntry.getToFile() != null) {
            return 1;
        }
        if (patchEntry.getFromFile() != null && patchEntry.getToFile() != null) {
            return 3;
        }
        return -1;
    }

    private String[] readTextBufferLines(TextBuffer textBuffer, int n, int n2) {
        String[] stringArray = new String[]{};
        textBuffer.readLock();
        try {
            LineMap lineMap = textBuffer.getLineMap();
            int n3 = Math.min(n + n2, lineMap.getLineCount());
            stringArray = new String[Math.max(0, n3 - n)];
            int n4 = 0;
            while (n < n3) {
                int n5 = lineMap.getLineStartOffset(n);
                int n6 = lineMap.getLineEndOffset(n) - n5;
                stringArray[n4++] = this.trimEndOfLineChars(textBuffer.getString(n5, n6));
                ++n;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return stringArray;
    }

    private int findBufferHunkMatchLine(TextBuffer textBuffer, PatchHunk patchHunk, PatchMatchOptions patchMatchOptions) throws IOException {
        int n = patchHunk.getFromFileLineNumber();
        if (this.matchHunkFromLine(textBuffer, n, patchHunk, patchMatchOptions)) {
            return n;
        }
        if (patchMatchOptions.getMaximumFuzzFactor() <= 0) {
            return -1;
        }
        int n2 = n + patchMatchOptions.getMaximumFuzzFactor();
        while (n < n2) {
            if (!this.matchHunkFromLine(textBuffer, ++n, patchHunk, patchMatchOptions)) continue;
            return n;
        }
        n = patchHunk.getFromFileLineNumber();
        int n3 = n - patchMatchOptions.getMaximumFuzzFactor();
        while (n > Math.max(1, n3)) {
            if (!this.matchHunkFromLine(textBuffer, --n, patchHunk, patchMatchOptions)) continue;
            return n;
        }
        return -1;
    }

    private boolean matchHunkFromLine(TextBuffer textBuffer, int n, PatchHunk patchHunk, PatchMatchOptions patchMatchOptions) throws IOException {
        LineMap lineMap = textBuffer.getLineMap();
        int n2 = n - 1 + patchHunk.getFromFileLineCount();
        if (lineMap.getLineCount() < n2) {
            return false;
        }
        PatchHunkLine[] patchHunkLineArray = patchHunk.getLines();
        int n3 = n;
        int n4 = 0;
        while (n3 <= n2) {
            while (true) {
                if (n4 >= patchHunkLineArray.length) {
                    return true;
                }
                if (patchHunkLineArray[n4].getIndicator() != 2) break;
                ++n4;
            }
            int n5 = lineMap.getLineStartOffset(Math.max(0, n3 - 1));
            int n6 = lineMap.getLineEndOffset(Math.max(0, n3 - 1)) - n5;
            String string = this.trimEndOfLineChars(textBuffer.getString(n5, n6));
            String string2 = patchHunkLineArray[n4++].getLineData();
            if (patchMatchOptions.isIgnoreWhitespace() ? !this.equalsIgnoreWhitespace(string, string2) : !string.equals(string2)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean equalsIgnoreWhitespace(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n < string.length() || n2 < string2.length()) {
            char c;
            char c2 = n < string.length() ? string.charAt(n) : (char)'\u0000';
            char c3 = c = n2 < string2.length() ? string2.charAt(n2) : (char)'\u0000';
            if (this.isWhitespace(c2)) {
                ++n;
                continue;
            }
            if (this.isWhitespace(c)) {
                ++n2;
                continue;
            }
            if (c2 != c) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private String trimEndOfLineChars(String string) {
        String string2 = "\r\f\n";
        int n = string.length();
        while (n > 0 && string2.indexOf(string.charAt(n - 1)) >= 0) {
            --n;
        }
        return n >= string.length() ? string : string.substring(0, n);
    }

    private void applyEntry(PatchEntry patchEntry, PatchContext patchContext, TextBuffer textBuffer) {
        textBuffer.setReadOnly(false);
        textBuffer.writeLock();
        try {
            LineMap lineMap = textBuffer.getLineMap();
            ArrayList<PatchHunk> arrayList = new ArrayList<PatchHunk>();
            ArrayList<OffsetMark> arrayList2 = new ArrayList<OffsetMark>();
            PatchHunk[] patchHunkArray = patchEntry.getHunks();
            int n = 0;
            while (n < patchHunkArray.length) {
                int n2 = patchContext.getHunkMatchLine(patchHunkArray[n]);
                if (n2 >= 0) {
                    int n3 = n2 + patchHunkArray[n].getFromFileLineCount() - 1;
                    if (lineMap.getLineCount() >= n3) {
                        if (patchHunkArray[n].getFromFileLineCount() > 0) {
                            --n2;
                            --n3;
                        }
                        int n4 = 0;
                        int n5 = 0;
                        n4 = lineMap.getLineStartOffset(Math.max(0, n2));
                        n5 = patchHunkArray[n].getFromFileLineCount() <= 0 ? n4 : Math.max(lineMap.getLineEndOffset(Math.max(0, n3)), lineMap.getLineStartOffset(Math.max(0, n3)));
                        arrayList.add(patchHunkArray[n]);
                        arrayList2.add(textBuffer.addOffsetMark(n4));
                        arrayList2.add(textBuffer.addOffsetMark(n5));
                    }
                }
                ++n;
            }
            boolean bl = this.determineLineMapEndsWithEOL(lineMap);
            Iterator iterator = arrayList.iterator();
            Iterator iterator2 = arrayList2.iterator();
            while (iterator.hasNext()) {
                PatchHunk patchHunk = (PatchHunk)iterator.next();
                OffsetMark offsetMark = (OffsetMark)iterator2.next();
                OffsetMark offsetMark2 = (OffsetMark)iterator2.next();
                boolean bl2 = offsetMark.getOffset() >= textBuffer.getLength();
                textBuffer.remove(offsetMark.getOffset(), offsetMark2.getOffset() - offsetMark.getOffset());
                String[] stringArray = this.extractHunkToFileData(patchHunk);
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = textBuffer.getEOLType().toCharArray();
                int n6 = 0;
                while (n6 < stringArray.length) {
                    if (n6 > 0 || offsetMark.getOffset() > 0 && offsetMark.getOffset() == offsetMark2.getOffset() && bl2) {
                        stringBuffer.append(cArray);
                    }
                    stringBuffer.append(stringArray[n6]);
                    ++n6;
                }
                if (stringArray.length > 0 && (!bl2 || iterator.hasNext() || bl)) {
                    stringBuffer.append(cArray);
                }
                textBuffer.insert(offsetMark.getOffset(), stringBuffer.toString().toCharArray());
            }
            Iterator iterator3 = arrayList2.iterator();
            while (iterator3.hasNext()) {
                textBuffer.removeOffsetMark((OffsetMark)iterator3.next());
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
    }

    private boolean hunkContainsRemovedLine(PatchHunk patchHunk) {
        PatchHunkLine[] patchHunkLineArray = patchHunk.getLines();
        int n = 0;
        while (n < patchHunkLineArray.length) {
            if (patchHunkLineArray[n].getIndicator() == 3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean determineLineMapEndsWithEOL(LineMap lineMap) {
        int n = lineMap.getLineCount();
        return n > 0 && lineMap.getLineStartOffset(n - 1) == lineMap.getLineEndOffset(n - 1);
    }

    private String[] extractHunkToFileData(PatchHunk patchHunk) {
        PatchHunkLine[] patchHunkLineArray = patchHunk.getLines();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < patchHunkLineArray.length) {
            if (patchHunkLineArray[n].getIndicator() != 3) {
                arrayList.add(patchHunkLineArray[n].getLineData());
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    private void firePatchEvent(PatchEvent patchEvent) {
        PatchListener[] patchListenerArray = this._patchListeners.toArray(new PatchListener[0]);
        int n = patchListenerArray.length - 1;
        while (n >= 0) {
            switch (patchEvent.getID()) {
                case 1: {
                    patchListenerArray[n].patchApplyStarted(patchEvent);
                    break;
                }
                case 2: {
                    patchListenerArray[n].patchFileCreated(patchEvent);
                    break;
                }
                case 3: {
                    patchListenerArray[n].patchFileCreateFailed(patchEvent);
                    break;
                }
                case 4: {
                    patchListenerArray[n].patchFileDeleted(patchEvent);
                    break;
                }
                case 5: {
                    patchListenerArray[n].patchFileDeleteFailed(patchEvent);
                    break;
                }
                case 6: {
                    patchListenerArray[n].patchFileBackedUp(patchEvent);
                    break;
                }
                case 7: {
                    patchListenerArray[n].patchFileBackupFailed(patchEvent);
                    break;
                }
                case 8: {
                    patchListenerArray[n].patchBufferChanging(patchEvent);
                    break;
                }
                case 9: {
                    patchListenerArray[n].patchFileSaved(patchEvent);
                    break;
                }
                case 10: {
                    patchListenerArray[n].patchFileSaveFailed(patchEvent);
                    break;
                }
                case 11: {
                    patchListenerArray[n].patchApplyFinished(patchEvent);
                    break;
                }
                case 12: {
                    patchListenerArray[n].patchProgressUpdated(patchEvent);
                }
            }
            --n;
        }
    }

    static final String stripFilePathBase(String string, String string2) {
        return string2 != null && string.startsWith(string2) ? string.substring(string2.length()) : string;
    }

    static final String stripFilePathPrefix(String string, int n) {
        int n2;
        while (string != null && n > 0 && (n2 = string.indexOf(47)) >= 0) {
            string = string.substring(n2 + 1);
            --n;
        }
        return string;
    }

    static final String createFilePath(String string, String string2) {
        return string2 != null ? string2 + '/' + string : string;
    }

    static final String extractFilePathExtension(String string) {
        int n = string != null ? string.lastIndexOf(46) : -1;
        return n < 0 ? "" : string.substring(n + 1);
    }

    private PatchEntry reversePatchEntry(PatchEntry patchEntry, String string) {
        String string2;
        String string3;
        PatchEntry patchEntry2 = new PatchEntry();
        if (patchEntry.getToFile() != null) {
            String string4 = PatchEngine.stripFilePathBase(patchEntry.getToFile(), this._toFileContributor.getBaseDirectoryPath());
            string3 = PatchEngine.createFilePath(string4, string);
        } else {
            string3 = null;
        }
        if (patchEntry.getFromFile() != null) {
            String string5 = PatchEngine.stripFilePathBase(patchEntry.getFromFile(), string);
            string2 = PatchEngine.createFilePath(string5, this._toFileContributor.getBaseDirectoryPath());
        } else {
            string2 = null;
        }
        patchEntry2.setFromFile(string3);
        patchEntry2.setFromFileModificationTime(patchEntry.getToFileModificationTime());
        patchEntry2.setFromFileRevision(patchEntry.getToFileRevision());
        patchEntry2.setToFile(string2);
        patchEntry2.setToFileModificationTime(patchEntry.getFromFileModificationTime());
        patchEntry2.setToFileRevision(patchEntry.getFromFileRevision());
        PatchHunk[] patchHunkArray = patchEntry.getHunks();
        int n = 0;
        while (n < patchHunkArray.length) {
            patchEntry2.addHunk(this.reversePatchHunk(patchHunkArray[n]));
            ++n;
        }
        return patchEntry2;
    }

    private PatchHunk reversePatchHunk(PatchHunk patchHunk) {
        PatchHunk patchHunk2 = new PatchHunk();
        patchHunk2.setFromFileLineNumber(patchHunk.getToFileLineNumber());
        patchHunk2.setFromFileLineCount(patchHunk.getToFileLineCount());
        patchHunk2.setToFileLineNumber(patchHunk.getFromFileLineNumber());
        patchHunk2.setToFileLineCount(patchHunk.getFromFileLineCount());
        PatchHunkLine[] patchHunkLineArray = patchHunk.getLines();
        int n = 0;
        while (n < patchHunkLineArray.length) {
            patchHunk2.addLine(this.reversePatchHunkLine(patchHunkLineArray[n]));
            ++n;
        }
        return patchHunk2;
    }

    private PatchHunkLine reversePatchHunkLine(PatchHunkLine patchHunkLine) {
        PatchHunkLine patchHunkLine2 = patchHunkLine;
        if (patchHunkLine.getIndicator() == 2) {
            patchHunkLine2 = new PatchHunkLine(3);
        }
        if (patchHunkLine.getIndicator() == 3) {
            patchHunkLine2 = new PatchHunkLine(2);
        }
        patchHunkLine2.setLineData(patchHunkLine.getLineData());
        patchHunkLine2.setNoNewlineAtEOF(patchHunkLine.isNoNewlineAtEOF());
        return patchHunkLine2;
    }

    public final class 1
    implements Comparator {
        private final /* synthetic */ PatchFileComparator v$fileComparator;
        final /* synthetic */ PatchEngine this$0;

        public int compare(Object object, Object object2) {
            FilePath filePath = (FilePath)object;
            FilePath filePath2 = (FilePath)object2;
            String string = filePath.getFromFilePath() != null ? filePath.getFromFilePath() : filePath.getToFilePath();
            String string2 = filePath2.getFromFilePath() != null ? filePath2.getFromFilePath() : filePath2.getToFilePath();
            return this.v$fileComparator.compare(string, string2);
        }

        public 1(PatchEngine patchEngine, PatchFileComparator patchFileComparator) {
            this.v$fileComparator = patchFileComparator;
            this.this$0 = patchEngine;
        }
    }

    private class FilePath {
        private String _fromFilePath;
        private String _toFilePath;

        void setFromFilePath(String string) {
            this._fromFilePath = string;
        }

        String getFromFilePath() {
            return this._fromFilePath;
        }

        void setToFilePath(String string) {
            this._toFilePath = string;
        }

        String getToFilePath() {
            return this._toFilePath;
        }

        private FilePath() {
        }

        FilePath(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CompareContributorImpl
    extends TextCompareContributor {
        private final TextBuffer _textBuffer;
        private final String _type;

        CompareContributorImpl(TextBuffer textBuffer, String string, boolean bl) {
            this.setIgnoreWhitespace(bl);
            this._textBuffer = textBuffer;
            this._type = string;
        }

        public TextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        public String getType() {
            return this._type;
        }

        public String getLongLabel() {
            return "";
        }

        public String getShortLabel() {
            return "";
        }
    }
}

