/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchModel;

public class PatchFormat {
    private static final String DIFF_DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private static final Locale DIFF_DATE_LOCALE = Locale.US;
    private static final String RFC_822_DATE_FORMAT = "dd MMM yyyy HH:mm:ss Z";
    private static final Locale RFC_822_DATE_LOCALE = Locale.US;
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static final Locale ISO_8601_DATE_LOCALE = Locale.US;
    private static final String NO_NL_AT_EOF_MARKER = "\\ No newline at end of file";
    private static final String DEV_NULL = "/dev/null";
    private String _charsetName;

    public void setEncoding(String string) {
        this._charsetName = string;
    }

    public String getEncoding() {
        return this._charsetName;
    }

    public String format(PatchModel patchModel) {
        OutputStreamWriter outputStreamWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            outputStreamWriter = this._charsetName != null ? new OutputStreamWriter((OutputStream)byteArrayOutputStream, this._charsetName) : new OutputStreamWriter(byteArrayOutputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            String string = "";
            return string;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        try {
            PatchEntry[] patchEntryArray = patchModel.getEntries();
            int n = 0;
            while (n < patchEntryArray.length) {
                bufferedWriter.write("--- " + this.formatEntryHeaderLine(patchEntryArray[n].getFromFile(), patchEntryArray[n].getFromFileModificationTime(), patchEntryArray[n].getFromFileRevision()));
                bufferedWriter.newLine();
                bufferedWriter.write("+++ " + this.formatEntryHeaderLine(patchEntryArray[n].getToFile(), patchEntryArray[n].getToFileModificationTime(), patchEntryArray[n].getToFileRevision()));
                bufferedWriter.newLine();
                PatchHunk[] patchHunkArray = patchEntryArray[n].getHunks();
                int n2 = 0;
                while (n2 < patchHunkArray.length) {
                    bufferedWriter.write(this.formatHunkRangeLine(patchHunkArray[n2]));
                    bufferedWriter.newLine();
                    PatchHunkLine[] patchHunkLineArray = patchHunkArray[n2].getLines();
                    int n3 = 0;
                    while (n3 < patchHunkLineArray.length) {
                        int n4 = patchHunkLineArray[n3].getIndicator();
                        if (n4 == 2) {
                            bufferedWriter.write(43);
                        }
                        if (n4 == 3) {
                            bufferedWriter.write(45);
                        }
                        if (n4 == 1) {
                            bufferedWriter.write(32);
                        }
                        bufferedWriter.write(patchHunkLineArray[n3].getLineData());
                        bufferedWriter.newLine();
                        if (patchHunkLineArray[n3].isNoNewlineAtEOF()) {
                            bufferedWriter.write(NO_NL_AT_EOF_MARKER);
                            bufferedWriter.newLine();
                        }
                        ++n3;
                    }
                    ++n2;
                }
                bufferedWriter.flush();
                ++n;
            }
            String string = this._charsetName != null ? new String(byteArrayOutputStream.toByteArray(), this._charsetName) : new String(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = "";
            return string;
        }
    }

    public PatchModel parse(String string) throws ParseException {
        InputStreamReader inputStreamReader;
        PatchModel patchModel = new PatchModel();
        try {
            inputStreamReader = this._charsetName != null ? new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes(this._charsetName)), this._charsetName) : new InputStreamReader(new ByteArrayInputStream(string.getBytes()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            PatchModel patchModel2 = patchModel;
            return patchModel2;
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        PatchEntry patchEntry = null;
        PatchHunk patchHunk = null;
        PatchHunkLine patchHunkLine = null;
        Pattern pattern = Pattern.compile("(---|\\+\\+\\+) ([^\\t]+)\\t([[^\\t]$]+)(\\t[^\\t]+)?.*");
        Pattern pattern2 = Pattern.compile("@@ -([^ ]+) \\+([^ ]+) @@");
        while (true) {
            String string2 = null;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string2 == null) break;
            Matcher matcher = pattern.matcher(string2);
            if (matcher.matches()) {
                String string3;
                String string4 = matcher.group(2);
                string4 = string4.equals("nul") || string4.equals(DEV_NULL) ? null : string4;
                Date date = this.parseModificationTime(matcher.group(3));
                String string5 = string3 = matcher.group(4) != null ? matcher.group(4).trim() : null;
                if (matcher.group(1).startsWith("-")) {
                    patchEntry = new PatchEntry();
                    patchModel.addEntry(patchEntry);
                    patchHunk = null;
                    patchEntry.setFromFile(string4);
                    patchEntry.setFromFileModificationTime(date);
                    patchEntry.setFromFileRevision(string3);
                    continue;
                }
                if (patchEntry == null) continue;
                patchEntry.setToFile(string4);
                patchEntry.setToFileModificationTime(date);
                patchEntry.setToFileRevision(string3);
                continue;
            }
            if (patchEntry == null) continue;
            matcher = pattern2.matcher(string2);
            if (matcher.matches()) {
                patchHunk = new PatchHunk();
                patchEntry.addHunk(patchHunk);
                try {
                    String string6 = matcher.group(1);
                    int n = string6.indexOf(44);
                    patchHunk.setFromFileLineNumber(this.parseRangeLineNumber(string6, n));
                    patchHunk.setFromFileLineCount(this.parseRangeLineCount(string6, n));
                    string6 = matcher.group(2);
                    n = string6.indexOf(44);
                    patchHunk.setToFileLineNumber(this.parseRangeLineNumber(string6, n));
                    patchHunk.setToFileLineCount(this.parseRangeLineCount(string6, n));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PatchParseException("contains bad line number or count: \"" + string2 + "\"");
                }
            }
            if (string2.length() == 0 || patchHunk == null) continue;
            char c = string2.charAt(0);
            if (string2.startsWith(NO_NL_AT_EOF_MARKER) && patchHunkLine != null) {
                patchHunkLine.setNoNewlineAtEOF(true);
                continue;
            }
            patchHunkLine = null;
            if (c == ' ') {
                patchHunkLine = new PatchHunkLine(1);
            }
            if (c == '+') {
                patchHunkLine = new PatchHunkLine(2);
            }
            if (c == '-') {
                patchHunkLine = new PatchHunkLine(3);
            }
            if (patchHunkLine == null) continue;
            patchHunkLine.setLineData(string2.substring(1));
            patchHunk.addLine(patchHunkLine);
        }
        if (patchModel.getEntries().length <= 0) {
            throw new PatchParseException("does not contain any entry information");
        }
        PatchEntry[] patchEntryArray = patchModel.getEntries();
        int n = 0;
        while (n < patchEntryArray.length) {
            if (patchEntryArray[n].getFromFile() == null && patchEntryArray[n].getToFile() == null) {
                throw new PatchParseException("contains a null to/from file entry");
            }
            ++n;
        }
        return patchModel;
    }

    private String formatEntryHeaderLine(String string, Date date, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(DEV_NULL);
        }
        if (date != null) {
            stringBuffer.append('\t');
            stringBuffer.append(new SimpleDateFormat(DIFF_DATE_FORMAT, DIFF_DATE_LOCALE).format(date));
        }
        if (string2 != null) {
            stringBuffer.append('\t');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String formatHunkRangeLine(PatchHunk patchHunk) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@@ -");
        stringBuffer.append(patchHunk.getFromFileLineNumber());
        if (patchHunk.getFromFileLineCount() != 1) {
            stringBuffer.append(',');
            stringBuffer.append(patchHunk.getFromFileLineCount());
        }
        stringBuffer.append(" +");
        stringBuffer.append(patchHunk.getToFileLineNumber());
        if (patchHunk.getToFileLineCount() != 1) {
            stringBuffer.append(',');
            stringBuffer.append(patchHunk.getToFileLineCount());
        }
        stringBuffer.append(" @@");
        return stringBuffer.toString();
    }

    private Date parseModificationTime(String string) {
        try {
            Date date = new SimpleDateFormat(DIFF_DATE_FORMAT, DIFF_DATE_LOCALE).parse(string);
            return date;
        }
        catch (ParseException parseException) {
            try {
                Date date = new SimpleDateFormat(RFC_822_DATE_FORMAT, RFC_822_DATE_LOCALE).parse(string);
                return date;
            }
            catch (ParseException parseException2) {
                try {
                    Date date = new SimpleDateFormat(ISO_8601_DATE_FORMAT, ISO_8601_DATE_LOCALE).parse(string.replaceAll("\\.\\d+", ""));
                    return date;
                }
                catch (ParseException parseException3) {
                    return new Date(System.currentTimeMillis());
                }
            }
        }
    }

    private int parseRangeLineNumber(String string, int n) {
        return Math.max(0, Integer.parseInt(n < 0 ? string : string.substring(0, n)));
    }

    private int parseRangeLineCount(String string, int n) {
        int n2 = -1;
        if (n > 0) {
            n2 = Integer.parseInt(string.substring(n + 1));
        }
        return n2 < 0 ? 1 : n2;
    }

    private class PatchParseException
    extends ParseException {
        PatchParseException(String string) {
            super("Unparseable patch: " + string, 0);
        }
    }
}

