/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;

public class PatchIndexFile {
    public static final char separatorChar = '/';
    public static final String separator = "" + '/';
    private final File _directoryFile;
    private final String _path;
    private final File _file;
    private TextBuffer _textBuffer;
    private String _charsetName;

    public PatchIndexFile(File file, String string) {
        this._directoryFile = file;
        this._path = string;
        this._file = new File(this._directoryFile, PatchIndexFile.convertToFileSeparators(this._path));
    }

    public void setTextBuffer(TextBuffer textBuffer) {
        this._textBuffer = textBuffer;
    }

    public void setEncoding(String string) {
        this._charsetName = string;
    }

    public File getDirectoryFile() {
        return this._directoryFile;
    }

    public String getPath() {
        return this._path;
    }

    public File getFile() {
        return this._file;
    }

    protected boolean exists() {
        return this._file.exists();
    }

    protected boolean isDirectory() {
        return this._file.isDirectory();
    }

    protected boolean createNewFile() throws IOException {
        return this._file.createNewFile();
    }

    protected TextBuffer getTextBuffer() throws IOException {
        if (this._textBuffer != null) {
            return this._textBuffer;
        }
        this._textBuffer = TextBufferFactory.createTextBuffer();
        if (this._file.exists()) {
            if (this._charsetName != null) {
                this._textBuffer.read(new InputStreamReader((InputStream)new FileInputStream(this._file), this._charsetName));
            } else {
                this._textBuffer.read(new FileReader(this._file));
            }
        }
        return this._textBuffer;
    }

    protected boolean saveTextBuffer() throws IOException {
        if (this._textBuffer == null) {
            throw new IllegalStateException();
        }
        if (!this._file.canWrite() && !this.setReadOnly(false)) {
            return false;
        }
        this._file.getParentFile().mkdirs();
        if (this._charsetName != null) {
            this._textBuffer.write(new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), this._charsetName));
        } else {
            this._textBuffer.write(new FileWriter(this._file));
        }
        return true;
    }

    protected String getBackupName() {
        return this._file.getName() + ".orig";
    }

    protected boolean createBackup(String string) throws IOException {
        File file = new File(this._file.getParent(), string);
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!this._file.exists()) {
            return file.createNewFile();
        }
        FileChannel fileChannel = new FileInputStream(this._file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        fileChannel.close();
        fileChannel2.close();
        return true;
    }

    protected boolean delete() {
        return this._file.delete();
    }

    protected boolean setLastModified(long l) {
        return this._file.setLastModified(l);
    }

    protected long lastModified() {
        return this._file.lastModified();
    }

    protected boolean setReadOnly(boolean bl) {
        return bl && this._file.setReadOnly();
    }

    protected String getRevision() {
        return null;
    }

    static final String convertToPatchSeparators(String string) {
        return string.replace(File.separatorChar, '/');
    }

    static final String convertToFileSeparators(String string) {
        return string.replace('/', File.separatorChar);
    }
}

