/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.resource;

import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.graphics.ImageUtils;

public class CommonIconsUtils {
    private static final String BUNDLE = "oracle.javatools.resource.CommonIcons";
    private static final HashMap cache = new HashMap();
    private static final String CHECKMARK_ICON_KEY = "CHECKMARK_ICON";
    private static final String ERROR_ICON_KEY = "ERROR_ICON";
    private static final String WARNING_ICON_KEY = "WARNING_ICON";
    private static final String PROPERTY_ICON_KEY = "PROPERTY_ICON";
    private static final String PROPERTY_XML_ICON_KEY = "XML_ICON";
    private static final String PROPERTY_XML_QUERY_ICON_KEY = "XML_QUERY_ICON";

    public static Icon getCheckmarkIcon() {
        return CommonIconsUtils.getImage(CHECKMARK_ICON_KEY);
    }

    public static Icon getErrorIcon() {
        return CommonIconsUtils.getImage(ERROR_ICON_KEY);
    }

    public static Icon getWarningIcon() {
        return CommonIconsUtils.getImage(WARNING_ICON_KEY);
    }

    public static Icon getPropertyIcon() {
        return CommonIconsUtils.getImage(PROPERTY_ICON_KEY);
    }

    public static Icon getXMLIcon() {
        return CommonIconsUtils.getImage(PROPERTY_XML_ICON_KEY);
    }

    public static Icon getXMLQueryIcon() {
        return CommonIconsUtils.getImage(PROPERTY_XML_QUERY_ICON_KEY);
    }

    private static ImageIcon getImage(String string) {
        ImageIcon imageIcon = (ImageIcon)cache.get(string);
        if (imageIcon == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE);
            String string2 = resourceBundle.getString(string);
            imageIcon = new ImageIcon(ImageUtils.getImageResource(CommonIconsUtils.class, (String)string2));
            cache.put(string, imageIcon);
        }
        return imageIcon;
    }
}

